let $scope;
let settings;
let prevFilterValue;

self.actionSources = function () {
  return {
    'rowClick': {
      name: 'widget-action.row-click',
      multiple: false
    },
    'dateSelected': {
      name: 'date-selected',
      multiple: false
    },
    'changedRadioButton': {
      name: 'changed-radio-button',
      multiple: false
    }
  };
}

self.onInit = function () {
  console.log('init component');
  $scope = self.ctx.$scope;
  $scope.ctx = self.ctx;
  $scope.jwt = self.getJwtToken();
  $scope.jwtRefresh = self.getRefreshToken();

  settings = JSON.parse(JSON.stringify($scope.ctx.settings)) || {};

  $scope.getJwtToken = self.getJwtToken;
  $scope.ctx.getJwtToken = self.getJwtToken;

  $scope.getRefreshToken = self.getRefreshToken;
  $scope.ctx.getRefreshToken = self.getRefreshToken;

  $scope.onDataChannleInit = self.onDataChannleInit;
  $scope.ctx.onDataChannleInit = self.onDataChannleInit;

  self.ctx.jwt = $scope.jwt;

  console.log('widgetJwt', self.getJwtToken());
  console.log('widgetRefresh', self.getRefreshToken());
}

self.onDataUpdated = function() {
  console.log('data updated');
  let newFilters = readFilterValues();

  if(prevFilterValue === newFilters) {
    return;
  }

  $scope.filterValue = newFilters;
  prevFilterValue = $scope.filterValue;
}

self.onDestroy = function () {
  console.log('destroy component');
}

self.onEditModeChanged = function (e) {
  console.log('edit mode changed', e, self.ctx.isEdit, self.ctx);
}

self.onResize = function () {
  console.log('on resize');
  if ($scope.subscriptionService) {
    $scope.subscriptionService.emit('parentResize', 'tb_dashboard', 'onResizeEvent');
    console.log('on resize transfered');
  }
}

self.onDataChannleInit = function (subscriptionService) {
  console.log('service received', subscriptionService);
  $scope.subscriptionService = subscriptionService;
}

function readFilterValues() {
  if(self.ctx && self.ctx.defaultSubscription && self.ctx.defaultSubscription.data && self.ctx.defaultSubscription.data.length > 0) {
    let filterValues = [];
    for(let i = 0; i<self.ctx.defaultSubscription.data.length; i++ ) {
      let value = getDescendantProp(self.ctx.defaultSubscription.data[i], 'data.0.1');
      if (value && value !== 'Unresolved') {
        filterValues.push(value);
      }
    }
    let fitlerObject = {};
    fitlerObject[settings.filterName] = filterValues;
    return fitlerObject;
  } else {
    console.log('trndz filter data blank', self.ctx.defaultSubscription);
    usePostMessage = false;
    return null;
  }
}

function getDescendantProp(obj, path) {
  return path.split('.').reduce((acc, part) => acc && acc[part], obj)
}

self.getRefreshToken = function () {
  let jwtToken = localStorage.getItem('refresh_token');
  if (jwtToken) {
    jwtToken = jwtToken.replaceAll('"', "");
    // console.log('tbwdgt refresh!', jwtToken);
    return jwtToken;
  }

  return 'unknwown';
}

self.getJwtToken = function () {
  let jwtToken = localStorage.getItem('jwt_token');
  if (jwtToken) {
    jwtToken = jwtToken.replaceAll('"', "");
    // console.log('tbwdgt jwt!', jwtToken);
    return jwtToken;
  }

  return 'unknwown';
}

self.useCustomDatasources = function() {
  return false;
};

self.typeParameters = function() {
  return {
    maxDatasources: 1,
    maxDataKeys: 1,
    singleEntity: false,
    useCustomDatasources: true
  };
};
