CREATE INDEX IF NOT EXISTS cluster_model_tenant_id_idx ON cluster_model (tenant_id);

CREATE INDEX IF NOT EXISTS point_to_cluster_example_id_idx ON scored_point_cluster (cluster_example_id);
CREATE INDEX IF NOT EXISTS histogram_to_cluster_info_id_idx ON scored_point_histogram (cluster_info_id);
CREATE INDEX IF NOT EXISTS centroid_to_cluster_info_id_idx ON scored_point_centroid (cluster_info_id);
CREATE INDEX IF NOT EXISTS point_to_anomaly_id_idx ON scored_point_anomaly (anomaly_id);

CREATE INDEX IF NOT EXISTS cluster_ex_to_info_idx ON cluster_example (cluster_info_id);
CREATE INDEX IF NOT EXISTS cluster_info_to_model_idx ON cluster_info (cluster_model_id);

CREATE INDEX IF NOT EXISTS anomaly_item_id_idx ON anomaly (item_id);
CREATE INDEX IF NOT EXISTS anomaly_model_id_idx ON anomaly (model_id);
CREATE INDEX IF NOT EXISTS anomaly_task_id_idx ON anomaly (task_id);
CREATE INDEX IF NOT EXISTS anomaly_start_ts_idx ON anomaly (start_ts);
CREATE INDEX IF NOT EXISTS anomaly_end_ts_idx ON anomaly (end_ts);
CREATE INDEX IF NOT EXISTS anomaly_score_idx ON anomaly (score);

CREATE INDEX IF NOT EXISTS business_entity_tenant_id_idx ON business_entity (tenant_id);
CREATE INDEX IF NOT EXISTS view_config_tenant_id_idx ON view_config (tenant_id);
CREATE INDEX IF NOT EXISTS view_config_task_id_idx ON view_config (task_id);
CREATE INDEX IF NOT EXISTS view_field_to_view_config_idx ON view_field (view_config_id);
CREATE INDEX IF NOT EXISTS view_field_to_dataset_config_idx ON view_field (dataset_config_id);

CREATE INDEX IF NOT EXISTS cached_telemetry_id_idx                          ON cached_telemetry (id);
CREATE INDEX IF NOT EXISTS cached_telemetry_item_id_idx                     ON cached_telemetry (item_id);
CREATE INDEX IF NOT EXISTS cached_telemetry_tenant_id_idx                   ON cached_telemetry (tenant_id);
CREATE INDEX IF NOT EXISTS cached_telemetry_end_ts_idx                      ON cached_telemetry (end_ts);
CREATE INDEX IF NOT EXISTS cached_telemetry_start_ts_idx                    ON cached_telemetry (start_ts);
CREATE INDEX IF NOT EXISTS cached_telemetry_field_aggregation_idx           ON cached_telemetry (field_aggregation);
CREATE INDEX IF NOT EXISTS cached_telemetry_date_aggregation_type_idx       ON cached_telemetry (date_aggregation_type);
CREATE INDEX IF NOT EXISTS cached_telemetry_business_entity_field_id_idx    ON cached_telemetry (business_entity_field_id);
CREATE INDEX IF NOT EXISTS cached_telemetry_function_idx                    ON cached_telemetry (function);

CREATE INDEX IF NOT EXISTS cached_telemetry_point_ts_idx                    ON cached_telemetry_point (ts);
CREATE INDEX IF NOT EXISTS cached_telemetry_point_cached_telemetry_id_idx   ON cached_telemetry_point (cached_telemetry_id);

CREATE INDEX IF NOT EXISTS scheduled_task_tenant_id_idx                     ON scheduled_task (tenant_id);
CREATE INDEX IF NOT EXISTS scheduled_job_task_id_idx                        ON scheduled_job (task_id);
CREATE INDEX IF NOT EXISTS scheduled_task_history_scheduled_task_id_idx     ON scheduled_task_history_record (scheduled_task_id);
