/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.thingsboard.license.client.TbLicenseClient;
import org.thingsboard.license.client.TbLicenseClientListener;
import org.thingsboard.license.shared.exception.LicenseErrorCode;
import org.thingsboard.license.shared.exception.LicenseException;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;

@Service
@Profile(value={"!install"})
public class BaseSubscriptionService
implements SubscriptionService,
TbLicenseClientListener {
    private static final Logger log = LoggerFactory.getLogger(BaseSubscriptionService.class);
    private static final String MAX_DEVICES_KEY = "device_count";
    private static final String MAX_ASSETS_KEY = "asset_count";
    private static final long CHECK_INTERVAL = TimeUnit.HOURS.toMillis(12L);
    private static final long INTERNAL_CHECK_INTERVAL = TimeUnit.HOURS.toMillis(2L);
    @Value(value="${license.secret}")
    private String licenseSecret;
    @Value(value="${license.instance_data_file:trndz-instance-license.data}")
    private String instanceDataFilePath;
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private TbAssetService assetService;
    @Autowired
    private TbDeviceService deviceService;
    private volatile SubscriptionState subscriptionState;
    private volatile long chekTriggeredAt;
    private TbLicenseClient tbLicenseClient;
    private ExecutorService scheduler = Executors.newSingleThreadExecutor();

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((Object)this.licenseSecret)) {
            log.error("License secret is not provided!");
            log.error("Please provide license.secret property value in trendz.yml or set TRENDZ_LICENSE_SECRET environment variable!");
            this.doExit(-1, LicenseErrorCode.GENERAL_ERROR, false);
        } else {
            try {
                this.tbLicenseClient = TbLicenseClient.builder().listener((TbLicenseClientListener)this).licenseSecret(this.licenseSecret).licenseDataFilePath(this.instanceDataFilePath).releaseDate(new SimpleDateFormat("yyyy-MM-dd").parse("2021-09-30").getTime()).build();
                this.tbLicenseClient.init();
            }
            catch (Exception e) {
                log.error("Failed to init license client", (Throwable)e);
                LicenseErrorCode licenseErrorCode = e instanceof LicenseException ? ((LicenseException)e).getErrorCode() : LicenseErrorCode.GENERAL_ERROR;
                this.doExit(-1, licenseErrorCode, false);
            }
        }
        this.subscriptionState = new SubscriptionState();
        this.subscriptionState.setValid(true);
    }

    @PreDestroy
    public void stop() {
        if (this.tbLicenseClient != null) {
            this.tbLicenseClient.stop();
        }
        this.scheduler.shutdownNow();
    }

    public SubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    public void triggerCheck(String jwtToken) {
        if (System.currentTimeMillis() - this.subscriptionState.getCheckTs() > CHECK_INTERVAL && System.currentTimeMillis() - this.chekTriggeredAt > INTERNAL_CHECK_INTERVAL) {
            this.chekTriggeredAt = System.currentTimeMillis();
            this.scheduler.submit(() -> {
                try {
                    log.debug("Validate subscription. Last check triggered at {} . Current state {}", (Object)this.chekTriggeredAt, (Object)this.subscriptionState);
                    this.subscriptionState = this.checkSubscription(jwtToken);
                    log.info("Subscription validated {}", (Object)this.subscriptionState);
                }
                catch (RuntimeException re) {
                    log.error("Could not validate subscription", (Throwable)re);
                }
            });
        }
    }

    private SubscriptionState checkSubscription(String jwtToken) {
        String msg;
        SubscriptionState state = new SubscriptionState();
        state.setValid(true);
        state.setActualDevices(this.countDevices(jwtToken));
        state.setActualAssets(this.countAssets(jwtToken));
        state.setAllowedDevices(this.tbLicenseClient.getPlanLongValue(MAX_DEVICES_KEY));
        state.setAllowedAssets(this.tbLicenseClient.getPlanLongValue(MAX_ASSETS_KEY));
        if (state.getAllowedDevices() > 0L && state.getAllowedDevices() < state.getActualDevices()) {
            msg = "Maximum allowed devices limit reached! Current " + state.getActualDevices() + " but allowed " + state.getAllowedDevices();
            log.error(msg);
            state.setValid(false);
            state.setErrorMsg(msg);
        }
        if (state.getAllowedAssets() > 0L && state.getAllowedAssets() < state.getActualAssets()) {
            msg = "Maximum allowed assets limit reached! Current " + state.getActualAssets() + " but allowed " + state.getAllowedAssets();
            log.error(msg);
            state.setValid(false);
            state.setErrorMsg(msg);
        }
        state.setCheckTs(System.currentTimeMillis());
        return state;
    }

    public void onError(TbLicenseClient tbLicenseClient, LicenseException e) {
        log.error("License Error occurred: {}({}) - {}", new Object[]{e.getErrorCode(), e.getErrorCode().getErrorCode(), e.getMessage()});
        if (e.isCritical()) {
            this.doExit(-1, e.getErrorCode(), true);
        }
    }

    private long countDevices(String jwtToken) {
        long count = 0L;
        Set deviceTypes = this.deviceService.loadDeviceTypes(jwtToken);
        for (String deviceType : deviceTypes) {
            count += (long)this.deviceService.loadDeviceByType(deviceType, jwtToken).size();
        }
        return count;
    }

    private long countAssets(String jwtToken) {
        long count = 0L;
        Set assetTypes = this.assetService.loadAssetTypes(jwtToken);
        for (String assetType : assetTypes) {
            count += (long)this.assetService.loadAssetByType(assetType, jwtToken).size();
        }
        return count;
    }

    private void doExit(int exitCode, LicenseErrorCode licenseErrorCode, boolean gracefullShutdown) {
        new Thread(() -> {
            log.info("Terminating application due to critical License Error {}({}), exit code [{}]...", new Object[]{licenseErrorCode, licenseErrorCode.getErrorCode(), exitCode});
            int appExitCode = exitCode;
            try {
                if (gracefullShutdown) {
                    appExitCode = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> exitCode});
                }
            }
            finally {
                System.exit(appExitCode);
            }
        }, "Shutdown Thread").start();
    }
}

