/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;

public class ViewRequest {
    private UUID rootEntityId;
    private UUID rowClickEntityId;
    private List<ViewField> fields;
    private List<ViewField> dateAggregationFields;
    private List<ViewField> stateFields;
    private List<RuntimeFilterField> runtimeFilters;
    private DatePickerConfig datePickerConfig;
    private DateAggregationType minimalDateAggregation;
    private long startTs;
    private long endTs;
    private String tzName;
    private JsonNode settings;
    private boolean streamProcessingEnabled;
    private boolean cacheItemTelemetry;
    private boolean ownerRequired;
    private boolean splitStates;
    private boolean fillGap;
    private boolean usePersistedCacheTelemetry;
    private DateAggregationType cachingDateAggregationType;

    public ViewRequest() {
    }

    public ViewRequest(ViewRequest that) {
        this.rootEntityId = that.rootEntityId;
        this.rowClickEntityId = that.rowClickEntityId;
        this.fields = that.fields;
        this.dateAggregationFields = that.dateAggregationFields;
        this.stateFields = that.stateFields;
        this.runtimeFilters = that.runtimeFilters;
        this.datePickerConfig = that.datePickerConfig;
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.tzName = that.tzName;
        this.settings = that.settings;
        this.streamProcessingEnabled = that.streamProcessingEnabled;
        this.cacheItemTelemetry = that.cacheItemTelemetry;
        this.ownerRequired = that.ownerRequired;
        this.splitStates = that.splitStates;
        this.fillGap = that.fillGap;
        this.minimalDateAggregation = that.minimalDateAggregation;
        this.usePersistedCacheTelemetry = that.usePersistedCacheTelemetry;
        this.cachingDateAggregationType = that.cachingDateAggregationType;
    }

    public ViewRequest(ViewConfig config) {
        this.rootEntityId = config.getRootEntityId();
        this.rowClickEntityId = config.getRowClickEntityId();
        this.datePickerConfig = config.getDatePickerConfig();
        Pair startEndPair = this.datePickerConfig.buildStartEndPair(config.getTzName());
        this.validateTimeRange(((Long)startEndPair.getLeft()).longValue(), ((Long)startEndPair.getRight()).longValue());
        this.startTs = (Long)startEndPair.getLeft();
        this.endTs = (Long)startEndPair.getRight();
        this.tzName = config.getTzName();
        this.runtimeFilters = config.getRuntimeFilters();
        this.settings = config.getSettings();
        this.fields = Lists.newArrayList();
        this.fields.addAll(config.getyAxis());
        this.fields.addAll(config.getxAxis());
        this.fields.addAll(config.getSeries());
        this.fields.addAll(config.getHiddenFields());
        this.stateFields = this.fields.stream().filter(ViewField::isStateField).collect(Collectors.toList());
        if (this.shouldSplitStates(this.stateFields, config)) {
            this.splitStates = true;
        }
        this.dateAggregationFields = Lists.newArrayList((Iterable)this.fields.stream().filter(ViewField::isVirtualDateField).collect(Collectors.toList()));
        this.fields = Lists.newArrayList((Iterable)this.fields.stream().filter(f -> !f.isVirtualDateField()).filter(f -> !f.isCalculatedField() || f.isBatchCalculation()).collect(Collectors.toList()));
        this.streamProcessingEnabled = false;
        this.cacheItemTelemetry = false;
        this.minimalDateAggregation = this.defineMinDateAggregation();
        CacheSettings cacheSettings = config.getCacheSettings();
        this.usePersistedCacheTelemetry = cacheSettings.isUsePersistedCacheTelemetry();
        this.cachingDateAggregationType = cacheSettings.getCachingDateAggregation();
        this.fillGap = config.getViewType() == ViewType.HEATMAP;
    }

    private DateAggregationType defineMinDateAggregation() {
        String rangeBy;
        DateAggregationType minType = null;
        if (!CollectionUtils.isEmpty((Collection)this.dateAggregationFields)) {
            DateAggregationType[] values = DateAggregationType.values();
            Set availableGroups = this.dateAggregationFields.stream().map(ViewField::getDateGrouping).collect(Collectors.toSet());
            for (DateAggregationType value : values) {
                if (!availableGroups.contains(value)) continue;
                minType = value;
                break;
            }
        }
        if (minType == DateAggregationType.RAW && StringUtils.isNotBlank((CharSequence)(rangeBy = this.datePickerConfig.getRangeBy()))) {
            if ("minute".equals(rangeBy)) {
                return DateAggregationType.MINUTE;
            }
            if ("hour".equals(rangeBy)) {
                return DateAggregationType.HOUR;
            }
            if ("day".equals(rangeBy)) {
                return DateAggregationType.DAY;
            }
            if ("week".equals(rangeBy)) {
                return DateAggregationType.WEEK_OF_YEAR;
            }
            if ("month".equals(rangeBy)) {
                return DateAggregationType.MONTH;
            }
        }
        return minType;
    }

    private boolean shouldSplitStates(List<ViewField> fields, ViewConfig config) {
        if (fields.size() == 1 && config.getViewType() == ViewType.LINE) {
            ViewField stateField = (ViewField)this.stateFields.get(0);
            if (config.getxAxis().indexOf(stateField) >= 0 && stateField.getAggregationType() == FieldAggregation.NONE) {
                return true;
            }
        }
        return fields.size() == 2 && fields.stream().anyMatch(f -> f.getAggregationType() == FieldAggregation.UNIQ) && fields.stream().anyMatch(f -> f.getAggregationType() == FieldAggregation.NONE);
    }

    private void validateTimeRange(long start, long end) {
        if (start == 0L || end == 0L || start >= end) {
            throw new IllegalStateException("Time range not valid " + start + " " + end);
        }
    }

    @JsonIgnore
    public DateAggregationType getCachingDateAggregationType() {
        HashSet options = Sets.newHashSet((Object[])new DateAggregationType[]{DateAggregationType.getFullType((DateAggregationType)this.cachingDateAggregationType), DateAggregationType.getFullType((DateAggregationType)this.minimalDateAggregation)});
        for (DateAggregationType value : DateAggregationType.values()) {
            if (!options.contains(value)) continue;
            return value;
        }
        return null;
    }

    @JsonIgnore
    public boolean isCacheRequired() {
        HashMap fieldMap = new HashMap();
        this.getFields().forEach(f -> {
            fieldMap.computeIfAbsent(f.getEntityFieldId(), i -> new AtomicInteger()).incrementAndGet();
            if (MapUtils.isNotEmpty((Map)f.getConditionFieldIds())) {
                f.getConditionFieldIds().values().forEach(cf -> fieldMap.computeIfAbsent(f.getEntityFieldId(), i -> new AtomicInteger()).incrementAndGet());
            }
        });
        return fieldMap.entrySet().stream().anyMatch(e -> ((AtomicInteger)e.getValue()).get() > 1);
    }

    @JsonIgnore
    public Set<UUID> getAdditionalEntityIds() {
        HashSet ids = Sets.newHashSet();
        JsonNode settings = this.getSettings();
        JsonNode missedGraphEntities = settings.get("missedGraphEntities");
        if (missedGraphEntities != null && !missedGraphEntities.isMissingNode()) {
            for (JsonNode node : missedGraphEntities) {
                UUID uuid = UUID.fromString(node.textValue());
                ids.add(uuid);
            }
        }
        return ids;
    }

    public UUID getRootEntityId() {
        return this.rootEntityId;
    }

    public UUID getRowClickEntityId() {
        return this.rowClickEntityId;
    }

    public List<ViewField> getFields() {
        return this.fields;
    }

    public List<ViewField> getDateAggregationFields() {
        return this.dateAggregationFields;
    }

    public List<ViewField> getStateFields() {
        return this.stateFields;
    }

    public List<RuntimeFilterField> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public DatePickerConfig getDatePickerConfig() {
        return this.datePickerConfig;
    }

    public DateAggregationType getMinimalDateAggregation() {
        return this.minimalDateAggregation;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public String getTzName() {
        return this.tzName;
    }

    public JsonNode getSettings() {
        return this.settings;
    }

    public boolean isStreamProcessingEnabled() {
        return this.streamProcessingEnabled;
    }

    public boolean isCacheItemTelemetry() {
        return this.cacheItemTelemetry;
    }

    public boolean isOwnerRequired() {
        return this.ownerRequired;
    }

    public boolean isSplitStates() {
        return this.splitStates;
    }

    public boolean isFillGap() {
        return this.fillGap;
    }

    public boolean isUsePersistedCacheTelemetry() {
        return this.usePersistedCacheTelemetry;
    }

    public void setRootEntityId(UUID rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public void setRowClickEntityId(UUID rowClickEntityId) {
        this.rowClickEntityId = rowClickEntityId;
    }

    public void setFields(List<ViewField> fields) {
        this.fields = fields;
    }

    public void setDateAggregationFields(List<ViewField> dateAggregationFields) {
        this.dateAggregationFields = dateAggregationFields;
    }

    public void setStateFields(List<ViewField> stateFields) {
        this.stateFields = stateFields;
    }

    public void setRuntimeFilters(List<RuntimeFilterField> runtimeFilters) {
        this.runtimeFilters = runtimeFilters;
    }

    public void setDatePickerConfig(DatePickerConfig datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    public void setMinimalDateAggregation(DateAggregationType minimalDateAggregation) {
        this.minimalDateAggregation = minimalDateAggregation;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public void setSettings(JsonNode settings) {
        this.settings = settings;
    }

    public void setStreamProcessingEnabled(boolean streamProcessingEnabled) {
        this.streamProcessingEnabled = streamProcessingEnabled;
    }

    public void setCacheItemTelemetry(boolean cacheItemTelemetry) {
        this.cacheItemTelemetry = cacheItemTelemetry;
    }

    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    public void setSplitStates(boolean splitStates) {
        this.splitStates = splitStates;
    }

    public void setFillGap(boolean fillGap) {
        this.fillGap = fillGap;
    }

    public void setUsePersistedCacheTelemetry(boolean usePersistedCacheTelemetry) {
        this.usePersistedCacheTelemetry = usePersistedCacheTelemetry;
    }

    public void setCachingDateAggregationType(DateAggregationType cachingDateAggregationType) {
        this.cachingDateAggregationType = cachingDateAggregationType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewRequest)) {
            return false;
        }
        ViewRequest other = (ViewRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$rootEntityId = this.getRootEntityId();
        UUID other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !((Object)this$rootEntityId).equals(other$rootEntityId)) {
            return false;
        }
        UUID this$rowClickEntityId = this.getRowClickEntityId();
        UUID other$rowClickEntityId = other.getRowClickEntityId();
        if (this$rowClickEntityId == null ? other$rowClickEntityId != null : !((Object)this$rowClickEntityId).equals(other$rowClickEntityId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List this$dateAggregationFields = this.getDateAggregationFields();
        List other$dateAggregationFields = other.getDateAggregationFields();
        if (this$dateAggregationFields == null ? other$dateAggregationFields != null : !((Object)this$dateAggregationFields).equals(other$dateAggregationFields)) {
            return false;
        }
        List this$stateFields = this.getStateFields();
        List other$stateFields = other.getStateFields();
        if (this$stateFields == null ? other$stateFields != null : !((Object)this$stateFields).equals(other$stateFields)) {
            return false;
        }
        List this$runtimeFilters = this.getRuntimeFilters();
        List other$runtimeFilters = other.getRuntimeFilters();
        if (this$runtimeFilters == null ? other$runtimeFilters != null : !((Object)this$runtimeFilters).equals(other$runtimeFilters)) {
            return false;
        }
        DatePickerConfig this$datePickerConfig = this.getDatePickerConfig();
        DatePickerConfig other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        DateAggregationType this$minimalDateAggregation = this.getMinimalDateAggregation();
        DateAggregationType other$minimalDateAggregation = other.getMinimalDateAggregation();
        if (this$minimalDateAggregation == null ? other$minimalDateAggregation != null : !this$minimalDateAggregation.equals(other$minimalDateAggregation)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        JsonNode this$settings = this.getSettings();
        JsonNode other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        if (this.isStreamProcessingEnabled() != other.isStreamProcessingEnabled()) {
            return false;
        }
        if (this.isCacheItemTelemetry() != other.isCacheItemTelemetry()) {
            return false;
        }
        if (this.isOwnerRequired() != other.isOwnerRequired()) {
            return false;
        }
        if (this.isSplitStates() != other.isSplitStates()) {
            return false;
        }
        if (this.isFillGap() != other.isFillGap()) {
            return false;
        }
        if (this.isUsePersistedCacheTelemetry() != other.isUsePersistedCacheTelemetry()) {
            return false;
        }
        DateAggregationType this$cachingDateAggregationType = this.getCachingDateAggregationType();
        DateAggregationType other$cachingDateAggregationType = other.getCachingDateAggregationType();
        return !(this$cachingDateAggregationType == null ? other$cachingDateAggregationType != null : !this$cachingDateAggregationType.equals(other$cachingDateAggregationType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : ((Object)$rootEntityId).hashCode());
        UUID $rowClickEntityId = this.getRowClickEntityId();
        result = result * 59 + ($rowClickEntityId == null ? 43 : ((Object)$rowClickEntityId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List $dateAggregationFields = this.getDateAggregationFields();
        result = result * 59 + ($dateAggregationFields == null ? 43 : ((Object)$dateAggregationFields).hashCode());
        List $stateFields = this.getStateFields();
        result = result * 59 + ($stateFields == null ? 43 : ((Object)$stateFields).hashCode());
        List $runtimeFilters = this.getRuntimeFilters();
        result = result * 59 + ($runtimeFilters == null ? 43 : ((Object)$runtimeFilters).hashCode());
        DatePickerConfig $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        DateAggregationType $minimalDateAggregation = this.getMinimalDateAggregation();
        result = result * 59 + ($minimalDateAggregation == null ? 43 : $minimalDateAggregation.hashCode());
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        JsonNode $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        result = result * 59 + (this.isStreamProcessingEnabled() ? 79 : 97);
        result = result * 59 + (this.isCacheItemTelemetry() ? 79 : 97);
        result = result * 59 + (this.isOwnerRequired() ? 79 : 97);
        result = result * 59 + (this.isSplitStates() ? 79 : 97);
        result = result * 59 + (this.isFillGap() ? 79 : 97);
        result = result * 59 + (this.isUsePersistedCacheTelemetry() ? 79 : 97);
        DateAggregationType $cachingDateAggregationType = this.getCachingDateAggregationType();
        result = result * 59 + ($cachingDateAggregationType == null ? 43 : $cachingDateAggregationType.hashCode());
        return result;
    }

    public String toString() {
        return "ViewRequest(rootEntityId=" + this.getRootEntityId() + ", rowClickEntityId=" + this.getRowClickEntityId() + ", fields=" + this.getFields() + ", dateAggregationFields=" + this.getDateAggregationFields() + ", stateFields=" + this.getStateFields() + ", runtimeFilters=" + this.getRuntimeFilters() + ", datePickerConfig=" + this.getDatePickerConfig() + ", minimalDateAggregation=" + this.getMinimalDateAggregation() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", tzName=" + this.getTzName() + ", settings=" + this.getSettings() + ", streamProcessingEnabled=" + this.isStreamProcessingEnabled() + ", cacheItemTelemetry=" + this.isCacheItemTelemetry() + ", ownerRequired=" + this.isOwnerRequired() + ", splitStates=" + this.isSplitStates() + ", fillGap=" + this.isFillGap() + ", usePersistedCacheTelemetry=" + this.isUsePersistedCacheTelemetry() + ", cachingDateAggregationType=" + this.getCachingDateAggregationType() + ")";
    }
}

