/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Mono;

@Service
public class TelemetryCachePreloader {
    private static final Logger log = LoggerFactory.getLogger(TelemetryCachePreloader.class);
    @Autowired
    private CachedTelemetryService cachedTelemetryService;
    @Autowired
    private ItemDataLoader itemDataLoader;

    public Mono<List<Item>> preloadCache(List<Item> collectedItems, ViewRequest request, ViewField viewField, ViewContext ctx) {
        if (!request.isUsePersistedCacheTelemetry() || !this.itemDataLoader.isPossibleToUseTelemetryCache(request, viewField)) {
            return Mono.just(collectedItems);
        }
        Set itemIds = collectedItems.stream().map(Item::getId).filter(id -> !ctx.getPreloadedCache().containsCache(viewField, id)).collect(Collectors.toSet());
        return this.cachedTelemetryService.loadAllCompatibleCachedTelemetry(itemIds, request.getStartTs(), request.getEndTs(), viewField, request.getCachingDateAggregationType()).map(cachedTelemetryList -> {
            for (CachedTelemetry cache : cachedTelemetryList) {
                ctx.getPreloadedCache().addCache(viewField, cache.getItemId(), cache);
            }
            return collectedItems;
        });
    }
}

