/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.cache.PreloadedCache;
import org.thingsboard.trendz.service.cache.TimeRange;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregationServiceImpl;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TelemetryCacheLoader
extends ItemDataLoader {
    private static final Logger log = LoggerFactory.getLogger(TelemetryCacheLoader.class);
    @Autowired
    private CachedTelemetryService cachedTelemetryService;
    @Autowired
    private AggregationServiceImpl aggregationService;

    public Flux<FieldValue> loadItemFieldValue(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long startTs = System.currentTimeMillis();
        return this.loadCompatibleCaches(item.getId(), request.getStartTs(), request.getEndTs(), viewField, request.getCachingDateAggregationType(), ctx).flatMap(cachedTelemetries -> {
            if (cachedTelemetries.isEmpty()) {
                return this.loadDataWithoutCache(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
            }
            return this.loadDataWithCache(cachedTelemetries, item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
        }).doOnNext(fieldValueList -> log.debug("TelemetryCacheLoader: Loading data spent time: {}", (Object)(System.currentTimeMillis() - startTs))).flatMapIterable(list -> list);
    }

    private Mono<List<CachedTelemetry>> loadCompatibleCaches(UUID itemId, long startTs, long endTs, ViewField viewField, DateAggregationType cachingDateAggregation, ViewContext ctx) {
        PreloadedCache preloadedCache = ctx.getPreloadedCache();
        if (preloadedCache.containsCache(viewField, itemId)) {
            List cache = preloadedCache.getCache(viewField, itemId);
            return Mono.just((Object)cache);
        }
        return this.cachedTelemetryService.loadAllCompatibleCachedTelemetry((Set)Sets.newHashSet((Object[])new UUID[]{itemId}), startTs, endTs, viewField, cachingDateAggregation);
    }

    private Mono<List<FieldValue>> loadDataWithoutCache(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.debug("There is no compatible cached telemetries, loading data from TB...");
        ViewRequest modifiedRequest = new ViewRequest(viewRequest);
        modifiedRequest.setFillGap(false);
        List dateAggregationField = this.getCachingDateAggregationFieldList(modifiedRequest.getCachingDateAggregationType());
        return this.loadDataFromTb(item, viewField, modifiedRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId).collectList().flatMap(loadedData -> this.aggregationService.preagregate(loadedData, viewField, modifiedRequest, modifiedRequest.getCachingDateAggregationType(), dateAggregationField, entityField, ctx, methodId).collectList()).flatMap(loadedData -> this.persistNewCachedTelemetry(loadedData, item.getId(), modifiedRequest, viewField, ctx));
    }

    private Mono<List<FieldValue>> loadDataWithCache(List<CachedTelemetry> cachedTelemetries, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long queriedStartTs = viewRequest.getStartTs();
        long queriedEndTs = viewRequest.getEndTs();
        CachedTelemetry resultCachedTelemetry = this.cachedTelemetryService.mergeCachedTelemetries(cachedTelemetries, ctx.getTenantId());
        List gapsTimeRangeList = this.cachedTelemetryService.findGapsBetweenCaches(cachedTelemetries, queriedStartTs, queriedEndTs);
        return this.loadDataForGaps(gapsTimeRangeList, item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId).map(loadedDataForGaps -> {
            log.trace("loadedDataForGaps: item {}, gap list {}", (Object)item.getName(), (Object)gapsTimeRangeList);
            return this.uniteMergedCacheAndGapData(resultCachedTelemetry, loadedDataForGaps);
        }).flatMap(allPoints -> {
            if (cachedTelemetries.size() > 1 || !gapsTimeRangeList.isEmpty()) {
                long finalStartTs = Math.min(queriedStartTs, resultCachedTelemetry.getStartTs());
                long finalEndTs = Math.max(queriedEndTs, resultCachedTelemetry.getEndTs());
                resultCachedTelemetry.setStartTs(finalStartTs);
                resultCachedTelemetry.setEndTs(finalEndTs);
                ctx.getPreloadedCache().resetCache(viewField, item.getId());
                ctx.getPreloadedCache().addCache(viewField, item.getId(), resultCachedTelemetry);
                return this.persistRefreshedCachedTelemetry(resultCachedTelemetry, cachedTelemetries);
            }
            return Mono.just((Object)allPoints);
        }).map(allPoints -> this.filterCachePointsForGivenRequest(allPoints, queriedStartTs, queriedEndTs)).map(resultPoints -> this.mapToFieldValues(resultPoints, item, resultCachedTelemetry.getFieldType()));
    }

    private Mono<List<FieldValue>> loadDataForGaps(List<TimeRange> gapsTimeRangeList, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        return Flux.fromIterable(gapsTimeRangeList).flatMap(timeRange -> this.loadDataByRequestAndGivenTimeRange(timeRange, item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId)).flatMapIterable(i -> i).collectList();
    }

    private Mono<List<FieldValue>> loadDataByRequestAndGivenTimeRange(TimeRange timeRange, Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        ViewRequest modifiedRequest = new ViewRequest(viewRequest);
        modifiedRequest.setStartTs(timeRange.getStartTs());
        modifiedRequest.setEndTs(timeRange.getEndTs());
        modifiedRequest.setFillGap(false);
        List dateAggregationField = this.getCachingDateAggregationFieldList(viewRequest.getCachingDateAggregationType());
        return this.loadDataFromTb(item, viewField, modifiedRequest, windowedStreamStore, entityField, businessEntity, ctx, methodId).collectList().flatMap(loadedData -> this.aggregationService.preagregate(loadedData, viewField, modifiedRequest, viewRequest.getCachingDateAggregationType(), dateAggregationField, entityField, ctx, methodId).collectList());
    }

    private List<ViewField> getCachingDateAggregationFieldList(DateAggregationType cachingDateAggregationType) {
        ViewField field = new ViewField();
        field.setVirtualDateField(true);
        field.setDateGrouping(cachingDateAggregationType);
        return Collections.singletonList(field);
    }

    private Mono<List<FieldValue>> persistNewCachedTelemetry(List<FieldValue> loadedData, UUID itemId, ViewRequest viewRequest, ViewField viewField, ViewContext ctx) {
        FieldType fieldType = this.getFieldTypeOfData(loadedData);
        long uploadTime = System.currentTimeMillis();
        List loadedPoints = fieldType == FieldType.BLANK ? Collections.emptyList() : this.mapToCachePoints(loadedData);
        String function = CachedTelemetryService.getFunctionFromField((ViewField)viewField);
        CachedTelemetry cachedTelemetry = CachedTelemetry.builder().itemId(itemId).tenantId(ctx.getTenantId().getId()).uploadTime(uploadTime).calculatedField(viewField.isCalculatedField()).stateField(viewField.isStateField()).startTs(viewRequest.getStartTs()).endTs(viewRequest.getEndTs()).fieldType(fieldType).fieldAggregation(viewField.getAggregationType()).dateAggregationType(viewRequest.getCachingDateAggregationType()).businessEntityId(viewField.getBusinessEntityId()).businessEntityFieldId(viewField.getEntityFieldId()).calculatedOrStateFunction(function).points(loadedPoints).build();
        ctx.getPreloadedCache().addCache(viewField, itemId, cachedTelemetry);
        return this.cachedTelemetryService.persistTelemetry(cachedTelemetry).map(boolObj -> loadedData);
    }

    private Mono<List<CachedTelemetryPoint>> persistRefreshedCachedTelemetry(CachedTelemetry resultCachedTelemetry, List<CachedTelemetry> cachedTelemetries) {
        return this.cachedTelemetryService.persistCashAndRemoveOthers(resultCachedTelemetry, cachedTelemetries).map(boolObj -> resultCachedTelemetry.getPoints());
    }

    private List<CachedTelemetryPoint> filterCachePointsForGivenRequest(List<CachedTelemetryPoint> points, long startTs, long endTs) {
        return points.stream().filter(point -> startTs <= point.getTs() && point.getTs() < endTs).collect(Collectors.toList());
    }

    private List<CachedTelemetryPoint> uniteMergedCacheAndGapData(CachedTelemetry mergedCache, List<FieldValue> loadedDataForGaps) {
        List allPoints = mergedCache.getPoints();
        if (allPoints.isEmpty() && !loadedDataForGaps.isEmpty()) {
            FieldType type = this.getFieldTypeOfData(loadedDataForGaps);
            mergedCache.setFieldType(type);
        }
        List loadedPointsForGaps = this.mapToCachePoints(loadedDataForGaps);
        allPoints.addAll(loadedPointsForGaps);
        allPoints.sort(Comparator.comparingLong(CachedTelemetryPoint::getTs));
        this.checkDuplicatePoints(allPoints);
        return allPoints;
    }

    private List<CachedTelemetryPoint> mapToCachePoints(List<FieldValue> fieldValues) {
        boolean isBlankList = fieldValues.stream().allMatch(fieldValue -> fieldValue.getFieldType() == FieldType.BLANK);
        if (isBlankList) {
            return new ArrayList<CachedTelemetryPoint>();
        }
        return fieldValues.stream().map(fieldValue -> new CachedTelemetryPoint(fieldValue.getTs(), fieldValue.getInnerValue())).collect(Collectors.toList());
    }

    private List<FieldValue> mapToFieldValues(List<CachedTelemetryPoint> points, Item item, FieldType fieldType) {
        if (CollectionUtils.isEmpty(points)) {
            return Lists.newArrayList((Object[])new FieldValue[]{new FieldValue(item, FieldType.BLANK, null)});
        }
        return points.stream().map(point -> new FieldValue(item, fieldType, point.getValue(), point.getTs())).collect(Collectors.toList());
    }

    private FieldType getFieldTypeOfData(List<FieldValue> data) {
        if (data.isEmpty()) {
            throw new IllegalStateException("Wrong data processing detected - empty value list loaded");
        }
        boolean isBlankList = data.stream().allMatch(fieldValue -> fieldValue.getFieldType() == FieldType.BLANK);
        boolean atLeastOneBlankValue = data.stream().anyMatch(fieldValue -> fieldValue.getFieldType() == FieldType.BLANK);
        if (atLeastOneBlankValue && !isBlankList) {
            throw new IllegalStateException("Wrong data processing detected - there is mix of blank and other values");
        }
        if (isBlankList) {
            return FieldType.BLANK;
        }
        return data.get(0).getFieldType();
    }

    private void checkDuplicatePoints(List<CachedTelemetryPoint> points) {
        for (int i = 0; i < points.size() - 1; ++i) {
            if (Long.compare(points.get(i).getTs(), points.get(i + 1).getTs()) != 0) continue;
            throw new IllegalStateException("There are duplicates on index " + i + ": " + points.get(i) + ", " + points.get(i + 1));
        }
    }
}

