/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;

public class StreamTelemetryStore {
    private static final Logger log = LoggerFactory.getLogger(StreamTelemetryStore.class);
    private final Map<UUID, Set<UUID>> itemsByBusinessEntity = new ConcurrentHashMap();
    private final Map<String, List<FieldValue>> valuesByItem = new ConcurrentHashMap();
    private final Map<String, CountDownLatch> loadingLocks = new ConcurrentHashMap();

    public void add(BusinessEntity be, Item item, FieldAggregation aggr, FieldValue fValue) {
        Set items = this.itemsByBusinessEntity.computeIfAbsent(be.getId(), id -> new HashSet());
        items.add(item.getId());
        String key = item.getId() + "_" + aggr.name();
        List itemValues = this.valuesByItem.computeIfAbsent(key, id -> new ArrayList());
        itemValues.add(fValue);
    }

    public synchronized Optional<CountDownLatch> getLoadLock(Item item, FieldAggregation aggr) {
        String key = item.getId() + "_" + aggr.name();
        return Optional.ofNullable(this.loadingLocks.putIfAbsent(key, new CountDownLatch(1)));
    }

    public Map<UUID, Set<UUID>> getItemsByBusinessEntity() {
        return this.itemsByBusinessEntity;
    }

    public Map<String, List<FieldValue>> getValuesByItem() {
        return this.valuesByItem;
    }

    public Map<String, CountDownLatch> getLoadingLocks() {
        return this.loadingLocks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamTelemetryStore)) {
            return false;
        }
        StreamTelemetryStore other = (StreamTelemetryStore)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$itemsByBusinessEntity = this.getItemsByBusinessEntity();
        Map other$itemsByBusinessEntity = other.getItemsByBusinessEntity();
        if (this$itemsByBusinessEntity == null ? other$itemsByBusinessEntity != null : !((Object)this$itemsByBusinessEntity).equals(other$itemsByBusinessEntity)) {
            return false;
        }
        Map this$valuesByItem = this.getValuesByItem();
        Map other$valuesByItem = other.getValuesByItem();
        if (this$valuesByItem == null ? other$valuesByItem != null : !((Object)this$valuesByItem).equals(other$valuesByItem)) {
            return false;
        }
        Map this$loadingLocks = this.getLoadingLocks();
        Map other$loadingLocks = other.getLoadingLocks();
        return !(this$loadingLocks == null ? other$loadingLocks != null : !((Object)this$loadingLocks).equals(other$loadingLocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamTelemetryStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $itemsByBusinessEntity = this.getItemsByBusinessEntity();
        result = result * 59 + ($itemsByBusinessEntity == null ? 43 : ((Object)$itemsByBusinessEntity).hashCode());
        Map $valuesByItem = this.getValuesByItem();
        result = result * 59 + ($valuesByItem == null ? 43 : ((Object)$valuesByItem).hashCode());
        Map $loadingLocks = this.getLoadingLocks();
        result = result * 59 + ($loadingLocks == null ? 43 : ((Object)$loadingLocks).hashCode());
        return result;
    }

    public String toString() {
        return "StreamTelemetryStore(itemsByBusinessEntity=" + this.getItemsByBusinessEntity() + ", valuesByItem=" + this.getValuesByItem() + ", loadingLocks=" + this.getLoadingLocks() + ")";
    }
}

