/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import org.thingsboard.trendz.service.view.proto.FieldState;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class RowBuilder {
    private static final Logger log = LoggerFactory.getLogger(RowBuilder.class);
    private List<Row> rows = new CopyOnWriteArrayList();

    public RowBuilder(Row initialRow) {
        this.rows.add(initialRow);
    }

    public List<Row> getAllRows() {
        return new ArrayList<Row>(this.rows);
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public List<DataRow> build(ViewRequest request, ViewContext ctx) {
        ArrayList result = Lists.newArrayList();
        HashMap processedRows = new HashMap();
        for (Row row : this.rows) {
            DataRow dataRow = new DataRow();
            ArrayList dayGroups = Lists.newArrayList();
            for (Map.Entry entry : row.getFieldStates().entrySet()) {
                AggregatedValue aggValue = ((FieldState)entry.getValue()).getValue();
                ViewField viewField = (ViewField)entry.getKey();
                if (viewField.isMissedRelationField() || viewField.isHidden() || aggValue == null) continue;
                if (request.getRowClickEntityId() != null && request.getRowClickEntityId().equals(viewField.getBusinessEntityId())) {
                    Item item = null;
                    if (aggValue.getFieldValue() != null && CollectionUtils.isNotEmpty((Collection)aggValue.getFieldValue().getItems()) && aggValue.getFieldValue().getItems().size() == 1) {
                        item = (Item)aggValue.getFieldValue().getItems().iterator().next();
                    } else if (aggValue.getFieldValue() == null && aggValue.hasDateGroups()) {
                        FieldValue fieldValue = (FieldValue)aggValue.getDateGroups().values().iterator().next();
                        item = (Item)fieldValue.getItems().iterator().next();
                    }
                    if (item != null) {
                        dataRow.setEntityName(item.getName());
                        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(request.getRowClickEntityId());
                        BusinessEntityType entityType = ((TbBusinessEntityQuery)businessEntity.getQuery()).getEntityType();
                        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
                            case 1: {
                                dataRow.setEntityId((EntityId)new CustomerId(item.getId()));
                                break;
                            }
                            case 2: {
                                dataRow.setEntityId((EntityId)new AssetId(item.getId()));
                                break;
                            }
                            case 3: {
                                dataRow.setEntityId((EntityId)new DeviceId(item.getId()));
                            }
                        }
                    }
                }
                if (aggValue.getFieldValue() == null) {
                    if (MapUtils.isNotEmpty((Map)aggValue.getDateGroups())) {
                        for (DateAggregationGroup dayGroup : aggValue.getDateGroups().keySet()) {
                            dayGroups.add(new DayAggregationBucket(this, dayGroup, viewField.getId(), (FieldValue)aggValue.getDateGroups().get(dayGroup)));
                        }
                        continue;
                    }
                    throw new IllegalStateException("Aggregated Value is not defined");
                }
                DataCell cell = new DataCell(viewField.getId(), aggValue.getFieldValue().getInnerValue());
                dataRow.getCells().add(cell);
            }
            result.add(dataRow);
            result.addAll(this.processDayGroupCells(dataRow, (List)dayGroups, processedRows));
        }
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)result));
    }

    public void filterBlankFields(ViewRequest request) {
        Set filterIds;
        if (CollectionUtils.isNotEmpty((Collection)request.getRuntimeFilters()) && CollectionUtils.isNotEmpty(filterIds = request.getRuntimeFilters().stream().filter(f -> !f.isBlankFilter()).map(f -> f.getViewFieldId()).collect(Collectors.toSet()))) {
            this.rows = this.rows.stream().filter(r -> {
                List filterFields = r.getOrderedFields().stream().filter(f -> filterIds.contains(f.getId())).collect(Collectors.toList());
                boolean isBlank = filterFields.stream().anyMatch(field -> {
                    FieldState fieldState = (FieldState)r.getFieldStates().get(field);
                    if (fieldState != null && fieldState.getValue() != null && fieldState.getValue().getFieldValue() != null) {
                        return fieldState.getValue().getFieldValue().getFieldType().equals((Object)FieldType.BLANK);
                    }
                    return false;
                });
                return !isBlank;
            }).collect(Collectors.toList());
        }
    }

    private List<DataRow> processDayGroupCells(DataRow originalRow, List<DayAggregationBucket> dayGroups, Map<DateAggregationGroup, DataRow> ppprocessedRows) {
        ArrayList newRows = Lists.newArrayList();
        HashMap<DayAggregationBucket, DataRow> processedRows = new HashMap<DayAggregationBucket, DataRow>();
        DataRow currentRow = originalRow;
        DataRow rowTempalte = originalRow.copy();
        for (DayAggregationBucket group : dayGroups) {
            if (processedRows.containsKey(group)) {
                currentRow = (DataRow)processedRows.get(group);
            }
            DataCell mainCell = this.findOrCreateCell(currentRow, DayAggregationBucket.access$000((DayAggregationBucket)group));
            mainCell.setData(DayAggregationBucket.access$100((DayAggregationBucket)group).getInnerValue());
            for (Map.Entry entry : DayAggregationBucket.access$200((DayAggregationBucket)group).getKeys().entrySet()) {
                DataCell cell = this.findOrCreateCell(currentRow, ((ViewField)entry.getKey()).getId());
                cell.setData(((FieldValue)entry.getValue()).getInnerValue());
            }
            processedRows.put(group, currentRow);
            if (currentRow != originalRow) {
                newRows.add(currentRow);
            }
            currentRow = rowTempalte.copy();
        }
        return newRows;
    }

    private DataCell findOrCreateCell(DataRow row, UUID fieldId) {
        for (DataCell cell : row.getCells()) {
            if (!cell.getViewFieldId().equals(fieldId)) continue;
            return cell;
        }
        DataCell dataCell = new DataCell(fieldId, null);
        row.getCells().add(dataCell);
        return dataCell;
    }
}

