/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import org.thingsboard.trendz.service.view.proto.FieldState;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Row {
    private static final Logger log = LoggerFactory.getLogger(Row.class);
    private List<ViewField> orderedFields;
    private Map<ViewField, FieldState> fieldStates;
    private Map<UUID, List<AggregatedValue>> hiddenValues;

    public Row(List<ViewField> fields) {
        this.orderedFields = fields;
        this.fieldStates = new ConcurrentHashMap();
        this.hiddenValues = new ConcurrentHashMap();
        for (ViewField field : fields) {
            this.fieldStates.put(field, new FieldState());
        }
    }

    public FieldState getFieldState(ViewField field) {
        return (FieldState)this.fieldStates.get(field);
    }

    public void markAsProcessed(ViewField field, AggregatedValue value) {
        FieldState fieldState = (FieldState)this.fieldStates.get(field);
        fieldState.setValue(value);
        fieldState.setProcessed(true);
    }

    public Row copy() {
        Row row = new Row(this.orderedFields);
        ConcurrentHashMap<ViewField, FieldState> stateCopy = new ConcurrentHashMap<ViewField, FieldState>();
        for (ViewField field : this.fieldStates.keySet()) {
            FieldState fieldState = (FieldState)this.fieldStates.get(field);
            stateCopy.put(field, fieldState.copy());
        }
        row.fieldStates = stateCopy;
        row.hiddenValues = new ConcurrentHashMap(this.hiddenValues);
        return row;
    }

    public Optional<ViewField> getNextUnprocessed() {
        for (ViewField field : this.orderedFields) {
            if (((FieldState)this.fieldStates.get(field)).isProcessed()) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public List<ViewField> getAllUnporcessed() {
        ArrayList unprossed = Lists.newArrayList();
        for (ViewField field : this.orderedFields) {
            if (((FieldState)this.fieldStates.get(field)).isProcessed()) continue;
            unprossed.add(field);
        }
        return unprossed;
    }

    public Optional<Flux<Item>> getEntityItems(UUID businessEntityId) {
        boolean found = false;
        ViewField latestMatchedField = null;
        Flux latestItems = null;
        for (ViewField field : this.orderedFields) {
            FieldState fieldState;
            if (!field.getBusinessEntityId().equals(businessEntityId) || (fieldState = (FieldState)this.fieldStates.get(field)) == null || !fieldState.isProcessed()) continue;
            latestItems = fieldState.getValue().getItems();
            latestMatchedField = field;
            found = true;
        }
        if (found) {
            boolean afterLatest = false;
            for (ViewField field : this.orderedFields) {
                if (afterLatest) {
                    FieldState fieldState = (FieldState)this.fieldStates.get(field);
                    if (fieldState == null || !fieldState.isProcessed()) continue;
                    Mono parentIdsMono = fieldState.getValue().getItems().map(Item::getParentId).collectList();
                    latestItems = Flux.combineLatest((Publisher)parentIdsMono, (Publisher)Flux.from((Publisher)latestItems.collectList()), (parentIds, items) -> {
                        List filteredItems = items.stream().filter(i -> parentIds.contains(i.getId())).collect(Collectors.toList());
                        if (filteredItems.isEmpty()) {
                            return items;
                        }
                        return filteredItems;
                    }).flatMapIterable(i -> i);
                    continue;
                }
                afterLatest = field == latestMatchedField;
            }
            return Optional.of(latestItems);
        }
        return Optional.empty();
    }

    public String toString() {
        String line = "";
        for (ViewField field : this.orderedFields) {
            FieldState fieldState = (FieldState)this.fieldStates.get(field);
            if (!fieldState.isProcessed()) continue;
            if (fieldState.getValue().getFieldValue() != null) {
                line = line + field.getLabel() + " = " + fieldState.getValue().getFieldValue().getInnerValue() + "; ";
                continue;
            }
            line = line + field.getLabel() + " ";
            if (fieldState.getValue().getDateGroups() != null) {
                for (Map.Entry entry : fieldState.getValue().getDateGroups().entrySet()) {
                    String key = "";
                    for (Map.Entry keyEntry : ((DateAggregationGroup)entry.getKey()).getKeys().entrySet()) {
                        key = key + "[" + ((ViewField)keyEntry.getKey()).getLabel() + "-" + ((FieldValue)keyEntry.getValue()).getInnerValue() + "]";
                    }
                    line = line + key + " = " + ((FieldValue)entry.getValue()).getInnerValue();
                }
                line = line + "; ";
                continue;
            }
            line = line + " = empty; ";
        }
        return line;
    }

    public List<ViewField> getOrderedFields() {
        return this.orderedFields;
    }

    public Map<ViewField, FieldState> getFieldStates() {
        return this.fieldStates;
    }

    public Map<UUID, List<AggregatedValue>> getHiddenValues() {
        return this.hiddenValues;
    }
}

