/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationGraph;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.LoadFieldOrderer;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Component
public class LoadFieldOrdererImpl
implements LoadFieldOrderer {
    private static final Logger log = LoggerFactory.getLogger(LoadFieldOrdererImpl.class);

    public List<ViewField> order(ViewRequest request, ViewContext context) {
        List<ViewField> ordered = request.getFields().stream().filter(f -> !this.innerLoadField(f, context)).sorted((o1, o2) -> {
            int compare = this.compareByRootDistance(context.getRelationGraph(), o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.filteredFieldsLoadFirst(context, o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByAggregation(o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByFieldType(context, o1, o2);
            if (compare != 0) {
                return compare;
            }
            return 0;
        }).collect(Collectors.toList());
        log.debug("Fields load order {}", ordered.stream().map(f -> f.getLabel() + "[" + f.getAggregationType() + "]").collect(Collectors.toList()));
        return ordered;
    }

    private int telemetryLoadedLast(ViewContext context, ViewField o1, ViewField o2) {
        FieldQueryType secType;
        if (o1.isMissedRelationField() || o2.isMissedRelationField()) {
            return 0;
        }
        FieldQueryType firstType = this.getQueryType(context, o1);
        if (firstType == (secType = this.getQueryType(context, o2))) {
            return 0;
        }
        if (firstType == FieldQueryType.TELEMETRY) {
            return 1;
        }
        if (secType == FieldQueryType.TELEMETRY) {
            return -1;
        }
        return 0;
    }

    private int compareByFieldType(ViewContext context, ViewField o1, ViewField o2) {
        int compare;
        if (o1.isMissedRelationField() || o2.isMissedRelationField()) {
            return 0;
        }
        FieldQueryType firstType = this.getQueryType(context, o1);
        FieldQueryType secType = this.getQueryType(context, o2);
        ArrayList fieldQueryTypes = Lists.newArrayList((Object[])FieldQueryType.values());
        if (o1.isEnableRuntimeFilter() && !FieldQueryType.TELEMETRY.equals((Object)firstType)) {
            int compare2 = this.filteredFieldsLoadFirst(context, o1, o2);
            if (compare2 != 0) {
                return compare2;
            }
        } else if (o2.isEnableRuntimeFilter() && !FieldQueryType.TELEMETRY.equals((Object)secType) && (compare = this.filteredFieldsLoadFirst(context, o1, o2)) != 0) {
            return compare;
        }
        return fieldQueryTypes.indexOf(firstType) - fieldQueryTypes.indexOf(secType);
    }

    private int filteredFieldsLoadFirst(ViewContext context, ViewField o1, ViewField o2) {
        return Boolean.compare(o2.isEnableRuntimeFilter(), o1.isEnableRuntimeFilter());
    }

    private int compareByAggregation(ViewField o1, ViewField o2) {
        if (o1.isStateField() && o2.isStateField()) {
            if (o1.getAggregationType() == FieldAggregation.UNIQ) {
                return Integer.MIN_VALUE;
            }
            if (o2.getAggregationType() == FieldAggregation.UNIQ) {
                return Integer.MIN_VALUE;
            }
        }
        if (o1.isMissedRelationField() || o2.isMissedRelationField()) {
            return 0;
        }
        ArrayList aggTypes = Lists.newArrayList((Object[])FieldAggregation.values());
        return aggTypes.indexOf(o1.getAggregationType()) - aggTypes.indexOf(o2.getAggregationType());
    }

    private int compareByRootDistance(RelationGraph relationGraph, ViewField o1, ViewField o2) {
        int oneDistance = this.getDistanceFromRoot(relationGraph, o1.getBusinessEntityId());
        int twoDistance = this.getDistanceFromRoot(relationGraph, o2.getBusinessEntityId());
        log.trace("Root distance {}:{} and {}:{}", new Object[]{o1.getLabel(), oneDistance, o2.getLabel(), twoDistance});
        return Integer.compare(oneDistance, twoDistance);
    }

    private int getDistanceFromRoot(RelationGraph relationGraph, UUID entity) {
        RelationNode node = relationGraph.getNodeById(entity);
        if (node == null) {
            return Integer.MAX_VALUE;
        }
        return node.getDistance();
    }

    private FieldQueryType getQueryType(ViewContext ctx, ViewField field) {
        if (field.isStateField()) {
            return FieldQueryType.STATE;
        }
        if (field.isCalculatedField() && field.isBatchCalculation()) {
            return FieldQueryType.CALCULATED;
        }
        return ((BusinessEntityField)ctx.getBusinessEntityFieldMap().get(field.getEntityFieldId())).getQuery().getQueryType();
    }

    private boolean innerLoadField(ViewField field, ViewContext ctx) {
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(field.getEntityFieldId());
        return field.isForStateCondition() && entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY;
    }
}

