/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.provider.TbFieldValueService;
import org.thingsboard.trendz.service.script.BatchFieldScriptProcessor;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.state.StateFieldProcessor;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.ItemFieldValueLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;

@Component
public class ItemFieldValueLoader
extends ItemDataLoader {
    private static final Logger log = LoggerFactory.getLogger(ItemFieldValueLoader.class);
    @Autowired
    private TbFieldValueService tbFieldValueService;
    @Autowired
    private StateFieldProcessor stateFieldProcessor;
    @Autowired
    private BatchFieldScriptProcessor batchFieldScriptProcessor;

    public Flux<FieldValue> loadItemFieldValue(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        if (this.isStateField(viewField)) {
            return this.processStateField(item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx);
        }
        if (this.isBatchCalculatedField(viewField)) {
            return this.batchFieldScriptProcessor.process(item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx);
        }
        return this.loadValues(item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx);
    }

    private Flux<FieldValue> loadValues(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[entityField.getQuery().getQueryType().ordinal()]) {
            case 1: {
                return this.valueOrAggregate(item, viewField, (Object)item.getName());
            }
            case 2: {
                return this.valueOrAggregate(item, viewField, (Object)item.getLabel());
            }
            case 3: {
                return this.valueOrAggregate(item, viewField, (Object)item.getOwnerId());
            }
            case 4: {
                return this.tbFieldValueService.loadAttribute(item, viewField, entityField, businessEntity, ctx.getJwtToken());
            }
            case 5: {
                return this.tbFieldValueService.loadTelemetry(item, viewField, viewRequest, entityField, businessEntity, windowedStreamStore, ctx);
            }
        }
        throw new IllegalStateException("Unsupported entity Field type " + entityField.getType());
    }

    private Flux<FieldValue> valueOrAggregate(Item item, ViewField viewField, Object val) {
        if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            return Flux.just((Object)new FieldValue(item, FieldType.NUMERIC, (Object)1));
        }
        return Flux.just((Object)new FieldValue(item, FieldType.STRING, val));
    }

    private Flux<FieldValue> processStateField(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        if (viewField.getAggregationType() == FieldAggregation.UNIQ) {
            List states = (List)ctx.getStatesByItem().get(item.getId());
            if (CollectionUtils.isEmpty((Collection)states)) {
                return Flux.empty();
            }
            return Flux.fromIterable((Iterable)states.stream().map(s -> {
                FieldValue fieldValue = new FieldValue(item, FieldType.STRING, (Object)("" + new Date(s.getStartTs()) + " - " + new Date(s.getEndTs())));
                fieldValue.setState(true);
                fieldValue.setInnerState(s);
                return fieldValue;
            }).collect(Collectors.toList()));
        }
        Flux states = this.stateFieldProcessor.processFieldStates(item, viewField, viewRequest, windowedStreamStore, entityField, businessEntity, ctx);
        FieldValue blankState = new FieldValue(item, FieldType.BLANK, null);
        blankState.setState(true);
        return this.statesToValue(states, item, viewField, viewRequest).defaultIfEmpty((Object)blankState);
    }

    private boolean isStateField(ViewField viewField) {
        return viewField.isStateField();
    }

    private boolean isBatchCalculatedField(ViewField viewField) {
        return viewField.isCalculatedField() && viewField.isBatchCalculation();
    }

    private Flux<FieldValue> statesToValue(Flux<State> states, Item item, ViewField viewField, ViewRequest request) {
        if (viewField.getAggregationType() == FieldAggregation.DURATION) {
            return states.collectList().map(values -> this.getStateDuration(values, item, viewField)).flatMapIterable(l -> l);
        }
        if (viewField.getAggregationType() == FieldAggregation.DURATION_PERCENT) {
            return states.collectList().map(values -> this.getStateDuration(values, item, viewField)).flatMapIterable(l -> l);
        }
        if (viewField.getAggregationType() == FieldAggregation.NONE) {
            return states.collectList().map(values -> new ArrayList()).flatMapIterable(l -> l);
        }
        if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            return states.collectList().map(values -> Collections.singletonList(new FieldValue(item, FieldType.NUMERIC, (Object)values.size()))).flatMapIterable(l -> l);
        }
        throw new IllegalStateException("not implemented");
    }

    private List<FieldValue> getStateDuration(List<State> states, Item item, ViewField viewField) {
        return states.stream().map(s -> {
            FieldValue fieldValue = new FieldValue(item, FieldType.NUMERIC, (Object)((double)s.getEndTs() - (double)s.getStartTs()));
            fieldValue.setState(true);
            fieldValue.setTs(s.getStartTs());
            fieldValue.setInnerState(s);
            return fieldValue;
        }).collect(Collectors.toList());
    }
}

