/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemFieldValueLoader;
import org.thingsboard.trendz.service.view.proto.TelemetryCacheLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;

@Service
public class ItemDataLoader {
    private static final Logger log = LoggerFactory.getLogger(ItemDataLoader.class);
    @Autowired
    private ItemFieldValueLoader fieldValueLoader;
    @Autowired
    private TelemetryCacheLoader telemetryCacheLoader;

    public Flux<FieldValue> loadItemFieldValue(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.debug("Loading data for: item [{}] [{}], viewField ({})", new Object[]{item.getName(), item.getId(), viewField.getLabel()});
        if (request.isUsePersistedCacheTelemetry() && this.isPossibleToUseTelemetryCache(request, viewField)) {
            return this.loadDataFromCache(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
        }
        return this.loadDataFromTb(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
    }

    public boolean isPossibleToUseTelemetryCache(ViewRequest request, ViewField viewField) {
        HashSet forbiddenAggregations = Sets.newHashSet((Object[])new FieldAggregation[]{FieldAggregation.NONE, FieldAggregation.UNIQ});
        long startTs = request.getStartTs();
        long endTs = request.getEndTs() + 1L;
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs), ZoneId.systemDefault());
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)request.getCachingDateAggregationType());
        boolean result = true;
        result &= !forbiddenAggregations.contains(viewField.getAggregationType());
        result &= DateAggregationType.isLoadableAggregationType((DateAggregationType)request.getCachingDateAggregationType());
        return result &= timeUnit.between(startDate, endDate) > 0L;
    }

    private Flux<FieldValue> loadDataFromCache(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.debug("ItemDataLoader: Loading data source = cached telemetry");
        return this.telemetryCacheLoader.loadItemFieldValue(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId);
    }

    protected Flux<FieldValue> loadDataFromTb(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        log.debug("ItemDataLoader: Loading data source = thingsboard");
        return this.fieldValueLoader.loadItemFieldValue(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx);
    }
}

