/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.FilterServiceImpl;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Component
public class FilterServiceImpl
implements FilterService {
    private static final Logger log = LoggerFactory.getLogger(FilterServiceImpl.class);
    private ExecutorService filterOptionsFetchExecutor = Executors.newFixedThreadPool(4);
    @Autowired
    private TbRestDataSource tbRestDataSource;

    @PreDestroy
    public void shutdown() {
        if (this.filterOptionsFetchExecutor != null) {
            this.filterOptionsFetchExecutor.shutdownNow();
        }
    }

    public List<AggregatedValue> filterAggregatedValue(List<AggregatedValue> original, ViewField field, ViewRequest request, ViewContext ctx) {
        if (original.isEmpty()) {
            return original;
        }
        if (original.iterator().next().getFieldValue() == null) {
            return this.filterDateGroupFields(original, field, request, ctx);
        }
        return this.filterSimpleFields(original, field, request, ctx);
    }

    public Multimap<DateAggregationGroup, FieldValue> filterDayGroups(Multimap<DateAggregationGroup, FieldValue> original, ViewRequest request, ViewContext ctx) {
        Set dateGroupFieldIds = request.getDateAggregationFields().stream().map(ViewField::getId).collect(Collectors.toSet());
        List dayGroupFilters = request.getRuntimeFilters().stream().filter(f -> dateGroupFieldIds.contains(f.getViewFieldId())).collect(Collectors.toList());
        if (dayGroupFilters.isEmpty() || original.keySet().size() == 1 && ((DateAggregationGroup)original.keySet().iterator().next()).getKeys().isEmpty()) {
            return original;
        }
        ArrayListMultimap filtered = ArrayListMultimap.create();
        for (DateAggregationGroup dayGroup : original.keySet()) {
            boolean isMatched = true;
            for (RuntimeFilterField dayGroupFilter : dayGroupFilters) {
                Optional fieldById = dayGroup.findFieldById(dayGroupFilter.getViewFieldId());
                if (!fieldById.isPresent()) continue;
                FieldValue fieldValue = (FieldValue)dayGroup.getKeys().get(fieldById.get());
                ctx.addFieldValue(dayGroupFilter.getViewFieldId(), fieldValue.getInnerValue());
                if (this.simpleFilterMatched(dayGroupFilter, fieldValue)) continue;
                isMatched = false;
            }
            if (!isMatched) continue;
            filtered.putAll((Object)dayGroup, (Iterable)original.get((Object)dayGroup));
        }
        return filtered;
    }

    public boolean matchFieldValue(FieldValue original, ViewField field, ViewRequest request) {
        Optional<RuntimeFilterField> filter = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(field.getId())).findAny();
        if (filter.isPresent()) {
            return original.getInnerValue() != null && this.simpleFilterMatched(filter.get(), original);
        }
        return true;
    }

    public void loadFilterOptions(ViewContext ctx, ViewRequest request) {
        if (request == null) {
            return;
        }
        for (FilterOptionTask filterOptionTask : ctx.getFieldFilterOptionTasks()) {
            if (!filterOptionTask.getStarted().compareAndSet(false, true)) continue;
            this.filterOptionsFetchExecutor.submit(() -> {
                try {
                    long startTs = System.currentTimeMillis();
                    Set entitFieldIds = filterOptionTask.getBusinessEntity().getFields().stream().map(bef -> bef.getId()).collect(Collectors.toSet());
                    Set items = this.tbRestDataSource.loadItemsByQuery(filterOptionTask.getQuery(), ctx.getJwtToken());
                    Set viewFieldIds = request.getRuntimeFilters().stream().filter(rff -> !rff.isBlankFilter()).map(rff -> rff.getViewFieldId()).collect(Collectors.toSet());
                    Set viewfields = request.getFields().stream().filter(vf -> entitFieldIds.contains(vf.getEntityFieldId())).filter(vf -> viewFieldIds.contains(vf.getId())).collect(Collectors.toSet());
                    for (Item item : items) {
                        for (ViewField viewfield : viewfields) {
                            BusinessEntityField bef2 = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewfield.getEntityFieldId());
                            TbBusinessEntityFieldQuery fieldQuery = (TbBusinessEntityFieldQuery)bef2.getQuery();
                            if (FieldQueryType.ENTITY_NAME.equals((Object)bef2.getQuery().getQueryType())) {
                                ctx.addFieldValue(viewfield.getId(), (Object)item.getName());
                                continue;
                            }
                            if (FieldQueryType.ENTITY_LABEL.equals((Object)bef2.getQuery().getQueryType())) {
                                ctx.addFieldValue(viewfield.getId(), (Object)item.getLabel());
                                continue;
                            }
                            if (!FieldQueryType.ATTRIBUTE.equals((Object)bef2.getQuery().getQueryType())) continue;
                            ctx.addFieldValue(viewfield.getId(), item.getAttributes().get(fieldQuery.getKey()));
                        }
                    }
                    log.trace("Options load time took {} ms. Found {} items", (Object)(System.currentTimeMillis() - startTs), (Object)items.size());
                    ctx.getStats().getFilterOptionsLoadTime().put(filterOptionTask.getBusinessEntity(), System.currentTimeMillis() - startTs);
                }
                catch (Exception ex) {
                    log.error("Error while fetch filter options", (Throwable)ex);
                }
                finally {
                    filterOptionTask.getLatch().countDown();
                }
            });
        }
    }

    private List<AggregatedValue> filterDateGroupFields(List<AggregatedValue> original, ViewField field, ViewRequest request, ViewContext ctx) {
        Optional<RuntimeFilterField> directFieldFilter = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(field.getId())).findAny();
        if (directFieldFilter.isPresent()) {
            ArrayList filtered = Lists.newArrayList();
            for (AggregatedValue aggValue : original) {
                ArrayList groupForRemove = Lists.newArrayList();
                for (DateAggregationGroup dayGroup : aggValue.getDateGroups().keySet()) {
                    FieldValue fieldValue = (FieldValue)aggValue.getDateGroups().get(dayGroup);
                    if (this.simpleFilterMatched(directFieldFilter.get(), fieldValue)) continue;
                    groupForRemove.add(dayGroup);
                }
                for (DateAggregationGroup group : groupForRemove) {
                    aggValue.getDateGroups().remove(group);
                }
                if (aggValue.getDateGroups().isEmpty()) continue;
                filtered.add(aggValue);
            }
            return filtered;
        }
        return original;
    }

    private List<AggregatedValue> filterSimpleFields(List<AggregatedValue> original, ViewField field, ViewRequest request, ViewContext ctx) {
        Optional<RuntimeFilterField> filter = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(field.getId())).findAny();
        if (filter.isPresent()) {
            original.stream().filter(av -> av.getFieldValue().getInnerValue() != null).forEach(av -> ctx.addFieldValue(field.getId(), av.getFieldValue().getInnerValue()));
            return original.stream().filter(av -> this.simpleFilterMatched((RuntimeFilterField)filter.get(), av.getFieldValue())).collect(Collectors.toList());
        }
        return original;
    }

    private boolean simpleFilterMatched(RuntimeFilterField filter, FieldValue fieldValue) {
        if (filter.getCondition() == FilterCondition.ANY) {
            return true;
        }
        if (fieldValue.getInnerValue() == null) {
            return false;
        }
        String strVal = fieldValue.getInnerValue().toString();
        FieldType fieldType = fieldValue.getFieldType();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filter.getCondition().ordinal()]) {
            case 1: {
                return CollectionUtils.isEmpty((Collection)filter.getSelection()) || filter.getSelection().contains(strVal);
            }
            case 2: {
                return fieldType == FieldType.NUMERIC && (Double)fieldValue.getInnerValue() < filter.getNumericParam();
            }
            case 3: {
                return fieldType == FieldType.NUMERIC && (Double)fieldValue.getInnerValue() <= filter.getNumericParam();
            }
            case 4: {
                return fieldType == FieldType.NUMERIC && (Double)fieldValue.getInnerValue() > filter.getNumericParam();
            }
            case 5: {
                return fieldType == FieldType.NUMERIC && (Double)fieldValue.getInnerValue() >= filter.getNumericParam();
            }
            case 6: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && strVal.startsWith(filter.getStrParam());
            }
            case 7: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && strVal.contains(filter.getStrParam());
            }
            case 8: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && strVal.endsWith(filter.getStrParam());
            }
            case 9: {
                return fieldType == FieldType.DATE && (Double)fieldValue.getInnerValue() < filter.getNumericParam();
            }
            case 10: {
                return fieldType == FieldType.DATE && (Double)fieldValue.getInnerValue() <= filter.getNumericParam();
            }
            case 11: {
                return fieldType == FieldType.DATE && (Double)fieldValue.getInnerValue() > filter.getNumericParam();
            }
            case 12: {
                return fieldType == FieldType.DATE && (Double)fieldValue.getInnerValue() >= filter.getNumericParam();
            }
        }
        throw new IllegalStateException("Unimplemented filter condition " + filter.getCondition());
    }
}

