/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateFormatUtil;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Component
public class DateGrouper {
    private static final Logger log = LoggerFactory.getLogger(DateGrouper.class);

    public Multimap<DateAggregationGroup, FieldValue> groupByDateFields(boolean hasTime, List<FieldValue> itemValues, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewRequest request) {
        ArrayListMultimap groupedValues = ArrayListMultimap.create();
        if (!dateAggregationFields.isEmpty() && hasTime) {
            boolean blankStateValues = this.areBlankStateValues(itemValues);
            boolean fullStateValues = this.areFullStateValues(itemValues);
            boolean stateValues = blankStateValues || fullStateValues;
            Set items = itemValues.stream().map(FieldValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
            List fillGaps = this.fillGaps(request, (Multimap)groupedValues, usedAggregationUnit, dateAggregationFields, items, stateValues);
            for (FieldValue value : itemValues) {
                if (value.getFieldType().equals((Object)FieldType.BLANK)) continue;
                List intervals = Collections.singletonList(value);
                if (fullStateValues) {
                    intervals = this.splitStatesToIntervals(value, usedAggregationUnit);
                }
                for (FieldValue interval : intervals) {
                    DateAggregationGroup groupKey = new DateAggregationGroup();
                    for (ViewField aggregationField : dateAggregationFields) {
                        String groupValue = this.applyGroupFunc(aggregationField, interval, request);
                        if (groupValue == null) continue;
                        groupKey.getKeys().put(aggregationField, new FieldValue(interval.getItems(), FieldType.STRING, (Object)groupValue));
                    }
                    if (groupKey.getKeys().size() <= 0) continue;
                    groupedValues.put((Object)groupKey, (Object)interval);
                }
            }
        } else {
            groupedValues.putAll((Object)new DateAggregationGroup(), itemValues);
        }
        return groupedValues;
    }

    private boolean areFullStateValues(List<FieldValue> itemValues) {
        return CollectionUtils.isNotEmpty(itemValues) && itemValues.get(0).isState() && itemValues.get(0).getInnerState() != null;
    }

    private boolean areBlankStateValues(List<FieldValue> itemValues) {
        return itemValues.size() == 1 && itemValues.get(0).isState() && itemValues.get(0).getInnerState() == null;
    }

    private boolean containsRawDateField(ViewRequest request) {
        return request.getDateAggregationFields().stream().anyMatch(f -> f.getDateGrouping() == DateAggregationType.RAW);
    }

    private List<FieldValue> fillGaps(ViewRequest request, Multimap<DateAggregationGroup, FieldValue> groupedValues, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, Set<Item> itemSet, boolean stateValues) {
        boolean containsRawDateField = this.containsRawDateField(request);
        ArrayList intervals = Lists.newArrayList();
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)usedAggregationUnit);
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(request.getStartTs()), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(request.getEndTs()), ZoneId.systemDefault());
        ZonedDateTime currentDate = startDate;
        while (currentDate.isBefore(endDate)) {
            long currentTs = currentDate.toEpochSecond() * 1000L;
            if (stateValues) {
                intervals.add(new FieldValue(itemSet, FieldType.NUMERIC, (Object)0, currentTs));
            } else if (request.isFillGap()) {
                if (containsRawDateField) {
                    intervals.add(new FieldValue(itemSet, FieldType.NUMERIC, (Object)0, currentTs));
                } else {
                    intervals.add(new FieldValue(itemSet, FieldType.BLANK, null, currentTs));
                }
            }
            currentDate = currentDate.plus(1L, timeUnit);
        }
        for (FieldValue interval : intervals) {
            DateAggregationGroup groupKey = new DateAggregationGroup();
            for (ViewField aggregationField : dateAggregationFields) {
                String groupValue = this.applyGroupFunc(aggregationField, interval, request);
                if (groupValue == null) continue;
                groupKey.getKeys().put(aggregationField, new FieldValue(interval.getItems(), FieldType.STRING, (Object)groupValue));
            }
            if (groupKey.getKeys().size() <= 0) continue;
            groupedValues.put((Object)groupKey, (Object)interval);
        }
        return intervals;
    }

    private List<FieldValue> splitStatesToIntervals(FieldValue value, DateAggregationType minDateAggregation) {
        State state = value.getInnerState();
        ArrayList intervalsTs = Lists.newArrayList();
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)minDateAggregation);
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(state.getStartTs()), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(state.getEndTs()), ZoneId.systemDefault());
        endDate = endDate.plus(1L, timeUnit);
        ZonedDateTime currentDate = startDate;
        while (currentDate.isBefore(endDate)) {
            long currentTs = currentDate.toEpochSecond() * 1000L;
            intervalsTs.add(Math.min(state.getEndTs(), currentTs));
            currentDate = DateAggregationType.extendedTruncateTo((ZonedDateTime)currentDate.plus(1L, timeUnit), (TemporalUnit)timeUnit);
        }
        ArrayList intervals = Lists.newArrayList();
        for (int i = 0; i < intervalsTs.size() - 1; ++i) {
            long currentTs = (Long)intervalsTs.get(i);
            long duration = (Long)intervalsTs.get(i + 1) - (Long)intervalsTs.get(i);
            intervals.add(new FieldValue(value.getItems(), FieldType.NUMERIC, (Object)duration, currentTs));
        }
        if (intervals.isEmpty()) {
            return Collections.singletonList(new FieldValue(value.getItems(), FieldType.NUMERIC, value.getInnerValue(), state.getStartTs()));
        }
        return intervals;
    }

    private String applyGroupFunc(ViewField dateAggField, FieldValue value, ViewRequest request) {
        if (dateAggField.getDateGrouping() != DateAggregationType.RAW) {
            if (value.getTs() == 0L) {
                return null;
            }
            String apply = dateAggField.getDateGrouping().apply(value.getTs(), request.getTzName());
            return apply;
        }
        String rangeBy = request.getDatePickerConfig().getRangeBy();
        int rangeByAmount = request.getDatePickerConfig().getRangeByAmount();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rangeBy})) {
            if ("minute".equals(rangeBy)) {
                return DateFormatUtil.truncateMinute((long)value.getTs(), (int)rangeByAmount, (String)request.getTzName());
            }
            if ("hour".equals(rangeBy)) {
                return DateFormatUtil.truncateHour((long)value.getTs(), (int)rangeByAmount, (String)request.getTzName());
            }
            if ("day".equals(rangeBy)) {
                return DateFormatUtil.truncateDay((long)value.getTs(), (int)rangeByAmount, (String)request.getTzName());
            }
            if ("week".equals(rangeBy)) {
                return DateFormatUtil.truncateWeek((long)value.getTs(), (int)rangeByAmount, (String)request.getTzName());
            }
            if ("month".equals(rangeBy)) {
                return DateFormatUtil.truncateMonth((long)value.getTs(), (int)rangeByAmount, (String)request.getTzName());
            }
        }
        return dateAggField.getDateGrouping().apply(value.getTs(), request.getTzName());
    }
}

