/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.predict.PredictionService;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.TelemetryCachePreloader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class DataLoader {
    private static final Logger log = LoggerFactory.getLogger(DataLoader.class);
    @Autowired
    private ItemDataLoader itemDataLoader;
    @Autowired
    private TelemetryCachePreloader telemetryCachePreloader;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private StatsCollector statsCollector;
    private final Scheduler scheduler = Schedulers.newParallel((String)"parallel-scheduler-aggregator", (int)20);

    public ParallelFlux<List<FieldValue>> loadData(ViewField viewField, Flux<Item> items, WindowedStreamStore windowedStreamStore, ViewRequest request, ViewContext ctx, long methodId) {
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(viewField.getBusinessEntityId());
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        return items.collectList().flatMap(itemList -> this.telemetryCachePreloader.preloadCache(itemList, request, viewField, ctx)).flatMapIterable(l -> l).parallel().runOn(this.scheduler).flatMap(item -> this.loadItemValues(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId));
    }

    private Mono<List<FieldValue>> loadItemValues(Item item, ViewField viewField, ViewRequest request, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx, long methodId) {
        long startTs = System.currentTimeMillis();
        return this.itemDataLoader.loadItemFieldValue(item, viewField, request, windowedStreamStore, entityField, businessEntity, ctx, methodId).doOnNext(fieldValue -> this.defineOwner(fieldValue, viewField, ctx)).collectList().doOnNext(fieldValues -> ctx.getStats().getFieldValueLoadTime().computeIfAbsent(viewField, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs)).map(fieldValues -> this.postLoadProcess(fieldValues, viewField)).map(fieldValues -> this.processPrediction(fieldValues, viewField, ctx));
    }

    private void defineOwner(FieldValue fieldValue, ViewField viewField, ViewContext ctx) {
        BusinessEntityField beField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        if (beField != null && beField.getQuery().getQueryType().equals((Object)FieldQueryType.OWNER) && viewField.getAggregationType() != FieldAggregation.COUNT) {
            String ownerName = (String)ctx.getCustomerDictionary().get(fieldValue.getInnerValue());
            if (StringUtils.isBlank((CharSequence)ownerName)) {
                ownerName = "Admin";
            }
            fieldValue.setInnerValue((Object)ownerName);
        }
    }

    private List<FieldValue> postLoadProcess(List<FieldValue> fieldValues, ViewField viewField) {
        List nonBlankFields;
        if (viewField.getAggregationType() == FieldAggregation.DELTA && (nonBlankFields = fieldValues.stream().filter(fv -> !fv.getFieldType().equals((Object)FieldType.BLANK)).filter(v -> v.getNumeric().isPresent()).sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList())).size() > 0) {
            ArrayList deltaValues = Lists.newArrayList();
            ArrayList deltaFields = Lists.newArrayList();
            FieldValue prev = (FieldValue)nonBlankFields.get(0);
            for (FieldValue value : nonBlankFields) {
                if (value != prev) {
                    deltaFields.add(value);
                    deltaValues.add((Double)value.getNumeric().get() - (Double)prev.getNumeric().get());
                }
                prev = value;
            }
            for (int i = 0; i < deltaValues.size(); ++i) {
                ((FieldValue)deltaFields.get(i)).setInnerValue(deltaValues.get(i));
            }
            return deltaFields;
        }
        return fieldValues;
    }

    private List<FieldValue> processPrediction(List<FieldValue> original, ViewField field, ViewContext ctx) {
        if (field.isPredictionEnabled()) {
            return this.predictionService.enrichPrediction(field, original, ctx);
        }
        return original;
    }
}

