/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.AggregationService;
import org.thingsboard.trendz.service.view.proto.AggregationServiceImpl;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import org.thingsboard.trendz.service.view.proto.DateGrouper;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;

@Service
public class AggregationServiceImpl
implements AggregationService {
    private static final Logger log = LoggerFactory.getLogger(AggregationServiceImpl.class);
    @Autowired
    private DateGrouper dateGrouper;
    @Autowired
    private FilterService filterService;
    @Autowired
    private StatsCollector statsCollector;

    public Mono<List<AggregatedValue>> aggregate(ParallelFlux<List<FieldValue>> loadingData, ViewField viewField, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewRequest request, ViewContext ctx, long methodId) {
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        return loadingData.flatMap(fieldValues -> this.preagregate(fieldValues, viewField, request, usedAggregationUnit, dateAggregationFields, entityField, ctx, methodId)).sequential().buffer(100000).flatMap(fieldValues -> this.preagregate(fieldValues, viewField, request, usedAggregationUnit, dateAggregationFields, entityField, ctx, methodId)).buffer(10000).flatMap(fieldValues -> this.preagregate(fieldValues, viewField, request, usedAggregationUnit, dateAggregationFields, entityField, ctx, methodId)).collectList().map(aggregatedValueList -> {
            List collectedItems = (List)ctx.getCollectedItems().get(methodId);
            return this.groupAndAggregate(entityField, aggregatedValueList, request, ctx, collectedItems, usedAggregationUnit, dateAggregationFields, viewField, methodId);
        }).map(aggregatedValueList -> this.postProcessDurationPercent(aggregatedValueList, request, viewField));
    }

    public Flux<FieldValue> preagregate(List<FieldValue> fieldValues, ViewField viewField, ViewRequest request, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, BusinessEntityField entityField, ViewContext ctx, long methodId) {
        List items = fieldValues.stream().flatMap(fv -> fv.getItems().stream()).distinct().collect(Collectors.toList());
        return Flux.fromIterable((Iterable)this.groupAndAggregate(entityField, fieldValues, request, ctx, items, usedAggregationUnit, dateAggregationFields, viewField, methodId)).flatMap(agVal -> {
            if (agVal.hasDateGroups()) {
                return Flux.fromIterable(agVal.getDateGroups().values());
            }
            return Flux.just((Object)agVal.getFieldValue());
        });
    }

    private List<AggregatedValue> groupAndAggregate(BusinessEntityField entityField, List<FieldValue> itemValues, ViewRequest request, ViewContext ctx, List<Item> items, DateAggregationType usedAggregationUnit, List<ViewField> dateAggregationFields, ViewField viewField, long methodId) {
        boolean hasTime = this.hasTime(entityField, viewField);
        if (usedAggregationUnit != null && hasTime && viewField.getAggregationType() != FieldAggregation.UNIQ) {
            Multimap groupedValues = this.dateGrouper.groupByDateFields(hasTime, itemValues, usedAggregationUnit, dateAggregationFields, request);
            groupedValues = this.filterService.filterDayGroups(groupedValues, request, ctx);
            return Collections.singletonList(this.aggregateDayGroup(entityField, groupedValues, items, viewField));
        }
        if (itemValues.isEmpty()) {
            return Collections.singletonList(new AggregatedValue(new FieldValue(Collections.emptySet(), FieldType.BLANK, null), Flux.fromIterable(items)));
        }
        return this.aggregateValues(entityField, viewField, itemValues);
    }

    private AggregatedValue aggregateDayGroup(BusinessEntityField entityField, Multimap<DateAggregationGroup, FieldValue> groupedValues, List<Item> items, ViewField viewField) {
        Flux itemFlux = Flux.fromIterable(items);
        if (groupedValues.isEmpty()) {
            return new AggregatedValue(new FieldValue((Set)Sets.newHashSet(items), FieldType.BLANK, null), itemFlux);
        }
        AggregatedValue dateAggregation = new AggregatedValue(null, itemFlux, new HashMap());
        for (DateAggregationGroup group : groupedValues.keySet()) {
            Collection fieldValues = groupedValues.get((Object)group);
            List dateSubGroups = this.aggregateValues(entityField, viewField, fieldValues);
            if (dateSubGroups.size() > 1) {
                throw new IllegalStateException("Subgroup Aggregation is not allowed for fields with day grouping");
            }
            dateAggregation.getDateGroups().put(group, ((AggregatedValue)dateSubGroups.get(0)).getFieldValue());
        }
        return dateAggregation;
    }

    private boolean hasTime(BusinessEntityField entityField, ViewField viewField) {
        return viewField.isBatchCalculation() || viewField.isStateField() || entityField.hasTime();
    }

    private List<AggregatedValue> aggregateValues(BusinessEntityField entityField, ViewField viewField, Collection<FieldValue> fieldValues) {
        Set groupItems = fieldValues.stream().flatMap(f -> f.getItems().stream()).collect(Collectors.toSet());
        List nonBlankFieldValues = fieldValues.stream().filter(fv -> !fv.getFieldType().equals((Object)FieldType.BLANK)).collect(Collectors.toList());
        long optionalTs = 0L;
        if (this.hasTime(entityField, viewField) && (optionalTs = nonBlankFieldValues.stream().map(FieldValue::getTs).findFirst().orElse(0L).longValue()) == 0L) {
            optionalTs = fieldValues.stream().map(FieldValue::getTs).findFirst().orElse(0L);
        }
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[viewField.getAggregationType().ordinal()]) {
            case 1: 
            case 2: {
                ArrayListMultimap grouped = ArrayListMultimap.create();
                for (Object fv2 : nonBlankFieldValues) {
                    grouped.put(fv2.getInnerValue(), fv2);
                }
                ArrayList groupedResult = Lists.newArrayList();
                for (Map.Entry entry : grouped.asMap().entrySet()) {
                    FieldValue firstValue = (FieldValue)((Collection)entry.getValue()).iterator().next();
                    Set items = ((Collection)entry.getValue()).stream().flatMap(f -> f.getItems().stream()).collect(Collectors.toSet());
                    firstValue.setItems(items);
                    groupedResult.add(new AggregatedValue(firstValue, Flux.fromIterable(items)));
                }
                return groupedResult;
            }
            case 3: {
                double avg = nonBlankFieldValues.stream().filter(v -> v.getNumeric().isPresent()).mapToDouble(v -> (Double)v.getNumeric().get()).average().orElse(0.0);
                return Collections.singletonList(new AggregatedValue(new FieldValue(groupItems, FieldType.NUMERIC, (Object)avg, optionalTs), Flux.fromIterable(groupItems)));
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                double sum = nonBlankFieldValues.stream().filter(v -> v.getNumeric().isPresent()).mapToDouble(v -> (Double)v.getNumeric().get()).sum();
                return Collections.singletonList(new AggregatedValue(new FieldValue(groupItems, FieldType.NUMERIC, (Object)sum, optionalTs), Flux.fromIterable(groupItems)));
            }
            case 9: {
                double min = nonBlankFieldValues.stream().filter(v -> v.getNumeric().isPresent()).mapToDouble(v -> (Double)v.getNumeric().get()).min().orElse(Double.MAX_VALUE);
                return Collections.singletonList(new AggregatedValue(new FieldValue(groupItems, FieldType.NUMERIC, (Object)min, optionalTs), Flux.fromIterable(groupItems)));
            }
            case 10: {
                double max = nonBlankFieldValues.stream().filter(v -> v.getNumeric().isPresent()).mapToDouble(v -> (Double)v.getNumeric().get()).max().orElse(Double.MIN_VALUE);
                return Collections.singletonList(new AggregatedValue(new FieldValue(groupItems, FieldType.NUMERIC, (Object)max, optionalTs), Flux.fromIterable(groupItems)));
            }
        }
        throw new IllegalStateException("Aggregation not implemented for " + viewField.getAggregationType());
    }

    private List<AggregatedValue> postProcessDurationPercent(List<AggregatedValue> aggregatedValues, ViewRequest request, ViewField viewField) {
        if (viewField.isStateField() && viewField.getAggregationType() == FieldAggregation.DURATION_PERCENT) {
            long totalRange = request.getEndTs() - request.getStartTs();
            aggregatedValues.forEach(av -> {
                if (av.getFieldValue() != null && CollectionUtils.isNotEmpty((Collection)av.getFieldValue().getItems()) && av.getFieldValue().getInnerValue() != null) {
                    double summedRangeDuration = totalRange * (long)av.getFieldValue().getItems().size();
                    double durationPercent = (Double)av.getFieldValue().getInnerValue() * 100.0 / summedRangeDuration;
                    av.getFieldValue().setInnerValue((Object)durationPercent);
                } else if (av.getFieldValue() == null && av.hasDateGroups()) {
                    ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)request.getMinimalDateAggregation());
                    av.getDateGroups().entrySet().forEach(e -> {
                        long currentTs = ((FieldValue)e.getValue()).getTs();
                        ZonedDateTime currentDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTs), ZoneId.systemDefault());
                        ZonedDateTime currentPeriodStart = DateAggregationType.extendedTruncateTo((ZonedDateTime)currentDate, (TemporalUnit)timeUnit);
                        ZonedDateTime currentPeriodEnd = DateAggregationType.extendedTruncateTo((ZonedDateTime)currentDate, (TemporalUnit)timeUnit).plus(1L, timeUnit);
                        long startTime = currentPeriodStart.toEpochSecond() * 1000L;
                        long endTime = Math.min(currentPeriodEnd.toEpochSecond() * 1000L, System.currentTimeMillis());
                        long duration = endTime - startTime;
                        if (duration == Long.MAX_VALUE) {
                            duration = request.getEndTs() - request.getStartTs();
                        }
                        double summedRangeDuration = duration * (long)((FieldValue)e.getValue()).getItems().size();
                        double durationPercent = (Double)((FieldValue)e.getValue()).getInnerValue() * 100.0 / summedRangeDuration;
                        if (Double.isNaN(durationPercent) || Double.isInfinite(durationPercent)) {
                            durationPercent = 0.0;
                        }
                        ((FieldValue)e.getValue()).setInnerValue((Object)durationPercent);
                    });
                } else {
                    log.trace("WTF?");
                }
            });
        }
        return aggregatedValues;
    }
}

