/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.view.proto.DateAggregationGroup;
import reactor.core.publisher.Flux;

public class AggregatedValue {
    private FieldValue fieldValue;
    private Flux<Item> items;
    private Map<DateAggregationGroup, FieldValue> dateGroups;

    public AggregatedValue(FieldValue fieldValue, Flux<Item> items) {
        this.fieldValue = fieldValue;
        this.items = items;
    }

    public boolean hasDateGroups() {
        return MapUtils.isNotEmpty((Map)this.dateGroups);
    }

    public String toString() {
        return "AggregatedValue{fieldValue=" + (this.fieldValue == null ? null : this.fieldValue.getInnerValue()) + ", items=" + (this.items == null ? null : (Long)this.items.count().toProcessor().block()) + ", dateAggregationGroup=" + this.dateGroups + '}';
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    public Flux<Item> getItems() {
        return this.items;
    }

    public Map<DateAggregationGroup, FieldValue> getDateGroups() {
        return this.dateGroups;
    }

    public AggregatedValue(FieldValue fieldValue, Flux<Item> items, Map<DateAggregationGroup, FieldValue> dateGroups) {
        this.fieldValue = fieldValue;
        this.items = items;
        this.dateGroups = dateGroups;
    }
}

