/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.runtime.ViewTask;

@Component
public class ViewTaskCache {
    private static final Logger log = LoggerFactory.getLogger(ViewTaskCache.class);
    private Map<UUID, ViewTask> taskCache = new ConcurrentHashMap();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    public void init() {
        this.executorService.scheduleAtFixedRate(() -> {
            HashSet forRemove = Sets.newHashSet();
            for (Map.Entry entry : this.taskCache.entrySet()) {
                if (((ViewTask)entry.getValue()).isFinished()) {
                    if (System.currentTimeMillis() - ((ViewTask)entry.getValue()).getFinishedAt() <= TimeUnit.SECONDS.toMillis(60L)) continue;
                    forRemove.add(entry.getKey());
                    continue;
                }
                if (System.currentTimeMillis() - ((ViewTask)entry.getValue()).getCreatedAt() > TimeUnit.MINUTES.toMillis(60L)) {
                    this.cancelTask((UUID)entry.getKey(), "task expired");
                    forRemove.add(entry.getKey());
                    log.warn("Long running View Task detected id [{}] created [{}]", entry.getKey(), (Object)((ViewTask)entry.getValue()).getCreatedAt());
                    continue;
                }
                if (System.currentTimeMillis() - ((ViewTask)entry.getValue()).getLastRequestedAt() <= TimeUnit.MINUTES.toMillis(5L)) continue;
                this.cancelTask((UUID)entry.getKey(), "task result not requested");
                forRemove.add(entry.getKey());
                log.warn("Cancel task because it is not required anymore detected id [{}] created [{}]", entry.getKey(), (Object)((ViewTask)entry.getValue()).getCreatedAt());
            }
            forRemove.forEach(id -> {
                ViewTask cfr_ignored_0 = (ViewTask)this.taskCache.remove(id);
            });
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void close() {
        this.executorService.shutdownNow();
    }

    public Optional<ViewTask> getTask(UUID id) {
        ViewTask viewTask = (ViewTask)this.taskCache.get(id);
        if (viewTask != null) {
            viewTask.setLastRequestedAt(System.currentTimeMillis());
            return Optional.of(viewTask);
        }
        return Optional.empty();
    }

    public void addInProgressTask(ViewTask viewTask) {
        viewTask.setCreatedAt(System.currentTimeMillis());
        viewTask.setLastRequestedAt(System.currentTimeMillis());
        this.taskCache.put(viewTask.getId(), viewTask);
    }

    public void finishTask(UUID taskId) {
        Optional task = this.getTask(taskId);
        if (task.isPresent()) {
            ((ViewTask)task.get()).setFinishedAt(System.currentTimeMillis());
            ((ViewTask)task.get()).setFinished(true);
            long duration = TimeUnit.MILLISECONDS.toMillis(((ViewTask)task.get()).getFinishedAt() - ((ViewTask)task.get()).getCreatedAt());
            int reportSize = -1;
            if (((ViewTask)task.get()).getResult().getRows() != null) {
                reportSize = ((ViewTask)task.get()).getResult().getRows().size();
            }
            log.info("Report data ready in {} millis. Rows {}", (Object)duration, (Object)reportSize);
        } else {
            log.warn("Task {} finished, but was canceled previously", (Object)taskId);
        }
    }

    public void cancelTask(UUID taskId, String reason) {
        Optional task = this.getTask(taskId);
        if (task.isPresent() && !((ViewTask)task.get()).isFinished()) {
            ((ViewTask)task.get()).setCanceled(true);
            ((ViewTask)task.get()).setCancelReason(reason);
            if (((ViewTask)task.get()).getDisposableTask() != null) {
                ((ViewTask)task.get()).getDisposableTask().dispose();
            }
        } else {
            log.warn("Task {} was canceled/finished previously", (Object)taskId);
        }
    }
}

