/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.service.view.ViewService;
import org.thingsboard.trendz.service.view.ViewTaskCache;

@Service
public class ViewServiceImpl
implements ViewService {
    private static final Logger log = LoggerFactory.getLogger(ViewServiceImpl.class);
    @Autowired
    private ViewTaskCache viewTaskCache;
    @Autowired
    private ViewBuildingService viewBuildingService;
    private ExecutorService uiTaskExecutorService;
    private ExecutorService modelTaskExecutorService;
    @Value(value="${executors.uiBuild}")
    private int uiBuildThreadCount;
    @Value(value="${executors.modelBuild}")
    private int modelBuildThreadCount;

    @PostConstruct
    public void init() {
        this.uiTaskExecutorService = Executors.newFixedThreadPool(this.uiBuildThreadCount);
        this.modelTaskExecutorService = Executors.newFixedThreadPool(this.modelBuildThreadCount);
    }

    @PreDestroy
    public void destroy() {
        this.uiTaskExecutorService.shutdownNow();
        this.modelTaskExecutorService.shutdownNow();
    }

    public ViewTask buildViewAsync(ViewConfig config, TenantId tenantId, String jwtToken) {
        return this.buildWithGivenExecutor(config, tenantId, jwtToken, this.uiTaskExecutorService);
    }

    public ViewTask buildViewAsyncForModel(ViewConfig config, TenantId tenantId, String jwtToken) {
        return this.buildWithGivenExecutor(config, tenantId, jwtToken, this.modelTaskExecutorService);
    }

    private ViewTask buildWithGivenExecutor(ViewConfig config, TenantId tenantId, String jwtToken, ExecutorService executorService) {
        ViewTask viewTask = new ViewTask();
        viewTask.setId(TimeStampUUIDGenerator.generateId());
        this.viewTaskCache.addInProgressTask(viewTask);
        log.info("Submit View Task for execution {}", (Object)viewTask.getId());
        executorService.submit(() -> {
            try {
                log.info("Start building View Report for task {}", (Object)viewTask.getId());
                ViewReport viewReport = this.viewBuildingService.buildView(config, viewTask, tenantId, jwtToken);
                viewTask.setResult(viewReport);
                this.viewTaskCache.finishTask(viewTask.getId());
                log.debug("View Report ready for task {}", (Object)viewTask.getId());
            }
            catch (Exception ex) {
                log.error("Problem while build View Report " + viewTask.getId(), (Throwable)ex);
                this.viewTaskCache.cancelTask(viewTask.getId(), ex.getMessage());
            }
        });
        return viewTask;
    }
}

