/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationGraph;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.cache.PreloadedCache;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.view.proto.RequestStats;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStore;

public class ViewContext {
    private static final Logger log = LoggerFactory.getLogger(ViewContext.class);
    private Map<UUID, BusinessEntity> businessEntityMap = new HashMap();
    private Map<UUID, BusinessEntityField> businessEntityFieldMap = new HashMap();
    private Map<UUID, BusinessEntity> fieldToEntityMap = new HashMap();
    private Map<UUID, Set<Object>> distinctFieldValues = new ConcurrentHashMap();
    private List<FilterOptionTask> fieldFilterOptionTasks = new CopyOnWriteArrayList();
    private Map<UUID, String> customerDictionary = new ConcurrentHashMap();
    private Map<UUID, StreamTelemetryStore> streamStoreMap = new ConcurrentHashMap();
    private Map<UUID, List<FieldValue>> timeEventFields = new ConcurrentHashMap();
    private Map<String, List<State>> computedStates = new ConcurrentHashMap();
    private Map<UUID, List<State>> statesByItem = new ConcurrentHashMap();
    private long maxRealTs;
    private AtomicLong processFieldMethodIdCounter = new AtomicLong(0L);
    private Map<Long, List<Item>> collectedItems = new ConcurrentHashMap();
    private PreloadedCache preloadedCache = new PreloadedCache();
    private List<ViewField> orderedFields;
    private RelationGraph relationGraph;
    private RowBuilder rowBuilder;
    private TenantId tenantId;
    private String jwtToken;
    private RequestStats stats;

    public ViewContext(List<BusinessEntity> allEntities, RelationGraph relationGraph, TenantId tenantId, String jwtToken) {
        for (BusinessEntity entity : allEntities) {
            this.businessEntityMap.put(entity.getId(), entity);
            for (BusinessEntityField field : entity.getFields()) {
                this.businessEntityFieldMap.put(field.getId(), field);
                this.fieldToEntityMap.put(field.getId(), entity);
            }
        }
        this.relationGraph = relationGraph;
        this.tenantId = tenantId;
        this.jwtToken = jwtToken;
    }

    public void addFieldValue(UUID viewFieldId, Object value) {
        if (value != null) {
            Set values = this.distinctFieldValues.computeIfAbsent(viewFieldId, k -> ConcurrentHashMap.newKeySet());
            values.add(value);
        }
    }

    public StreamTelemetryStore getStreamStore(UUID beFieldId) {
        return this.streamStoreMap.computeIfAbsent(beFieldId, k -> new StreamTelemetryStore());
    }

    public void addNoneAgrValue(UUID beFieldId, FieldValue fv) {
        List valueStore = this.timeEventFields.computeIfAbsent(beFieldId, id -> new ArrayList());
        if (valueStore.size() < 100) {
            valueStore.add(fv);
        }
    }

    public void addState(State state, Item item) {
        List stateStore = this.computedStates.computeIfAbsent(state.getValue().toString(), id -> new ArrayList());
        if (stateStore.size() < 1000) {
            stateStore.add(state);
        }
        List states = this.statesByItem.computeIfAbsent(item.getId(), id -> new ArrayList());
        states.add(state);
    }

    public List<FieldFilterOption> getFieldFilterOptions() {
        ArrayList result = Lists.newArrayList();
        for (UUID viewFieldId : this.distinctFieldValues.keySet()) {
            TreeSet distinctOptions = new TreeSet(((Set)this.distinctFieldValues.get(viewFieldId)).stream().map(Object::toString).collect(Collectors.toSet()));
            result.add(new FieldFilterOption(viewFieldId, distinctOptions));
        }
        return result;
    }

    public Optional<UUID> findParentEntityId(ViewField field) {
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityMap.get(field.getBusinessEntityId());
        RelationNode relationNode = this.relationGraph.getNodeById(businessEntity.getId());
        if (relationNode.getShortestPath().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((RelationNode)relationNode.getShortestPath().get(relationNode.getShortestPath().size() - 1)).getEntityId());
    }

    public Optional<ViewField> findNearestParentField(UUID parentEntityId, ViewField field) {
        ViewField nearest = null;
        for (ViewField viewField : this.orderedFields) {
            if (viewField.getBusinessEntityId().equals(parentEntityId)) {
                nearest = viewField;
            }
            if (!viewField.equals((Object)field)) continue;
            break;
        }
        return Optional.ofNullable(nearest);
    }

    public Map<UUID, BusinessEntity> getBusinessEntityMap() {
        return this.businessEntityMap;
    }

    public Map<UUID, BusinessEntityField> getBusinessEntityFieldMap() {
        return this.businessEntityFieldMap;
    }

    public Map<UUID, BusinessEntity> getFieldToEntityMap() {
        return this.fieldToEntityMap;
    }

    public Map<UUID, Set<Object>> getDistinctFieldValues() {
        return this.distinctFieldValues;
    }

    public List<FilterOptionTask> getFieldFilterOptionTasks() {
        return this.fieldFilterOptionTasks;
    }

    public Map<UUID, String> getCustomerDictionary() {
        return this.customerDictionary;
    }

    public Map<UUID, StreamTelemetryStore> getStreamStoreMap() {
        return this.streamStoreMap;
    }

    public Map<UUID, List<FieldValue>> getTimeEventFields() {
        return this.timeEventFields;
    }

    public Map<String, List<State>> getComputedStates() {
        return this.computedStates;
    }

    public Map<UUID, List<State>> getStatesByItem() {
        return this.statesByItem;
    }

    public long getMaxRealTs() {
        return this.maxRealTs;
    }

    public AtomicLong getProcessFieldMethodIdCounter() {
        return this.processFieldMethodIdCounter;
    }

    public Map<Long, List<Item>> getCollectedItems() {
        return this.collectedItems;
    }

    public PreloadedCache getPreloadedCache() {
        return this.preloadedCache;
    }

    public List<ViewField> getOrderedFields() {
        return this.orderedFields;
    }

    public RelationGraph getRelationGraph() {
        return this.relationGraph;
    }

    public RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public RequestStats getStats() {
        return this.stats;
    }

    public void setBusinessEntityMap(Map<UUID, BusinessEntity> businessEntityMap) {
        this.businessEntityMap = businessEntityMap;
    }

    public void setBusinessEntityFieldMap(Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        this.businessEntityFieldMap = businessEntityFieldMap;
    }

    public void setFieldToEntityMap(Map<UUID, BusinessEntity> fieldToEntityMap) {
        this.fieldToEntityMap = fieldToEntityMap;
    }

    public void setDistinctFieldValues(Map<UUID, Set<Object>> distinctFieldValues) {
        this.distinctFieldValues = distinctFieldValues;
    }

    public void setFieldFilterOptionTasks(List<FilterOptionTask> fieldFilterOptionTasks) {
        this.fieldFilterOptionTasks = fieldFilterOptionTasks;
    }

    public void setCustomerDictionary(Map<UUID, String> customerDictionary) {
        this.customerDictionary = customerDictionary;
    }

    public void setStreamStoreMap(Map<UUID, StreamTelemetryStore> streamStoreMap) {
        this.streamStoreMap = streamStoreMap;
    }

    public void setTimeEventFields(Map<UUID, List<FieldValue>> timeEventFields) {
        this.timeEventFields = timeEventFields;
    }

    public void setComputedStates(Map<String, List<State>> computedStates) {
        this.computedStates = computedStates;
    }

    public void setStatesByItem(Map<UUID, List<State>> statesByItem) {
        this.statesByItem = statesByItem;
    }

    public void setMaxRealTs(long maxRealTs) {
        this.maxRealTs = maxRealTs;
    }

    public void setProcessFieldMethodIdCounter(AtomicLong processFieldMethodIdCounter) {
        this.processFieldMethodIdCounter = processFieldMethodIdCounter;
    }

    public void setCollectedItems(Map<Long, List<Item>> collectedItems) {
        this.collectedItems = collectedItems;
    }

    public void setPreloadedCache(PreloadedCache preloadedCache) {
        this.preloadedCache = preloadedCache;
    }

    public void setOrderedFields(List<ViewField> orderedFields) {
        this.orderedFields = orderedFields;
    }

    public void setRelationGraph(RelationGraph relationGraph) {
        this.relationGraph = relationGraph;
    }

    public void setRowBuilder(RowBuilder rowBuilder) {
        this.rowBuilder = rowBuilder;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public void setStats(RequestStats stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewContext)) {
            return false;
        }
        ViewContext other = (ViewContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$businessEntityMap = this.getBusinessEntityMap();
        Map other$businessEntityMap = other.getBusinessEntityMap();
        if (this$businessEntityMap == null ? other$businessEntityMap != null : !((Object)this$businessEntityMap).equals(other$businessEntityMap)) {
            return false;
        }
        Map this$businessEntityFieldMap = this.getBusinessEntityFieldMap();
        Map other$businessEntityFieldMap = other.getBusinessEntityFieldMap();
        if (this$businessEntityFieldMap == null ? other$businessEntityFieldMap != null : !((Object)this$businessEntityFieldMap).equals(other$businessEntityFieldMap)) {
            return false;
        }
        Map this$fieldToEntityMap = this.getFieldToEntityMap();
        Map other$fieldToEntityMap = other.getFieldToEntityMap();
        if (this$fieldToEntityMap == null ? other$fieldToEntityMap != null : !((Object)this$fieldToEntityMap).equals(other$fieldToEntityMap)) {
            return false;
        }
        Map this$distinctFieldValues = this.getDistinctFieldValues();
        Map other$distinctFieldValues = other.getDistinctFieldValues();
        if (this$distinctFieldValues == null ? other$distinctFieldValues != null : !((Object)this$distinctFieldValues).equals(other$distinctFieldValues)) {
            return false;
        }
        List this$fieldFilterOptionTasks = this.getFieldFilterOptionTasks();
        List other$fieldFilterOptionTasks = other.getFieldFilterOptionTasks();
        if (this$fieldFilterOptionTasks == null ? other$fieldFilterOptionTasks != null : !((Object)this$fieldFilterOptionTasks).equals(other$fieldFilterOptionTasks)) {
            return false;
        }
        Map this$customerDictionary = this.getCustomerDictionary();
        Map other$customerDictionary = other.getCustomerDictionary();
        if (this$customerDictionary == null ? other$customerDictionary != null : !((Object)this$customerDictionary).equals(other$customerDictionary)) {
            return false;
        }
        Map this$streamStoreMap = this.getStreamStoreMap();
        Map other$streamStoreMap = other.getStreamStoreMap();
        if (this$streamStoreMap == null ? other$streamStoreMap != null : !((Object)this$streamStoreMap).equals(other$streamStoreMap)) {
            return false;
        }
        Map this$timeEventFields = this.getTimeEventFields();
        Map other$timeEventFields = other.getTimeEventFields();
        if (this$timeEventFields == null ? other$timeEventFields != null : !((Object)this$timeEventFields).equals(other$timeEventFields)) {
            return false;
        }
        Map this$computedStates = this.getComputedStates();
        Map other$computedStates = other.getComputedStates();
        if (this$computedStates == null ? other$computedStates != null : !((Object)this$computedStates).equals(other$computedStates)) {
            return false;
        }
        Map this$statesByItem = this.getStatesByItem();
        Map other$statesByItem = other.getStatesByItem();
        if (this$statesByItem == null ? other$statesByItem != null : !((Object)this$statesByItem).equals(other$statesByItem)) {
            return false;
        }
        if (this.getMaxRealTs() != other.getMaxRealTs()) {
            return false;
        }
        AtomicLong this$processFieldMethodIdCounter = this.getProcessFieldMethodIdCounter();
        AtomicLong other$processFieldMethodIdCounter = other.getProcessFieldMethodIdCounter();
        if (this$processFieldMethodIdCounter == null ? other$processFieldMethodIdCounter != null : !this$processFieldMethodIdCounter.equals(other$processFieldMethodIdCounter)) {
            return false;
        }
        Map this$collectedItems = this.getCollectedItems();
        Map other$collectedItems = other.getCollectedItems();
        if (this$collectedItems == null ? other$collectedItems != null : !((Object)this$collectedItems).equals(other$collectedItems)) {
            return false;
        }
        PreloadedCache this$preloadedCache = this.getPreloadedCache();
        PreloadedCache other$preloadedCache = other.getPreloadedCache();
        if (this$preloadedCache == null ? other$preloadedCache != null : !this$preloadedCache.equals(other$preloadedCache)) {
            return false;
        }
        List this$orderedFields = this.getOrderedFields();
        List other$orderedFields = other.getOrderedFields();
        if (this$orderedFields == null ? other$orderedFields != null : !((Object)this$orderedFields).equals(other$orderedFields)) {
            return false;
        }
        RelationGraph this$relationGraph = this.getRelationGraph();
        RelationGraph other$relationGraph = other.getRelationGraph();
        if (this$relationGraph == null ? other$relationGraph != null : !this$relationGraph.equals(other$relationGraph)) {
            return false;
        }
        RowBuilder this$rowBuilder = this.getRowBuilder();
        RowBuilder other$rowBuilder = other.getRowBuilder();
        if (this$rowBuilder == null ? other$rowBuilder != null : !this$rowBuilder.equals(other$rowBuilder)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$jwtToken = this.getJwtToken();
        String other$jwtToken = other.getJwtToken();
        if (this$jwtToken == null ? other$jwtToken != null : !this$jwtToken.equals(other$jwtToken)) {
            return false;
        }
        RequestStats this$stats = this.getStats();
        RequestStats other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !this$stats.equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $businessEntityMap = this.getBusinessEntityMap();
        result = result * 59 + ($businessEntityMap == null ? 43 : ((Object)$businessEntityMap).hashCode());
        Map $businessEntityFieldMap = this.getBusinessEntityFieldMap();
        result = result * 59 + ($businessEntityFieldMap == null ? 43 : ((Object)$businessEntityFieldMap).hashCode());
        Map $fieldToEntityMap = this.getFieldToEntityMap();
        result = result * 59 + ($fieldToEntityMap == null ? 43 : ((Object)$fieldToEntityMap).hashCode());
        Map $distinctFieldValues = this.getDistinctFieldValues();
        result = result * 59 + ($distinctFieldValues == null ? 43 : ((Object)$distinctFieldValues).hashCode());
        List $fieldFilterOptionTasks = this.getFieldFilterOptionTasks();
        result = result * 59 + ($fieldFilterOptionTasks == null ? 43 : ((Object)$fieldFilterOptionTasks).hashCode());
        Map $customerDictionary = this.getCustomerDictionary();
        result = result * 59 + ($customerDictionary == null ? 43 : ((Object)$customerDictionary).hashCode());
        Map $streamStoreMap = this.getStreamStoreMap();
        result = result * 59 + ($streamStoreMap == null ? 43 : ((Object)$streamStoreMap).hashCode());
        Map $timeEventFields = this.getTimeEventFields();
        result = result * 59 + ($timeEventFields == null ? 43 : ((Object)$timeEventFields).hashCode());
        Map $computedStates = this.getComputedStates();
        result = result * 59 + ($computedStates == null ? 43 : ((Object)$computedStates).hashCode());
        Map $statesByItem = this.getStatesByItem();
        result = result * 59 + ($statesByItem == null ? 43 : ((Object)$statesByItem).hashCode());
        long $maxRealTs = this.getMaxRealTs();
        result = result * 59 + (int)($maxRealTs >>> 32 ^ $maxRealTs);
        AtomicLong $processFieldMethodIdCounter = this.getProcessFieldMethodIdCounter();
        result = result * 59 + ($processFieldMethodIdCounter == null ? 43 : $processFieldMethodIdCounter.hashCode());
        Map $collectedItems = this.getCollectedItems();
        result = result * 59 + ($collectedItems == null ? 43 : ((Object)$collectedItems).hashCode());
        PreloadedCache $preloadedCache = this.getPreloadedCache();
        result = result * 59 + ($preloadedCache == null ? 43 : $preloadedCache.hashCode());
        List $orderedFields = this.getOrderedFields();
        result = result * 59 + ($orderedFields == null ? 43 : ((Object)$orderedFields).hashCode());
        RelationGraph $relationGraph = this.getRelationGraph();
        result = result * 59 + ($relationGraph == null ? 43 : $relationGraph.hashCode());
        RowBuilder $rowBuilder = this.getRowBuilder();
        result = result * 59 + ($rowBuilder == null ? 43 : $rowBuilder.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $jwtToken = this.getJwtToken();
        result = result * 59 + ($jwtToken == null ? 43 : $jwtToken.hashCode());
        RequestStats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        return result;
    }

    public String toString() {
        return "ViewContext(businessEntityMap=" + this.getBusinessEntityMap() + ", businessEntityFieldMap=" + this.getBusinessEntityFieldMap() + ", fieldToEntityMap=" + this.getFieldToEntityMap() + ", distinctFieldValues=" + this.getDistinctFieldValues() + ", fieldFilterOptionTasks=" + this.getFieldFilterOptionTasks() + ", customerDictionary=" + this.getCustomerDictionary() + ", streamStoreMap=" + this.getStreamStoreMap() + ", timeEventFields=" + this.getTimeEventFields() + ", computedStates=" + this.getComputedStates() + ", statesByItem=" + this.getStatesByItem() + ", maxRealTs=" + this.getMaxRealTs() + ", processFieldMethodIdCounter=" + this.getProcessFieldMethodIdCounter() + ", collectedItems=" + this.getCollectedItems() + ", preloadedCache=" + this.getPreloadedCache() + ", orderedFields=" + this.getOrderedFields() + ", relationGraph=" + this.getRelationGraph() + ", rowBuilder=" + this.getRowBuilder() + ", tenantId=" + this.getTenantId() + ", jwtToken=" + this.getJwtToken() + ", stats=" + this.getStats() + ")";
    }
}

