/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationGraph;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationUtils;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.TimeEvent;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.RelationGraphService;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.state.StateConditionParser;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.view.CachedViewService;
import org.thingsboard.trendz.service.view.CustomerCache;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.ViewTaskCache;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.AggregationService;
import org.thingsboard.trendz.service.view.proto.DataLoader;
import org.thingsboard.trendz.service.view.proto.FieldState;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.LoadFieldOrderer;
import org.thingsboard.trendz.service.view.proto.RequestStats;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class ViewBuildingServiceImpl
implements ViewBuildingService {
    private static final Logger log = LoggerFactory.getLogger(ViewBuildingServiceImpl.class);
    @Autowired
    private LoadFieldOrderer loadFieldOrderer;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ViewTaskCache viewTaskCache;
    @Autowired
    private DataLoader dataLoader;
    @Autowired
    private AggregationService aggregationService;
    @Autowired
    private FilterService filterService;
    @Autowired
    private BusinessEntityService businessEntityService;
    @Autowired
    private RelationGraphService relationGraphService;
    @Autowired
    private StateConditionParser stateConditionParser;
    @Autowired
    private CachedViewService cachedViewService;
    @Autowired
    private CustomerCache customerCache;
    @Autowired
    private StatsCollector statsCollector;
    private final Scheduler scheduler = Schedulers.newParallel((String)"parallel-scheduler-viewbuilder", (int)3);

    @PreDestroy
    public void destroy() {
        this.scheduler.dispose();
    }

    public ViewReport buildView(ViewConfig config, ViewTask viewTask, TenantId tenantId, String jwtToken) throws InterruptedException {
        RequestStats stats = new RequestStats();
        stats.setSubmitTs(System.currentTimeMillis());
        ViewRequest request = new ViewRequest(config);
        this.checkNeedTruncateRequestTimeRanges(request);
        Optional optional = this.cachedViewService.getFromCache(config, tenantId, jwtToken);
        if (optional.isPresent()) {
            log.info("Reuse ViewResult from Report Cache for task, ID: {}", (Object)viewTask.getId());
            return (ViewReport)optional.get();
        }
        this.stateConditionParser.parse(request, tenantId);
        ViewContext ctx = this.initContext(request, tenantId, jwtToken, stats);
        ctx.setStats(stats);
        List orderedFields = this.loadFieldOrderer.order(request, ctx);
        ctx.setOrderedFields(orderedFields);
        stats.setInitFinishTs(System.currentTimeMillis());
        this.processViewRequest(request, ctx, viewTask);
        if (!viewTask.isCanceled()) {
            ctx.getRowBuilder().filterBlankFields(request);
            List rows = ctx.getRowBuilder().build(request, ctx);
            ArrayList events = Lists.newArrayList();
            for (Map.Entry entry : ctx.getTimeEventFields().entrySet()) {
                events.addAll(((List)entry.getValue()).stream().map(fv -> new TimeEvent((UUID)entry.getKey(), fv.getTs(), fv.getInnerValue(), ((Item)fv.getItems().iterator().next()).getName())).collect(Collectors.toList()));
            }
            long filterWatStartTs = System.currentTimeMillis();
            for (FilterOptionTask optionTask : ctx.getFieldFilterOptionTasks()) {
                if (!optionTask.getStarted().get()) continue;
                optionTask.getLatch().await();
            }
            this.businessEntityService.updateFieldOptions(ctx.getTenantId(), ctx.getFieldFilterOptions(), ctx.getOrderedFields());
            stats.setFilterOptionsWaitTime(System.currentTimeMillis() - filterWatStartTs);
            List states = ctx.getComputedStates().values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
            ViewReport viewReport = new ViewReport(rows, (List)events, states, ctx.getFieldFilterOptions(), Long.valueOf(ctx.getMaxRealTs()));
            this.cachedViewService.cacheReport(config, tenantId, jwtToken, viewReport);
            stats.setFinishTs(System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                ctx.getStats().printDebug(ctx);
                this.statsCollector.logRequestStats();
            }
            return viewReport;
        }
        return null;
    }

    private void processViewRequest(ViewRequest request, ViewContext ctx, ViewTask viewTask) throws InterruptedException {
        Row firstRow = new Row(ctx.getOrderedFields());
        RowBuilder rowBuilder = new RowBuilder(firstRow);
        ctx.setRowBuilder(rowBuilder);
        long startTs = System.currentTimeMillis();
        AtomicBoolean isModified = new AtomicBoolean((Boolean)this.processNextField(rowBuilder, firstRow, request, ctx, viewTask).block());
        int iteration = ctx.getStats().getMainIterations().incrementAndGet();
        ctx.getStats().getIterationDuration().put(iteration, System.currentTimeMillis() - startTs);
        this.statsCollector.tick("viewFieldProcessed", startTs, System.currentTimeMillis(), TickType.VIEW_FIELD_TICK);
        startTs = System.currentTimeMillis();
        while (isModified.get() && !viewTask.isCanceled()) {
            CountDownLatch latch = new CountDownLatch(1);
            isModified.set(false);
            ctx.getStats().getRowsAfterIteration().put(ctx.getStats().getMainIterations().get(), rowBuilder.getAllRows().size());
            Disposable asyncTask = Flux.fromIterable((Iterable)rowBuilder.getAllRows()).flatMap(row -> this.processNextField(rowBuilder, row, request, ctx, viewTask)).doOnNext(modified -> isModified.set(isModified.get() || modified != false)).doOnCancel(() -> {
                log.warn("View Task canceled");
                latch.countDown();
            }).collectList().subscribe(ok -> latch.countDown(), err -> {
                log.error("View Task failed", err);
                this.viewTaskCache.cancelTask(viewTask.getId(), err.getMessage());
                latch.countDown();
            });
            if (viewTask.isCanceled() && !asyncTask.isDisposed()) {
                asyncTask.dispose();
            }
            viewTask.setDisposableTask(asyncTask);
            latch.await();
            this.statsCollector.tick("viewFieldProcessed", startTs, System.currentTimeMillis(), TickType.VIEW_FIELD_TICK);
            iteration = ctx.getStats().getMainIterations().incrementAndGet();
            log.debug("Row {} finished. Current rows size {}", (Object)iteration, (Object)rowBuilder.getAllRows().size());
            ctx.getStats().getIterationDuration().put(iteration, System.currentTimeMillis() - startTs);
            startTs = System.currentTimeMillis();
        }
    }

    private Mono<Boolean> processNextField(RowBuilder rowBuilder, Row row, ViewRequest request, ViewContext context, ViewTask viewTask) {
        long methodId = context.getProcessFieldMethodIdCounter().addAndGet(1L);
        long startTs = System.currentTimeMillis();
        AtomicLong processingStartTs = new AtomicLong();
        Optional optionalField = row.getNextUnprocessed();
        boolean modified = optionalField.isPresent();
        if (viewTask.isCanceled()) {
            throw new IllegalStateException("Task was canceled");
        }
        if (modified) {
            Mono aggregatedValues;
            ViewField field = (ViewField)optionalField.get();
            Flux items = this.loadItems(context, request, field, row, methodId).collectList().doOnNext(list -> context.getCollectedItems().put(methodId, list)).doOnNext(list -> log.trace("Found [{}] items for field [{}]", (Object)list.size(), (Object)field.getLabel())).doOnNext(l -> {
                context.getStats().getItemsLoadTime().computeIfAbsent(field, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs);
                processingStartTs.set(System.currentTimeMillis());
            }).flatMapIterable(list -> list);
            WindowedStreamStore windowedStreamStore = this.buildCurrentGroup(row, request, context);
            if (field.isMissedRelationField()) {
                aggregatedValues = Mono.justOrEmpty(Collections.singletonList(new AggregatedValue(null, items)));
            } else {
                ParallelFlux loadingData = this.dataLoader.loadData(field, items, windowedStreamStore, request, context, methodId);
                aggregatedValues = this.aggregationService.aggregate(loadingData, field, request.getMinimalDateAggregation(), request.getDateAggregationFields(), request, context, methodId);
            }
            return aggregatedValues.doOnNext(values -> context.getStats().getFieldValueLoadAndAggregateTime().computeIfAbsent(field, i -> new AtomicLong()).addAndGet(System.currentTimeMillis() - processingStartTs.get())).map(values -> this.finishRowProcessing(modified, values, field, row, rowBuilder, request, context)).doOnNext(nextModified -> context.getStats().getTotalFieldProcessingTime().computeIfAbsent(field, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs)).doOnNext(nextModified -> this.statsCollector.tick("rowFieldProcessed_" + field.getLabel(), startTs, System.currentTimeMillis(), TickType.ROW_TICK));
        }
        return Mono.justOrEmpty((Object)modified);
    }

    private WindowedStreamStore buildCurrentGroup(Row row, ViewRequest request, ViewContext ctx) {
        WindowedStreamStore windowedStore = new WindowedStreamStore();
        for (ViewField field : request.getFields()) {
            Object grKey;
            FieldState fieldState;
            if (field.isStateField()) {
                fieldState = row.getFieldState(field);
                if (field.getAggregationType() != FieldAggregation.UNIQ || !fieldState.isProcessed()) continue;
                windowedStore.getCurrentStates().add(fieldState.getValue().getFieldValue().getInnerState());
                grKey = fieldState.getValue().getFieldValue().getInnerValue();
                if (grKey == null) continue;
                windowedStore.getGroupKeys().put(field, grKey);
                continue;
            }
            if (field.getAggregationType() != FieldAggregation.UNIQ || ((BusinessEntityField)ctx.getBusinessEntityFieldMap().get(field.getEntityFieldId())).getQuery().getQueryType() != FieldQueryType.TELEMETRY || !(fieldState = row.getFieldState(field)).isProcessed() || (grKey = fieldState.getValue().getFieldValue().getInnerValue()) == null) continue;
            windowedStore.getGroupKeys().put(field, grKey);
        }
        windowedStore.setCurrentRow(row);
        return windowedStore;
    }

    private Flux<Item> loadItems(ViewContext ctx, ViewRequest request, ViewField field, Row row, long methodId) {
        Optional optional = row.getEntityItems(field.getBusinessEntityId());
        if (optional.isPresent()) {
            return (Flux)optional.get();
        }
        Optional parentEntityId = ctx.findParentEntityId(field);
        if (parentEntityId.isPresent()) {
            Optional nearestParentField = ctx.findNearestParentField((UUID)parentEntityId.get(), field);
            Flux parentItems = (Flux)row.getEntityItems(((ViewField)nearestParentField.get()).getBusinessEntityId()).get();
            return this.itemService.loadRelated(ctx, request, parentItems, (UUID)parentEntityId.get(), field.getBusinessEntityId(), ctx.getJwtToken());
        }
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(field.getBusinessEntityId());
        return this.itemService.loadItems(businessEntity, request, ctx, ctx.getJwtToken());
    }

    private ViewContext initContext(ViewRequest request, TenantId tenantId, String jwtToken, RequestStats stats) {
        RelationGraph relationGraph = this.relationGraphService.getRelationGraph(tenantId, request);
        List allEntities = this.businessEntityService.getAllEntities(tenantId);
        this.validateRequest(request, allEntities);
        this.addMissedRelationFields(request, relationGraph);
        ViewContext ctx = new ViewContext(allEntities, relationGraph, tenantId, jwtToken);
        boolean withOwner = request.getFields().stream().filter(f -> !f.isMissedRelationField()).filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).anyMatch(f -> ((BusinessEntityField)ctx.getBusinessEntityFieldMap().get(f.getEntityFieldId())).getQuery().getQueryType().equals((Object)FieldQueryType.OWNER));
        if (withOwner) {
            request.setOwnerRequired(true);
            long startTs = System.currentTimeMillis();
            ctx.getCustomerDictionary().putAll(this.customerCache.getCustomerDictionary(jwtToken));
            stats.setCustomerDictionaryLoadTime(System.currentTimeMillis() - startTs);
        }
        if (request.isCacheRequired()) {
            request.setCacheItemTelemetry(true);
            log.debug("Telemetry cache enabled");
        }
        this.initAndValidateRoot(request, relationGraph, ctx);
        JsonNode rawDataLoadingNode = request.getSettings().get("rawDataLoading");
        boolean rawDataLoading = rawDataLoadingNode != null && rawDataLoadingNode.booleanValue();
        request.setStreamProcessingEnabled(rawDataLoading);
        for (ViewField field : request.getFields()) {
            BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(field.getEntityFieldId());
            if (entityField == null || entityField.getQuery().getQueryType() != FieldQueryType.TELEMETRY || field.getAggregationType() != FieldAggregation.UNIQ) continue;
            request.setStreamProcessingEnabled(true);
            break;
        }
        if (!DateAggregationType.isLoadableAggregationType((DateAggregationType)request.getMinimalDateAggregation())) {
            request.setStreamProcessingEnabled(true);
        }
        return ctx;
    }

    private void initAndValidateRoot(ViewRequest request, RelationGraph relationGraph, ViewContext ctx) {
        Set entityIds;
        if (request.getRootEntityId() == null) {
            Set entitiesIdsWithTelemetry = request.getFields().stream().filter(f -> !f.isMissedRelationField()).filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).filter(f -> ((BusinessEntityField)ctx.getBusinessEntityFieldMap().get(f.getEntityFieldId())).getQuery().getQueryType() == FieldQueryType.TELEMETRY).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
            Set entityIds2 = request.getFields().stream().filter(f -> f.isEnableRuntimeFilter()).filter(f -> !entitiesIdsWithTelemetry.contains(f.getBusinessEntityId())).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
            if (entityIds2.isEmpty()) {
                entityIds2 = request.getFields().stream().filter(f -> !f.isMissedRelationField()).filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).filter(f -> !entitiesIdsWithTelemetry.contains(f.getBusinessEntityId())).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
            }
            if (entityIds2.isEmpty()) {
                entityIds2 = request.getFields().stream().filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
            }
            UUID defaultRootId = RelationUtils.findDefaultRoot((RelationGraph)relationGraph, entityIds2);
            request.setRootEntityId(defaultRootId);
            log.info("Set default root {}", (Object)this.businessEntityService.findEntityById(ctx.getTenantId(), defaultRootId).getName());
        }
        if ((entityIds = request.getFields().stream().filter(f -> f.getBusinessEntityId() != null).map(ViewField::getBusinessEntityId).collect(Collectors.toSet())).size() > 1) {
            RelationUtils.calculateShortestPathFromSource((RelationNode)relationGraph.getNodeById(request.getRootEntityId()));
            for (UUID entityId : entityIds) {
                if (relationGraph.getNodeById(entityId).getDistance() != Integer.MAX_VALUE) continue;
                log.error("Node {} is not connected with the root {}", (Object)entityId, (Object)request.getRootEntityId());
                String msg = "Entity " + this.businessEntityService.findEntityById(ctx.getTenantId(), entityId).getName() + " is not connected with the " + this.businessEntityService.findEntityById(ctx.getTenantId(), request.getRootEntityId()).getName();
                throw new IllegalStateException(msg);
            }
        }
    }

    private void addMissedRelationFields(ViewRequest request, RelationGraph relationGraph) {
        Set entityIds = request.getFields().stream().filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        Set missedIds = RelationUtils.findMissedNodes((RelationGraph)relationGraph, entityIds, (UUID)request.getRootEntityId());
        if (!missedIds.isEmpty()) {
            for (UUID missedId : missedIds) {
                ViewField missedField = new ViewField();
                missedField.setId(TimeStampUUIDGenerator.generateId());
                missedField.setMissedRelationField(true);
                missedField.setBusinessEntityId(missedId);
                missedField.setLabel(relationGraph.getNodeById(missedId).getEntityName());
                request.getFields().add(missedField);
                log.debug("Add missed entity {} {}", (Object)missedId, (Object)relationGraph.getNodeById(missedId).getEntityName());
            }
        }
    }

    private void validateRequest(ViewRequest request, List<BusinessEntity> allEntities) {
        ArrayList fieldIds = Lists.newArrayList();
        fieldIds.addAll(request.getFields().stream().filter(f -> !f.isVirtualDateField()).filter(f -> !f.isStateField()).filter(f -> !f.isCalculatedField() || !f.isBatchCalculation()).map(ViewField::getEntityFieldId).collect(Collectors.toSet()));
        Set knownFieldIds = allEntities.stream().flatMap(be -> be.getFields().stream()).map(BusinessEntityField::getId).collect(Collectors.toSet());
        for (UUID fieldId : fieldIds) {
            if (knownFieldIds.contains(fieldId)) continue;
            ViewField viewField = request.getFields().stream().filter(f -> f.getEntityFieldId().equals(fieldId)).findAny().get();
            throw new IllegalStateException("View Field use unknown field: " + viewField);
        }
    }

    private void checkNeedTruncateRequestTimeRanges(ViewRequest viewRequest) {
        if (viewRequest.getCachingDateAggregationType() == null) {
            return;
        }
        long prevStartTs = viewRequest.getStartTs();
        long prevEndTs = viewRequest.getEndTs() + 1000L;
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)viewRequest.getCachingDateAggregationType());
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(prevStartTs), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(prevEndTs), ZoneId.systemDefault());
        ZonedDateTime truncatedStartDate = DateAggregationType.extendedTruncateTo((ZonedDateTime)startDate, (TemporalUnit)timeUnit);
        ZonedDateTime truncatedEndDate = DateAggregationType.extendedTruncateTo((ZonedDateTime)endDate, (TemporalUnit)timeUnit);
        boolean predictionIsEnabled = viewRequest.getFields().stream().anyMatch(ViewField::isPredictionEnabled);
        boolean truncationIsNeeded = false;
        truncationIsNeeded |= viewRequest.isUsePersistedCacheTelemetry();
        boolean truncationIsPossible = true;
        if ((truncationIsNeeded |= predictionIsEnabled) && (truncationIsPossible &= truncatedStartDate.isBefore(truncatedEndDate))) {
            long newStartTs = truncatedStartDate.toEpochSecond() * 1000L;
            long newEndTs = truncatedEndDate.toEpochSecond() * 1000L - 1L;
            log.debug("View request time ranges truncation: start = (before: {}, after: {}), end = (before: {}, after: {})", new Object[]{ZonedDateTime.ofInstant(Instant.ofEpochMilli(viewRequest.getStartTs()), ZoneId.systemDefault()), ZonedDateTime.ofInstant(Instant.ofEpochMilli(newStartTs), ZoneId.systemDefault()), ZonedDateTime.ofInstant(Instant.ofEpochMilli(viewRequest.getEndTs()), ZoneId.systemDefault()), ZonedDateTime.ofInstant(Instant.ofEpochMilli(newEndTs), ZoneId.systemDefault())});
            viewRequest.setStartTs(newStartTs);
            viewRequest.setEndTs(newEndTs);
        }
    }

    private boolean finishRowProcessing(boolean modified, List<AggregatedValue> values, ViewField field, Row row, RowBuilder rowBuilder, ViewRequest request, ViewContext context) {
        int originalSize = values.size();
        this.filterService.loadFilterOptions(context, request);
        values = this.filterService.filterAggregatedValue(values, field, request, context);
        if (CollectionUtils.isEmpty((Collection)values) && originalSize == 0) {
            throw new IllegalStateException("Aggregated Values are not defined");
        }
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            if (field.isHidden()) {
                Set hiddenItems = values.stream().flatMap(v -> v.getFieldValue().getItems().stream()).collect(Collectors.toSet());
                Set innerValues = values.stream().map(v -> v.getFieldValue().getInnerValue()).collect(Collectors.toSet());
                FieldType type = ((BusinessEntityField)context.getBusinessEntityFieldMap().get(field.getEntityFieldId())).getType();
                row.markAsProcessed(field, new AggregatedValue(new FieldValue(hiddenItems, type, innerValues), Flux.fromIterable(hiddenItems)));
                row.getHiddenValues().put(field.getEntityFieldId(), values);
            } else {
                Iterator iterator = values.iterator();
                AggregatedValue firstValue = (AggregatedValue)iterator.next();
                while (iterator.hasNext()) {
                    Row copy = row.copy();
                    AggregatedValue nextValue = (AggregatedValue)iterator.next();
                    copy.markAsProcessed(field, nextValue);
                    if (field.getEntityFieldId() != null) {
                        copy.getHiddenValues().put(field.getEntityFieldId(), Collections.singletonList(nextValue));
                    }
                    rowBuilder.addRow(copy);
                }
                if (field.getEntityFieldId() != null) {
                    row.getHiddenValues().put(field.getEntityFieldId(), Collections.singletonList(firstValue));
                }
                row.markAsProcessed(field, firstValue);
            }
        } else {
            if (field.getEntityFieldId() != null) {
                row.getHiddenValues().put(field.getEntityFieldId(), values);
            }
            row.markAsProcessed(field, new AggregatedValue(new FieldValue(Collections.emptySet(), FieldType.BLANK, null), Flux.empty()));
        }
        return modified;
    }
}

