/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.service.provider.TbRestDataSource;

@Component
public class CustomerCache {
    private static final Logger log = LoggerFactory.getLogger(CustomerCache.class);
    private static final long refreshIntervalMs = TimeUnit.HOURS.toMillis(24L);
    @Autowired
    private TbRestDataSource apiClient;
    @Autowired
    private TokenExtractor tokenExtractor;
    private volatile long lastUpdateTs;
    private volatile Map<UUID, String> customerDictionary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, String> getCustomerDictionary(String jwtToken) {
        if (this.refreshRequired()) {
            CustomerCache customerCache = this;
            synchronized (customerCache) {
                if (this.refreshRequired()) {
                    this.initDictionary(jwtToken);
                }
            }
        }
        return this.customerDictionary;
    }

    private void initDictionary(String jwtToken) {
        JwtSecUser secUser = this.tokenExtractor.getJwtSecUser(jwtToken);
        Map<UUID, String> dictionary = this.apiClient.loadCustomers(null, null, null, secUser, jwtToken).stream().collect(Collectors.toMap(IdBased::getUuidId, Customer::getName));
        dictionary.put(EntityId.NULL_UUID, "None");
        this.lastUpdateTs = System.currentTimeMillis();
        this.customerDictionary = dictionary;
        log.info("Customer Dictionary loaded {}", (Object)this.customerDictionary.size());
    }

    private boolean refreshRequired() {
        return this.customerDictionary == null || System.currentTimeMillis() - this.lastUpdateTs > refreshIntervalMs;
    }
}

