/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.service.view.CachedViewService;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CachedViewService {
    private static final Logger log = LoggerFactory.getLogger(CachedViewService.class);
    @Value(value="${cache.report.enabled}")
    private boolean cachingEnabled;
    @Value(value="${caffeine.specs.viewReports.maxSize}")
    private int maxCacheSize;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private TokenExtractor tokenExtractor;
    @Value(value="${cache.report.sessionDurationInMinutes}")
    private long sessionDurationInMinutes;
    private static final String viewReportsCacheName = "viewReports";
    private static final ObjectMapper mapper = new ObjectMapper();

    public void cacheReport(ViewConfig config, TenantId tenantId, String jwtToken, ViewReport viewReport) {
        if (!this.cachingEnabled) {
            log.trace("Report caching is disabled, skipping.");
            return;
        }
        if (BooleanUtils.isFalse((Boolean)config.getCacheSettings().getUseReportCache())) {
            log.trace("Report caching is disabled for current config, skipping.");
            return;
        }
        ConfigKey configKey = this.buildRequestKey(config, tenantId, jwtToken);
        if (configKey == null) {
            return;
        }
        long reportSize = this.getReportSize(viewReport);
        if (reportSize > (long)this.maxCacheSize) {
            log.info("Skip Report save in cache. Size is too big {}", (Object)reportSize);
            return;
        }
        Cache reportCache = this.cacheManager.getCache("viewReports");
        if (reportCache == null) {
            throw new IllegalStateException("Report Cache is not initialized.");
        }
        reportCache.put((Object)configKey, (Object)viewReport);
        log.info("Report saved in cache.");
    }

    public Optional<ViewReport> getFromCache(ViewConfig config, TenantId tenantId, String jwtToken) {
        if (!this.cachingEnabled) {
            log.trace("Report caching is disabled, skipping.");
            return Optional.empty();
        }
        if (BooleanUtils.isFalse((Boolean)config.getCacheSettings().getUseReportCache())) {
            log.trace("Report caching is disabled for current config, skipping.");
            return Optional.empty();
        }
        ConfigKey configKey = this.buildRequestKey(config, tenantId, jwtToken);
        if (configKey == null) {
            return Optional.empty();
        }
        Cache reportCache = this.cacheManager.getCache("viewReports");
        if (reportCache == null) {
            throw new IllegalStateException("Report Cache is not initialized.");
        }
        ViewReport report = (ViewReport)reportCache.get((Object)configKey, ViewReport.class);
        if (report == null) {
            log.debug("Report not found in cache.");
        }
        return Optional.ofNullable(report);
    }

    private ConfigKey buildRequestKey(ViewConfig config, TenantId tenantId, String jwtToken) {
        try {
            long cacheTimeMs = System.currentTimeMillis();
            ViewConfig copyConfig = (ViewConfig)mapper.treeToValue((TreeNode)mapper.valueToTree((Object)config), ViewConfig.class);
            this.absentUselessData(copyConfig);
            long truncatedCacheTimeMs = this.handleTimeRangeSettings(copyConfig, cacheTimeMs);
            JwtSecUser secUser = this.tokenExtractor.getJwtSecUser(jwtToken);
            UUID customerId = secUser.getCustomerId();
            UUID userId = secUser.getUserId();
            ConfigKey configKey = ConfigKey.builder().tenantId(tenantId).customerId(customerId).userId(userId).config(copyConfig).truncatedCacheTime(truncatedCacheTimeMs).build();
            return configKey;
        }
        catch (Exception ex) {
            log.error("Could not create copy of View Config {} for Report Cache", (Object)config, (Object)ex);
            return null;
        }
    }

    private void absentUselessData(ViewConfig config) {
        config.setName(null);
        config.setUpdatedAt(0L);
        ArrayList allFields = new ArrayList();
        allFields.addAll(config.getxAxis());
        allFields.addAll(config.getyAxis());
        allFields.addAll(config.getSeries());
        allFields.addAll(config.getHiddenFields());
        allFields.forEach(viewField -> {
            viewField.setLabel(null);
            if (viewField.isStateField() || viewField.isCalculatedField()) {
                viewField.setBusinessEntityId(null);
                viewField.setParsedCondition(null);
                viewField.setConditionFieldIds(null);
            }
            if (!viewField.isPredictionEnabled()) {
                viewField.setPredictionRangeSec(0);
                viewField.setPredictionMethod(null);
            }
        });
        config.getRuntimeFilters().forEach(filterField -> filterField.setName(null));
        ObjectMapper mapper = new ObjectMapper();
        Set missedGraphEntities = config.getAdditionalEntityIds();
        ArrayNode missedGraphEntitiesNode = (ArrayNode)mapper.valueToTree((Object)missedGraphEntities);
        ObjectNode settingsNode = mapper.createObjectNode();
        settingsNode.putArray("missedGraphEntities").addAll(missedGraphEntitiesNode);
        config.setSettings((JsonNode)settingsNode);
    }

    private long handleTimeRangeSettings(ViewConfig config, long cacheTimeTs) {
        boolean isRelative;
        long maxSessionTime = TimeUnit.MINUTES.toMillis(this.sessionDurationInMinutes);
        DatePickerConfig picker = config.getDatePickerConfig();
        DatePickerConfigSelectType type = picker.getSelectedType();
        boolean bl = isRelative = type != null && "relative".equals(type.getValue());
        if (isRelative) {
            picker.setStartTs(0L);
            picker.setEndTs(0L);
            return cacheTimeTs / maxSessionTime * maxSessionTime;
        }
        picker.setSelectedType(null);
        picker.setSelectedUnit(null);
        picker.setRelativeUnit(null);
        picker.setRelativeLastAmount(0);
        return 0L;
    }

    private int getReportSize(ViewReport report) {
        int size = 0;
        if (CollectionUtils.isNotEmpty((Collection)report.getRows())) {
            size += report.getRows().size();
        }
        if (CollectionUtils.isNotEmpty((Collection)report.getStates())) {
            size += report.getStates().size();
        }
        if (CollectionUtils.isNotEmpty((Collection)report.getTimeEvents())) {
            size += report.getTimeEvents().size();
        }
        if (CollectionUtils.isNotEmpty((Collection)report.getFilterOptions())) {
            for (FieldFilterOption filterOption : report.getFilterOptions()) {
                if (!CollectionUtils.isNotEmpty((Collection)filterOption.getOptions())) continue;
                size += filterOption.getOptions().size();
            }
        }
        return size;
    }
}

