/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.stats;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.stats.Stats;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;

@Component
public class StatsCollector {
    private static final Logger log = LoggerFactory.getLogger(StatsCollector.class);
    private List<Stats> requestsDetailedStats = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;

    @PostConstruct
    public void init() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(() -> this.logStats("Schedule: "), 1L, 1L, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void tick(String key, long startTs, long endTs, TickType tickType) {
        String threadName = Thread.currentThread().getName();
        Stats stats = new Stats(key, threadName, startTs, endTs);
        this.requestsDetailedStats.add(stats);
        switch (1.$SwitchMap$org$thingsboard$trendz$service$stats$TickType[tickType.ordinal()]) {
            case 1: {
                this.logConcurrentDistribution(this.requestsDetailedStats, stats);
                this.requestsDetailedStats.clear();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Tick type is not supported: " + tickType);
            }
        }
    }

    public void logRequestStats() {
        this.logStats("Request: ");
        this.requestsDetailedStats.clear();
    }

    private void logConcurrentDistribution(List<Stats> childStats, Stats mainStat) {
        childStats.forEach(s -> {
            s.setStartLag(s.getStartTs() - mainStat.getStartTs());
            s.setEndLag(mainStat.getEndTs() - s.getEndTs());
        });
        HashMap keyToDuration = new HashMap();
        log.debug("Main tasks stats {}: {} {} : {}", new Object[]{mainStat.getLabel(), mainStat.getStartTs(), mainStat.getEndTs(), mainStat.getDuration()});
        childStats.stream().map(Stats::getLabel).collect(Collectors.toSet()).forEach(key -> childStats.stream().filter(s -> s.getLabel().equals(key)).sorted((t1, t2) -> {
            int compare = Long.compare(t1.getStartTs(), t2.getStartTs());
            if (compare == 0) {
                return Long.compare(t1.getEndLag(), t2.getEndLag());
            }
            return compare;
        }).forEach(s -> {
            long sumDuration = keyToDuration.computeIfAbsent(s.getLabel(), i -> 0L) + s.getDuration();
            keyToDuration.put(s.getLabel(), sumDuration);
            log.trace("Child task {} : {} - {} - {} - {} : {}", new Object[]{s.getLabel(), s.getStartLag(), s.getStartTs(), s.getEndTs(), s.getEndLag(), s.getDuration()});
        }));
        keyToDuration.keySet().forEach(key -> log.debug("Key {}, duration = {}", key, keyToDuration.get(key)));
    }

    private void logStats(String prefix) {
        Set keys = this.requestsDetailedStats.stream().map(Stats::getLabel).collect(Collectors.toSet());
        for (String key : keys) {
            Set keyStats = this.requestsDetailedStats.stream().filter(stats -> stats.getLabel().equals(key)).collect(Collectors.toSet());
            long duration = keyStats.stream().map(Stats::getDuration).mapToLong(l -> l).sum();
            long count = keyStats.size();
            long avg = duration / count;
            log.info("{} Key {} count {} duration {} avg {} ms", new Object[]{prefix, key, count, duration, avg});
        }
    }
}

