/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.state;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.state.StateCondition;
import org.thingsboard.trendz.service.state.StateConditionService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ItemFieldValueLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;

@Component
public class StateFieldProcessor {
    private static final Logger log = LoggerFactory.getLogger(StateFieldProcessor.class);
    @Autowired
    private StateConditionService stateConditionService;
    @Autowired
    private ItemFieldValueLoader valueLoader;

    public Flux<State> processFieldStates(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        Map paramFields = this.loadValues(viewField.getConditionFieldIds(), item, viewRequest, windowedStreamStore, ctx);
        StateCondition stateCondition = this.buildCondition(viewField, ctx);
        Flux states = this.stateConditionService.getStatesByCondition(paramFields, stateCondition);
        if (viewField.getAggregationType().equals((Object)FieldAggregation.NONE)) {
            states = states.doOnNext(s -> ctx.addState(s, item));
        }
        return states;
    }

    private StateCondition buildCondition(ViewField viewField, ViewContext ctx) {
        Set keys = viewField.getConditionFieldIds().keySet();
        String[] parameterNames = new String[keys.size()];
        Class[] parameterTypes = new Class[keys.size()];
        int i = 0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            parameterNames[i] = key = (String)iterator.next();
            ViewField usedVF = (ViewField)viewField.getConditionFieldIds().get(key);
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(usedVF.getEntityFieldId());
            if (businessEntityField.getType().equals((Object)FieldType.NUMERIC)) {
                parameterTypes[i] = Double.class;
            } else if (businessEntityField.getType().equals((Object)FieldType.STRING)) {
                parameterTypes[i] = String.class;
            } else if (businessEntityField.getType().equals((Object)FieldType.DATE)) {
                parameterTypes[i] = Long.class;
            } else if (businessEntityField.getType().equals((Object)FieldType.BOOLEAN)) {
                parameterTypes[i] = Boolean.class;
            }
            ++i;
        }
        return new StateCondition(viewField.getParsedCondition(), parameterNames, parameterTypes, viewField.getLabel());
    }

    private Map<String, Flux<FieldValue>> loadValues(Map<String, ViewField> paramFields, Item item, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, ViewField> entry : paramFields.entrySet()) {
            BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(entry.getValue().getBusinessEntityId());
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entry.getValue().getEntityFieldId());
            Flux values = this.valueLoader.loadItemFieldValue(item, entry.getValue(), viewRequest, windowedStreamStore, businessEntityField, businessEntity, ctx).filter(v -> v.getTs() > 0L);
            result.put(entry.getKey(), values.collectList().doOnNext(l -> {
                for (FieldValue value : l) {
                    value.getInnerValue();
                }
            }).flatMapIterable(l -> l));
        }
        return result;
    }
}

