/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.state.StateCondition;
import org.thingsboard.trendz.service.state.StateConditionService;
import reactor.core.publisher.Flux;

@Service
public class StateConditionServiceImpl
implements StateConditionService {
    private static final Logger log = LoggerFactory.getLogger(StateConditionServiceImpl.class);
    private static long maxSilenseMs = TimeUnit.DAYS.toMillis(1L);

    public Flux<State> getStatesByCondition(Map<String, Flux<FieldValue>> fieldValues, StateCondition stateCondition) {
        Flux buckets = this.joinFieldsIntoBuckets(fieldValues);
        return this.processStates(buckets, stateCondition);
    }

    private Flux<State> processStates(Flux<Map<String, FieldValue>> fieldValues, StateCondition stateCondition) {
        return fieldValues.collectList().map(buckets -> {
            List rawStates = this.convertToStates(buckets);
            return this.mergeValueStates(rawStates, stateCondition);
        }).flatMapIterable(l -> l);
    }

    private List<State> mergeValueStates(List<Pair<Map<String, FieldValue>, State>> rawStates, StateCondition stateCondition) {
        try {
            ScriptEvaluator evaluator = this.getEvaluator(stateCondition);
            ArrayList mergedStates = Lists.newArrayList();
            State prevState = null;
            for (Pair<Map<String, FieldValue>, State> rawState : rawStates) {
                Map params = (Map)rawState.getLeft();
                State state = (State)rawState.getRight();
                Object stateValue = this.satisfyExpression(evaluator, stateCondition, params);
                if (stateValue instanceof Boolean) {
                    boolean matched = (Boolean)stateValue;
                    if (matched) {
                        stateValue = stateCondition.getStateName();
                    } else {
                        prevState = null;
                        continue;
                    }
                }
                state.setValue(stateValue);
                long tsDelta = state.getStartTs() - (prevState != null ? prevState.getEndTs() : 0L);
                if (prevState != null && prevState.getValue().equals(stateValue) && tsDelta < maxSilenseMs) {
                    prevState.setEndTs(state.getEndTs());
                    continue;
                }
                mergedStates.add(state);
                prevState = state;
            }
            return mergedStates;
        }
        catch (CompileException e) {
            log.error("Expression compilation error!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Pair<Map<String, FieldValue>, State>> convertToStates(List<Map<String, FieldValue>> buckets) {
        AtomicReference<State> previousState = new AtomicReference<State>(new State(null, 0L, 0L));
        ArrayList rawStates = Lists.newArrayList();
        for (Map<String, FieldValue> params : buckets) {
            FieldValue anyValue = params.values().iterator().next();
            long tsDelta = anyValue.getTs() - previousState.get().getEndTs();
            if (tsDelta > maxSilenseMs) {
                previousState.get().setEndTs(previousState.get().getStartTs());
            } else {
                previousState.get().setEndTs(anyValue.getTs());
            }
            State state = new State(anyValue.getInnerValue(), anyValue.getTs(), anyValue.getTs());
            previousState.set(state);
            rawStates.add(Pair.of(params, (Object)state));
        }
        if (!rawStates.isEmpty()) {
            State lastState = (State)((Pair)rawStates.get(rawStates.size() - 1)).getRight();
            long lastStateStartTs = lastState.getStartTs();
            lastState.setEndTs(lastStateStartTs);
        }
        return rawStates;
    }

    private Flux<Map<String, FieldValue>> joinFieldsIntoBuckets(Map<String, Flux<FieldValue>> fieldValues) {
        Flux buckets = Flux.empty();
        for (Map.Entry<String, Flux<FieldValue>> entry : fieldValues.entrySet()) {
            buckets = buckets.concatWith((Publisher)entry.getValue().doOnNext(fv -> fv.setKeyName((String)entry.getKey())).collectList());
        }
        return buckets.collectList().map(arg_0 -> this.groupBuckets(arg_0)).flatMapIterable(l -> l);
    }

    private List<Map<String, FieldValue>> groupBuckets(List<List<FieldValue>> allValues) {
        TreeMap tsMap = Maps.newTreeMap();
        for (List<FieldValue> values : allValues) {
            for (FieldValue fv : values) {
                List bucketValues = tsMap.computeIfAbsent(fv.getTs(), ts -> new ArrayList());
                bucketValues.add(fv);
            }
        }
        ArrayList buckets = Lists.newArrayList();
        for (Map.Entry entry : tsMap.entrySet()) {
            HashMap<String, FieldValue> bucket = new HashMap<String, FieldValue>();
            for (FieldValue fieldValue : (List)entry.getValue()) {
                bucket.put(fieldValue.getKeyName(), fieldValue);
            }
            buckets.add(bucket);
        }
        return buckets;
    }

    private ScriptEvaluator getEvaluator(StateCondition stateCondition) throws CompileException {
        ScriptEvaluator evaluator = new ScriptEvaluator();
        evaluator.setParameters(stateCondition.parameterNames, stateCondition.parameterTypes);
        evaluator.setReturnType(Object.class);
        evaluator.cook(stateCondition.expression);
        return evaluator;
    }

    private Object satisfyExpression(ScriptEvaluator evaluator, StateCondition stateCondition, Map<String, FieldValue> values) {
        try {
            Object[] params = new Object[stateCondition.parameterNames.length];
            int i = 0;
            for (String parameterName : stateCondition.parameterNames) {
                if (values.get(parameterName) == null || values.get(parameterName).getInnerValue() == null) {
                    return "other";
                }
                params[i] = values.get(parameterName).getInnerValue();
                ++i;
            }
            return evaluator.evaluate(params);
        }
        catch (InvocationTargetException e) {
            log.error("Expression evaluation error! {}", (Object)e.getMessage());
            return "other";
        }
    }
}

