/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.state;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Component
public class StateConditionParser {
    private static final Logger log = LoggerFactory.getLogger(StateConditionParser.class);
    @Autowired
    private BusinessEntityService businessEntityService;

    public void parse(ViewRequest request, TenantId tenantId) {
        ViewField stateField = null;
        ViewField stateFieldUniq = null;
        Map fieldKeys = this.getFieldKeys(tenantId);
        for (ViewField viewField : request.getFields()) {
            if (!viewField.isStateField() && (!viewField.isCalculatedField() || !viewField.isBatchCalculation())) continue;
            viewField.setConditionFieldIds((Map)Maps.newHashMap());
            if (viewField.getAggregationType() != FieldAggregation.UNIQ) {
                String rawFunction = viewField.isStateField() ? viewField.getStateCondition() : viewField.getCalcFunction();
                viewField.setParsedCondition(rawFunction);
                for (Map.Entry entry : fieldKeys.entrySet()) {
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "sum", FieldAggregation.SUM);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "avg", FieldAggregation.AVG);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "min", FieldAggregation.MIN);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "max", FieldAggregation.MAX);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "latest", FieldAggregation.LATEST);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "count", FieldAggregation.COUNT);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "delta", FieldAggregation.DELTA);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "none", FieldAggregation.NONE);
                    this.processKey(viewField, (String)entry.getKey(), (BusinessEntityField)entry.getValue(), "uniq", FieldAggregation.UNIQ);
                }
                this.validateCondition(viewField);
                stateField = viewField;
                continue;
            }
            stateFieldUniq = viewField;
        }
        if (stateFieldUniq != null && stateField != null) {
            stateFieldUniq.setBusinessEntityId(stateField.getBusinessEntityId());
        }
        Set existingIds = request.getFields().stream().map(ViewField::getEntityFieldId).collect(Collectors.toSet());
        List newFields = request.getFields().stream().filter(f -> f.isStateField() || f.isCalculatedField() && f.isBatchCalculation()).flatMap(f -> f.getConditionFieldIds().values().stream()).filter(f -> !existingIds.contains(f.getEntityFieldId())).map(f -> {
            existingIds.add(f.getId());
            return f;
        }).collect(Collectors.toList());
        request.getFields().addAll(newFields);
    }

    private void validateCondition(ViewField viewField) {
        Set affectedBusinessEntities = viewField.getConditionFieldIds().values().stream().map(ViewField::getBusinessEntityId).collect(Collectors.toSet());
        viewField.setBusinessEntityId((UUID)affectedBusinessEntities.iterator().next());
    }

    private void processKey(ViewField conditionField, String key, BusinessEntityField beField, String func, FieldAggregation aggregation) {
        String pattern = func + "(" + key + ")";
        if (conditionField.getParsedCondition().contains(pattern)) {
            ViewField viewField = new ViewField();
            viewField.setId(TimeStampUUIDGenerator.generateId());
            viewField.setLabel(beField.getName());
            viewField.setBusinessEntityId(beField.getBusinessEntityId());
            viewField.setEntityFieldId(beField.getId());
            viewField.setAggregationType(aggregation);
            viewField.setHidden(true);
            viewField.setForStateCondition(true);
            viewField.setVirtualDateField(false);
            String varName = aggregation + "_" + key.replaceAll("\\.", "_");
            String parsedCondition = StringUtils.replace((String)conditionField.getParsedCondition(), (String)pattern, (String)varName);
            conditionField.setParsedCondition(parsedCondition);
            conditionField.getConditionFieldIds().put(varName, viewField);
        }
    }

    private Map<String, BusinessEntityField> getFieldKeys(TenantId tenantId) {
        HashMap<UUID, BusinessEntity> businessEntityMap = new HashMap<UUID, BusinessEntity>();
        HashMap<UUID, BusinessEntityField> businessEntityFieldMap = new HashMap<UUID, BusinessEntityField>();
        List allEntities = this.businessEntityService.getAllEntities(tenantId);
        for (BusinessEntity entity : allEntities) {
            businessEntityMap.put(entity.getId(), entity);
            for (BusinessEntityField field : entity.getFields()) {
                businessEntityFieldMap.put(field.getId(), field);
            }
        }
        HashMap keys = Maps.newHashMap();
        for (BusinessEntityField beField : businessEntityFieldMap.values()) {
            BusinessEntity businessEntity = (BusinessEntity)businessEntityMap.get(beField.getBusinessEntityId());
            String key = businessEntity.getName() + "." + beField.getName();
            keys.put(key, beField);
        }
        return keys;
    }
}

