/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.simple;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.view.ViewService;
import org.thingsboard.trendz.service.view.ViewTaskCache;

@Service
public class SimpleDataService {
    private static final Logger log = LoggerFactory.getLogger(SimpleDataService.class);
    @Autowired
    private ViewConfigService viewConfigService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private ViewTaskCache viewTaskCache;

    public ViewConfig getViewConfigByReference(ViewConfigReference reference, TenantId tenantId) {
        ViewConfig viewConfig;
        try {
            viewConfig = this.viewConfigService.findConfigById(tenantId, reference.getViewConfigId());
        }
        catch (NullPointerException exception) {
            throw new IllegalArgumentException("Invalid reference: View Config is not found by given ID: " + reference.getViewConfigId());
        }
        if (reference.getRangeStartTs() == null ^ reference.getRangeEndTs() == null) {
            throw new IllegalArgumentException("Invalid reference: 'rangeStartTs' and 'rangeEndTs' must be present or absent together.");
        }
        if (reference.getRangeStartTs() != null && reference.getRangeEndTs() != null) {
            viewConfig.getDatePickerConfig().setSelectedType(null);
            viewConfig.getDatePickerConfig().setStartTs(reference.getRangeStartTs().longValue());
            viewConfig.getDatePickerConfig().setEndTs(reference.getRangeEndTs().longValue());
        }
        if (reference.getFilters() != null) {
            HashMap labelToFilter = new HashMap();
            viewConfig.getRuntimeFilters().forEach(filter -> labelToFilter.put(filter.getName(), filter));
            reference.getFilters().keySet().forEach(label -> {
                RuntimeFilterField filter = (RuntimeFilterField)labelToFilter.get(label);
                HashSet selectedItemNames = Sets.newHashSet((Iterable)((Iterable)reference.getFilters().get(label)));
                filter.setSelection((Set)selectedItemNames);
                filter.setOptions((Set)selectedItemNames);
            });
        }
        return viewConfig;
    }

    public SimpleViewReport getSimplifiedViewReport(ViewConfig viewConfig, ViewReport viewReport) {
        List allNotHiddenFields = viewConfig.getxAxis();
        allNotHiddenFields.addAll(viewConfig.getyAxis());
        allNotHiddenFields.addAll(viewConfig.getSeries());
        HashMap idToFieldLabel = new HashMap();
        allNotHiddenFields.forEach(field -> idToFieldLabel.put(field.getId(), field.getLabel()));
        ArrayList dataTable = new ArrayList();
        for (DataRow row : viewReport.getRows()) {
            HashMap<String, Object> simpleRow = new HashMap<String, Object>();
            for (DataCell cell : row.getCells()) {
                String key = (String)idToFieldLabel.get(cell.getViewFieldId());
                Object value = cell.getData();
                simpleRow.put(key, value);
            }
            dataTable.add(simpleRow);
        }
        return SimpleViewReport.builder().columnLabels(Lists.newArrayList(idToFieldLabel.values())).dataTable(dataTable).build();
    }

    public ViewReport buildViewAndAwait(ViewConfig viewConfig, TenantId tenantId, String jwtToken) {
        ViewTask viewTask = this.viewService.buildViewAsync(viewConfig, tenantId, jwtToken);
        UUID taskId = viewTask.getId();
        try {
            while (!viewTask.isFinished() && !viewTask.isCanceled()) {
                TimeUnit.SECONDS.sleep(1L);
                viewTask = (ViewTask)this.viewTaskCache.getTask(taskId).orElseThrow(IllegalStateException::new);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception was occurred during waiting of view build.", e);
        }
        if (viewTask.isCanceled()) {
            throw new IllegalStateException("Exception was occurred during waiting of view build. Reason: " + viewTask.getCancelReason());
        }
        return viewTask.getResult();
    }
}

