/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.simple;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.simple.BuildViewByReferenceTask;
import org.thingsboard.trendz.domain.simple.SimpleApiTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.service.simple.SimpleApiService;

@Service
public class SimpleApiServiceRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(SimpleApiServiceRateLimiter.class);
    @Autowired
    private SimpleApiService simpleApiService;
    @Value(value="${executors.simpleApiRateLimiter.queueCapacity}")
    private int queueCapacity;
    @Value(value="${executors.simpleApiRateLimiter.threadPoolSize}")
    private int threadPoolSize;
    private BlockingQueue<Runnable> requestQueue;
    private ThreadPoolExecutor threadPool;
    private ListeningExecutorService listeningExecutorService;

    @PostConstruct
    public void initializeService() {
        this.requestQueue = new LinkedBlockingQueue(this.queueCapacity);
        this.threadPool = new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.requestQueue, new ThreadPoolExecutor.AbortPolicy());
        this.threadPool.setRejectedExecutionHandler(this.createRejectedExecutionHandler());
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.threadPool);
    }

    @PreDestroy
    public void disposeService() {
        this.listeningExecutorService.shutdownNow();
    }

    public ListenableFuture<SimpleApiTask> submitTask(SimpleApiTask task) {
        ListenableFuture future = this.listeningExecutorService.submit(() -> {
            try {
                log.info("The task has been started {}", task.getClass());
                if (task instanceof BuildViewByReferenceTask) {
                    return this.processBuildViewTask((BuildViewByReferenceTask)task);
                }
                throw new IllegalArgumentException("Task type is not supported: " + task);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Not valid data are provided: ", e);
            }
            catch (Exception e) {
                throw new Exception("Error during task processing: " + e.getMessage(), e);
            }
        });
        log.info("The task has been submitted {}", task.getClass());
        return future;
    }

    private RejectedExecutionHandler createRejectedExecutionHandler() {
        return (runnable, executor) -> {
            Future future = (Future)((Object)runnable);
            future.cancel(true);
            log.warn("Execution of given runnable is rejected");
        };
    }

    private BuildViewByReferenceTask processBuildViewTask(BuildViewByReferenceTask buildTask) {
        ViewConfigReference reference = buildTask.getReference();
        TenantId tenantId = buildTask.getTenantId();
        String jwtToken = buildTask.getJwtToken();
        SimpleViewReport report = this.simpleApiService.buildViewByReference(reference, tenantId, jwtToken);
        buildTask.setResult(report);
        return buildTask;
    }
}

