/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.simple;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.service.simple.SimpleDataService;

@Service
public class SimpleApiService {
    private static final Logger log = LoggerFactory.getLogger(SimpleApiService.class);
    @Autowired
    private SimpleDataService simpleDataService;

    public SimpleViewReport buildViewByReference(ViewConfigReference viewConfigReference, TenantId tenantId, String jwtToken) {
        ViewConfig viewConfig = this.simpleDataService.getViewConfigByReference(viewConfigReference, tenantId);
        ViewReport viewReport = this.simpleDataService.buildViewAndAwait(viewConfig, tenantId, jwtToken);
        SimpleViewReport simpleViewReport = this.simpleDataService.getSimplifiedViewReport(viewConfig, viewReport);
        return simpleViewReport;
    }
}

