/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.service.script.ScriptStats;

@Component
public class NashornJsService {
    private static final Logger log = LoggerFactory.getLogger(NashornJsService.class);
    private ScriptEngine engine;
    private ScheduledExecutorService monitorExecutorService;
    private Map<UUID, String> scriptIdToNameMap = new ConcurrentHashMap();
    private Map<String, UUID> bodyToScriptId = new ConcurrentHashMap();
    private volatile Map<UUID, ScriptStats> scriptStatistic = new ConcurrentHashMap();
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong duration = new AtomicLong();

    @PostConstruct
    public void init() {
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        this.engine = factory.getScriptEngine(new String[]{"--no-java"});
        this.monitorExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.monitorExecutorService.scheduleAtFixedRate(() -> this.clearScripts(), 1L, 1L, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void stop() {
        if (this.monitorExecutorService != null) {
            this.monitorExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String scriptBody, List<String> argNames, Object[] args) {
        Object object;
        long startTs = System.currentTimeMillis();
        UUID uuid = null;
        try {
            uuid = this.eval(scriptBody, argNames);
            object = this.invokeFunction(uuid, args);
            if (uuid != null) {
                // empty if block
            }
        }
        catch (Throwable throwable) {
            if (uuid != null) {
                // empty if block
            }
            long endTs = System.currentTimeMillis();
            long lDur = this.duration.addAndGet(endTs - startTs);
            long lCount = this.count.incrementAndGet();
            if (lCount % 100L == 0L) {
                log.trace("ScriptEngine Count {} Duration {} Avg {}", new Object[]{lCount, lDur, lDur / lCount});
            }
            throw throwable;
        }
        long endTs = System.currentTimeMillis();
        long lDur = this.duration.addAndGet(endTs - startTs);
        long lCount = this.count.incrementAndGet();
        if (lCount % 100L == 0L) {
            log.trace("ScriptEngine Count {} Duration {} Avg {}", new Object[]{lCount, lDur, lDur / lCount});
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID eval(String scriptBody, List<String> argNames) {
        try {
            UUID scriptId = (UUID)this.bodyToScriptId.get(scriptBody);
            if (scriptId == null) {
                NashornJsService nashornJsService = this;
                synchronized (nashornJsService) {
                    if (this.bodyToScriptId.get(scriptBody) == null) {
                        UUID newScriptId = TimeStampUUIDGenerator.generateId();
                        String functionName = "invokeInternal_" + newScriptId.toString().replace('-', '_');
                        String jsScript = this.generateScript(functionName, scriptBody, argNames);
                        this.engine.eval(jsScript);
                        this.scriptIdToNameMap.put(newScriptId, functionName);
                        this.bodyToScriptId.put(scriptBody, newScriptId);
                        this.scriptStatistic.put(newScriptId, new ScriptStats(newScriptId));
                    }
                }
                return (UUID)this.bodyToScriptId.get(scriptBody);
            }
            return scriptId;
        }
        catch (Exception e) {
            log.error("Failed to compile JS script: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    private Object invokeFunction(UUID scriptId, Object ... args) {
        try {
            this.updateStatistic(scriptId);
            String functionName = (String)this.scriptIdToNameMap.get(scriptId);
            return ((Invocable)((Object)this.engine)).invokeFunction(functionName, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void doRelease(UUID scriptId) {
        String functionName = (String)this.scriptIdToNameMap.get(scriptId);
        if (functionName != null) {
            try {
                this.scriptIdToNameMap.remove(scriptId);
                this.clearScriptBodyMap(scriptId);
                this.engine.eval(functionName + " = undefined;");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String generateScript(String functionName, String scriptBody, List<String> argNames) {
        String strPrefix = "Str";
        String strArgNames = StringUtils.join((Iterable)argNames.stream().map(a -> a + strPrefix).collect(Collectors.toList()), (String)",");
        List<String> parsedArgs = argNames.stream().map(arg -> "    var " + arg + " = JSON.parse(" + arg + strPrefix + "); ").collect(Collectors.toList());
        StringBuilder jsFunction = new StringBuilder("function " + functionName + "(" + strArgNames + ") { \n");
        parsedArgs.forEach(arg -> jsFunction.append((String)arg).append("\n"));
        jsFunction.append("    return JSON.stringify(transformFunction(" + StringUtils.join(argNames, (String)",") + ")); \n");
        jsFunction.append("function transformFunction(" + StringUtils.join(argNames, (String)",") + ") { \n");
        jsFunction.append("\n");
        jsFunction.append(scriptBody);
        jsFunction.append("\n");
        jsFunction.append(" \n} \n}");
        return jsFunction.toString();
    }

    private void updateStatistic(UUID scriptId) {
        ScriptStats stats = (ScriptStats)this.scriptStatistic.get(scriptId);
        if (stats != null) {
            stats.getInvocationCount().incrementAndGet();
            stats.getLastInvocationTs().set(System.currentTimeMillis());
        }
    }

    private void clearScriptBodyMap(UUID scriptId) {
        String body = null;
        for (Map.Entry entry : this.bodyToScriptId.entrySet()) {
            if (!((UUID)entry.getValue()).equals(scriptId)) continue;
            body = (String)entry.getKey();
            break;
        }
        if (body != null) {
            this.bodyToScriptId.remove(body);
        }
    }

    private void clearScripts() {
        ArrayList scriptStats = Lists.newArrayList(this.scriptStatistic.values());
        int beforeClearSize = scriptStats.size();
        long scpritTTL = TimeUnit.HOURS.toMillis(1L);
        if (scriptStats.size() > 100) {
            scpritTTL = TimeUnit.MINUTES.toMillis(2L);
        }
        for (ScriptStats stats : scriptStats) {
            if (System.currentTimeMillis() - stats.getLastInvocationTs().get() <= scpritTTL) continue;
            try {
                this.scriptStatistic.remove(stats.getId());
                this.doRelease(stats.getId());
            }
            catch (Exception ex) {
                log.error("Error while releasing JS function", (Throwable)ex);
            }
        }
        log.debug("compiled JS Scripts before {} , after {}", (Object)beforeClearSize, (Object)this.scriptStatistic.size());
    }
}

