/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.script.FieldDto;
import org.thingsboard.trendz.service.script.NashornJsService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.ItemFieldValueLoader;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;

@Component
public class BatchFieldScriptProcessor {
    private static final Logger log = LoggerFactory.getLogger(BatchFieldScriptProcessor.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private NashornJsService jsService;
    @Autowired
    private ItemFieldValueLoader valueLoader;

    public Flux<FieldValue> process(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, BusinessEntityField entityField, BusinessEntity businessEntity, ViewContext ctx) {
        Map paramFields = this.loadValues(viewField.getConditionFieldIds(), item, viewRequest, windowedStreamStore, ctx);
        Flux buckets = Flux.fromIterable(paramFields.keySet()).flatMap(k -> ((Flux)paramFields.get(k)).doOnNext(fv -> fv.setKeyName(k)).collectList());
        return buckets.collectList().map(all -> {
            HashMap fields = new HashMap();
            all.forEach(l -> l.forEach(f -> {
                if (!fields.containsKey(f.getKeyName())) {
                    fields.put(f.getKeyName(), Lists.newArrayList());
                }
                ((List)fields.get(f.getKeyName())).add(f);
            }));
            fields.values().forEach(l -> l.sort(Comparator.comparingLong(FieldValue::getTs)));
            return fields;
        }).map(fields -> {
            String script = viewField.getParsedCondition();
            ArrayList argNames = Lists.newArrayList(viewField.getConditionFieldIds().keySet());
            return this.executeAndMap(script, (List)argNames, fields);
        }).doOnNext(list -> list.forEach(f -> f.setItems(Collections.singleton(item)))).flatMapIterable(l -> l).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    private List<FieldValue> executeAndMap(String script, List<String> argNames, Map<String, List<FieldValue>> fields) {
        try {
            Object[] args = new Object[argNames.size()];
            for (int i = 0; i < argNames.size(); ++i) {
                String key = argNames.get(i);
                List<FieldValue> values = fields.get(key);
                if (values == null) {
                    args[i] = "[]";
                    continue;
                }
                List collect = values.stream().map(FieldDto::fromField).collect(Collectors.toList());
                args[i] = mapper.writeValueAsString(collect);
            }
            Object object = this.jsService.execute(script, argNames, args);
            return this.mapToValues(object);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not execute calculation function: " + ex.getMessage(), ex);
        }
    }

    private List<FieldValue> mapToValues(Object raw) throws IOException {
        if (raw == null) {
            return Collections.emptyList();
        }
        List values = (List)mapper.readValue(raw.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return values.stream().map(FieldDto::toField).collect(Collectors.toList());
    }

    private Map<String, Flux<FieldValue>> loadValues(Map<String, ViewField> paramFields, Item item, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, ViewField> entry : paramFields.entrySet()) {
            if (this.innerLoadField(entry.getValue(), ctx)) {
                BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(entry.getValue().getBusinessEntityId());
                BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entry.getValue().getEntityFieldId());
                Flux values = this.valueLoader.loadItemFieldValue(item, entry.getValue(), viewRequest, windowedStreamStore, businessEntityField, businessEntity, ctx).filter(v -> v.getTs() > 0L);
                result.put(entry.getKey(), values.collectList().doOnNext(l -> {
                    for (FieldValue value : l) {
                        value.getInnerValue();
                    }
                }).flatMapIterable(l -> l));
                continue;
            }
            FieldValue value = this.getValueFromStore(windowedStreamStore, entry.getValue(), item);
            result.put(entry.getKey(), Flux.fromIterable((Iterable)Lists.newArrayList((Object[])new FieldValue[]{value})));
        }
        return result;
    }

    private boolean innerLoadField(ViewField field, ViewContext ctx) {
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(field.getEntityFieldId());
        return field.isForStateCondition() && entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY;
    }

    private FieldValue getValueFromStore(WindowedStreamStore windowedStreamStore, ViewField viewField, Item item) {
        Row row = windowedStreamStore.getCurrentRow();
        List rowFieldValues = (List)row.getHiddenValues().get(viewField.getEntityFieldId());
        if (rowFieldValues != null) {
            for (AggregatedValue value : rowFieldValues) {
                if (!value.getFieldValue().getItems().stream().anyMatch(i -> i.getId().equals(item.getId()) || i.getId().equals(item.getParentId()))) continue;
                return value.getFieldValue();
            }
        }
        throw new IllegalStateException("Field was not processed yet " + viewField);
    }
}

