/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.scheduledtask.cache;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.domain.runtime.ViewTask;
import org.thingsboard.trendz.security.AuthenticationService;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.cache.TimeRange;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJobExecutor;
import org.thingsboard.trendz.service.scheduledtask.cache.CacheRefreshJob;
import org.thingsboard.trendz.service.view.ViewBuildingService;

@Service
public class CacheRefreshJobExecutor
implements ScheduledJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(CacheRefreshJobExecutor.class);
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private ViewConfigService viewConfigService;
    @Autowired
    private ViewBuildingService viewBuildingService;

    public ScheduledJob goJob(ScheduledJob scheduledJob, TenantId tenantId) throws InterruptedException {
        CacheRefreshJob job = (CacheRefreshJob)scheduledJob;
        long startExecutionTime = System.currentTimeMillis();
        String jwtToken = this.authenticationService.getJwtToken();
        ViewConfig viewConfig = this.viewConfigService.findConfigById(tenantId, job.getViewConfigId());
        DatePickerConfig datePicker = viewConfig.getDatePickerConfig();
        datePicker.setStartTs(job.getLastRefreshTime());
        datePicker.setEndTs(startExecutionTime);
        if (this.isTooShortTimeRange(viewConfig)) {
            return job;
        }
        CacheSettings cacheSettings = viewConfig.getCacheSettings();
        cacheSettings.setUsePersistedCacheTelemetry(true);
        log.info("Scheduled cache refresh, range {}", (Object)new TimeRange(datePicker.getStartTs(), datePicker.getEndTs()));
        ViewTask viewTask = new ViewTask();
        ViewReport report = this.viewBuildingService.buildView(viewConfig, viewTask, tenantId, jwtToken);
        if (viewTask.isCanceled()) {
            throw new IllegalStateException("Building report was failed by reason: " + viewTask.getCancelReason());
        }
        job.setLastRefreshTime(startExecutionTime);
        return job;
    }

    private boolean isTooShortTimeRange(ViewConfig viewConfig) {
        ZonedDateTime truncatedEndDate;
        boolean result;
        DatePickerConfig datePicker = viewConfig.getDatePickerConfig();
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)viewConfig.getCacheSettings().getCachingDateAggregation());
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(datePicker.getStartTs()), ZoneId.systemDefault());
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(datePicker.getEndTs()), ZoneId.systemDefault());
        ZonedDateTime truncatedStartDate = DateAggregationType.extendedTruncateTo((ZonedDateTime)startDate, (TemporalUnit)timeUnit);
        boolean bl = result = timeUnit.between(truncatedStartDate, truncatedEndDate = DateAggregationType.extendedTruncateTo((ZonedDateTime)endDate, (TemporalUnit)timeUnit)) == 0L;
        if (result) {
            log.warn("Cache refresh job will skip the execution because of too small range ({} - {} of timeunit {})", new Object[]{startDate, endDate, timeUnit});
        }
        return result;
    }
}

