/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.scheduledtask;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskDao;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.security.AuthenticationService;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJobCollection;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskContainer;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecordService;
import org.thingsboard.trendz.service.scheduledtask.SchedulingConfig;

@Service
public class ScheduledTaskService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskService.class);
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private ScheduledTaskDao scheduledTaskDao;
    @Autowired
    private ScheduledTaskContainer scheduledTaskContainer;
    @Autowired
    private ScheduledTaskHistoryRecordService scheduledTaskHistoryRecordService;
    private ScheduledExecutorService loggingScheduler;

    @PostConstruct
    public void initializeService() {
        try {
            log.debug("ScheduledTaskService: is starting...");
            TenantId currentTenantId = this.authenticationService.getTenantId();
            List tasks = this.scheduledTaskDao.getAllEnabled(currentTenantId);
            tasks.forEach(task -> this.scheduledTaskContainer.launchTask(task));
            this.loggingScheduler = Executors.newScheduledThreadPool(1);
            this.loggingScheduler.schedule(() -> this.serviceLogging(), 60L, TimeUnit.SECONDS);
            log.debug("ScheduledTaskService: has been started");
        }
        catch (Exception ex) {
            log.error("Skip scheduling service initialization {}", (Object)ex.getMessage());
        }
    }

    @PreDestroy
    public void disposeService() {
        log.debug("ScheduledTaskService: disposing...");
        this.loggingScheduler.shutdownNow();
        this.scheduledTaskContainer.disposeService();
        log.debug("ScheduledTaskService: has been disposed");
    }

    private void serviceLogging() {
        log.info("Count of enabled tasks = {}", (Object)this.scheduledTaskContainer.getEnabledTaskIdSet().size());
        if (log.isDebugEnabled()) {
            for (ScheduledTask task : this.getAllEnabledTasks()) {
                log.debug("Task: id = {}, scheduling config = {}, jobs = {} ", new Object[]{task.getId(), task.getSchedulingConfig(), task.getScheduledJobCollection()});
            }
        }
    }

    public List<ScheduledTask> getAllTasks() {
        TenantId currentTenantId = this.authenticationService.getTenantId();
        return this.scheduledTaskDao.getAll(currentTenantId);
    }

    public List<ScheduledTask> getAllEnabledTasks() {
        TenantId currentTenantId = this.authenticationService.getTenantId();
        return this.scheduledTaskDao.getAllEnabled(currentTenantId);
    }

    public ScheduledTask getTaskById(UUID id) {
        return this.scheduledTaskDao.getById(id);
    }

    public ScheduledTask createTask(SchedulingConfig config, List<ScheduledJob> jobList, boolean launch) {
        TenantId currentTenantId = this.authenticationService.getTenantId();
        ScheduledTask task = ScheduledTask.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(currentTenantId).enabled(launch).schedulingConfig(new SchedulingConfig(config)).scheduledJobCollection(new ScheduledJobCollection((List)Lists.newArrayList(jobList))).build();
        task.getScheduledJobCollection().getScheduledJobs().forEach(job -> job.setId(TimeStampUUIDGenerator.generateId()));
        if (launch) {
            this.scheduledTaskContainer.launchTask(task);
        }
        this.scheduledTaskDao.save(task);
        return task;
    }

    public ScheduledTask updateTask(ScheduledTask task) {
        ScheduledTask saved = this.scheduledTaskDao.getById(task.getId());
        if (saved == null) {
            throw new IllegalArgumentException("Task doesn't exist, it can't be updated");
        }
        ScheduledFuture future = this.scheduledTaskContainer.getTaskScheduledFuture(task.getId());
        if (future != null) {
            this.scheduledTaskContainer.terminateTask(task.getId());
        }
        if (task.isEnabled()) {
            this.scheduledTaskContainer.launchTask(task);
        }
        return this.scheduledTaskDao.save(task);
    }

    public void deleteTask(UUID taskId) {
        log.debug("ScheduledTaskService: deleting scheduled task, ID: {}", (Object)taskId);
        ScheduledFuture future = this.scheduledTaskContainer.getTaskScheduledFuture(taskId);
        if (future != null) {
            this.scheduledTaskContainer.terminateTask(taskId);
        }
        this.scheduledTaskDao.remove(taskId);
        this.scheduledTaskHistoryRecordService.removeHistoryRecordsForScheduledTask(taskId);
        log.debug("ScheduledTaskService: scheduled task has been deleted.");
    }

    public void deleteAllTasks() {
        TenantId currentTenantId = this.authenticationService.getTenantId();
        List tasks = this.getAllTasks();
        for (ScheduledTask task : tasks) {
            ScheduledFuture future = this.scheduledTaskContainer.getTaskScheduledFuture(task.getId());
            if (future == null) continue;
            this.scheduledTaskContainer.terminateTask(task.getId());
        }
        this.scheduledTaskDao.removeAll(currentTenantId);
    }
}

