/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.scheduledtask;

import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskHistoryRecordDao;
import org.thingsboard.trendz.dao.sql.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecord;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryStatus;

@Service
public class ScheduledTaskHistoryRecordService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskHistoryRecordService.class);
    @Autowired
    private ScheduledTaskHistoryRecordDao scheduledTaskHistoryRecordDao;
    @Autowired
    private ViewConfigService viewConfigService;

    public ScheduledTaskHistoryRecord createHistoryRecord(ScheduledTask task) {
        ScheduledTaskHistoryRecord historyRecord = ScheduledTaskHistoryRecord.builder().id(TimeStampUUIDGenerator.generateId()).scheduledTaskId(task.getId()).recordTimestamp(System.currentTimeMillis()).status(ScheduledTaskHistoryStatus.IN_PROGRESS).build();
        return this.scheduledTaskHistoryRecordDao.saveRecord(historyRecord);
    }

    public void updateHistoryRecord(ScheduledTaskHistoryRecord historyRecord) {
        if (historyRecord.getId() == null) {
            throw new IllegalArgumentException("Record doesn't have ID therefore it can't be updated");
        }
        this.scheduledTaskHistoryRecordDao.saveRecord(historyRecord);
        log.debug("History record has been saved: {}", (Object)historyRecord);
    }

    public List<ScheduledTaskHistoryRecord> getHistoryRecordsForScheduledTask(UUID taskId) {
        return this.scheduledTaskHistoryRecordDao.getAllRecordsForScheduledTask(taskId);
    }

    public void removeHistoryRecordsForScheduledTask(UUID taskId) {
        this.scheduledTaskHistoryRecordDao.removeAllRecordsForScheduledTask(taskId);
    }

    public List<ScheduledTaskHistoryRecord> getHistoryRecordsForViewConfig(TenantId tenantId, UUID configId) {
        ViewConfig config = this.viewConfigService.findConfigById(tenantId, configId);
        UUID taskId = config.getCacheSettings().getTaskId();
        return this.getHistoryRecordsForScheduledTask(taskId);
    }
}

