/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.scheduledtask;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.scheduledtask.ScheduledTaskDao;
import org.thingsboard.trendz.service.scheduledtask.ScheduledJob;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecord;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryRecordService;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskHistoryStatus;
import org.thingsboard.trendz.service.scheduledtask.cache.CacheRefreshJob;
import org.thingsboard.trendz.service.scheduledtask.cache.CacheRefreshJobExecutor;
import org.thingsboard.trendz.service.scheduledtask.logging.LoggingJob;
import org.thingsboard.trendz.service.scheduledtask.logging.LoggingJobExecutor;

@Service
public class ScheduledTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskExecutor.class);
    @Autowired
    private ScheduledTaskDao scheduledTaskDao;
    @Autowired
    private ScheduledTaskHistoryRecordService scheduledTaskHistoryRecordService;
    @Autowired
    private LoggingJobExecutor loggingJobExecutor;
    @Autowired
    private CacheRefreshJobExecutor cacheRefreshJobExecutor;

    public void executeTask(ScheduledTask task) throws Exception {
        ScheduledTaskHistoryRecord historyRecord = this.scheduledTaskHistoryRecordService.createHistoryRecord(task);
        try {
            ArrayList<ScheduledJob> updatedScheduledJob = new ArrayList<ScheduledJob>();
            for (ScheduledJob scheduledJob : task.getScheduledJobCollection().getScheduledJobs()) {
                ScheduledJob currentUpdatedJob;
                if (scheduledJob instanceof LoggingJob) {
                    currentUpdatedJob = this.loggingJobExecutor.goJob(scheduledJob, task.getTenantId());
                } else if (scheduledJob instanceof CacheRefreshJob) {
                    currentUpdatedJob = this.cacheRefreshJobExecutor.goJob(scheduledJob, task.getTenantId());
                } else {
                    throw new NotImplementedException("Processing this scheduled task is not implemented.");
                }
                if (currentUpdatedJob == null) continue;
                updatedScheduledJob.add(currentUpdatedJob);
            }
            task.getScheduledJobCollection().setScheduledJobs(updatedScheduledJob);
            this.scheduledTaskDao.save(task);
            historyRecord.setStatus(ScheduledTaskHistoryStatus.SUCCESSFUL);
            log.debug("Scheduled task was finished successfully");
        }
        catch (Exception e) {
            historyRecord.setStatus(ScheduledTaskHistoryStatus.FAILED);
            historyRecord.setFailureReason(this.getReasonFromException(e));
            log.error("Scheduled task was finished with error:", (Throwable)e);
            throw e;
        }
        finally {
            historyRecord.setDuration(System.currentTimeMillis() - historyRecord.getRecordTimestamp());
            this.scheduledTaskHistoryRecordService.updateHistoryRecord(historyRecord);
        }
    }

    private String getReasonFromException(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        String strStackTrace = Arrays.stream(stackTrace).map(StackTraceElement::toString).reduce((e1, e2) -> e1 + "\n" + e2).orElse("There is no stacktrace");
        String result = e.getMessage() + "\n" + strStackTrace;
        return result.substring(0, Math.min(1000, result.length()));
    }
}

