/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.scheduledtask;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTask;
import org.thingsboard.trendz.service.scheduledtask.ScheduledTaskExecutor;
import org.thingsboard.trendz.service.scheduledtask.SchedulingConfig;

@Service
public class ScheduledTaskContainer {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskContainer.class);
    @Autowired
    private ScheduledTaskExecutor scheduledTaskExecutor;
    @Value(value="${executors.scheduledTaskService}")
    private int treadPoolSize;
    private ScheduledExecutorService scheduler;
    private Map<UUID, ScheduledFuture<?>> taskIdToScheduledFutureMap;

    public ScheduledTaskContainer() {
        this.scheduler = Executors.newScheduledThreadPool(this.treadPoolSize);
        this.taskIdToScheduledFutureMap = new ConcurrentHashMap();
    }

    public void disposeService() {
        this.scheduler.shutdown();
    }

    public Set<UUID> getEnabledTaskIdSet() {
        return this.taskIdToScheduledFutureMap.keySet();
    }

    public ScheduledFuture<?> getTaskScheduledFuture(UUID taskId) {
        return (ScheduledFuture)this.taskIdToScheduledFutureMap.get(taskId);
    }

    public void launchTask(ScheduledTask task) {
        log.debug("ScheduledTaskService: launching task: {}", (Object)task);
        Runnable taskJobRunnable = () -> {
            try {
                log.debug("Scheduled task has been started, id = {}", (Object)task.getId());
                this.scheduledTaskExecutor.executeTask(task);
                log.debug("Scheduled task has been finished, id = {}", (Object)task.getId());
            }
            catch (Exception e) {
                log.error("Scheduled task failed, id = {}", (Object)task.getId(), (Object)e);
            }
        };
        SchedulingConfig schedulingConfig = task.getSchedulingConfig();
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleWithFixedDelay(taskJobRunnable, schedulingConfig.getInitialDelay(), schedulingConfig.getRegularDelay(), schedulingConfig.getDelayTimeUnit());
        this.taskIdToScheduledFutureMap.put(task.getId(), scheduledFuture);
        log.debug("ScheduledTaskService: task has been launched: {}", (Object)task);
    }

    public void terminateTask(UUID taskId) {
        log.debug("ScheduledTaskService: terminating task, ID = {}", (Object)taskId);
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.taskIdToScheduledFutureMap.get(taskId);
        if (scheduledFuture == null) {
            throw new IllegalArgumentException("There is no future with given task ID: " + taskId);
        }
        boolean isCancelled = scheduledFuture.cancel(true);
        if (!isCancelled) {
            log.warn("ScheduledTaskService: Scheduled future of the task is not cancelled, task, ID = {}", (Object)taskId);
        }
        log.debug("ScheduledTaskService: task has been terminated, task ID = {}", (Object)taskId);
    }
}

