/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.ws;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.service.provider.tb3.PageData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.ws.ReactiveWsClient;
import org.thingsboard.trendz.service.provider.ws.domain.EntityDataCmd;
import org.thingsboard.trendz.service.provider.ws.domain.TelemetryPluginCmdsWrapper;
import reactor.core.publisher.Mono;

@Component
public class TbWebsocketClient {
    private static final Logger log = LoggerFactory.getLogger(TbWebsocketClient.class);
    private final AtomicInteger cmdCounter = new AtomicInteger(1);
    private final int wsLimit = 100000;
    @Value(value="${tb.api.url}")
    private String tbApiUrl;
    @Autowired
    private TbFilterQueryBuilder tbFilterQueryBuilder;
    private ReactiveWsClient wsClient;

    @PostConstruct
    public void init() {
    }

    @PreDestroy
    public void shutdown() {
        this.wsClient.close();
    }

    public Mono<PageData<EntityData>> loadEntityDataByQuery(EntityDataQuery entityQuery, String jwtToken) {
        int nextCmdId = this.getNextCmdId();
        EntityDataCmd cmd = new EntityDataCmd(nextCmdId, entityQuery, null, null, null);
        TelemetryPluginCmdsWrapper cmdsWrapper = new TelemetryPluginCmdsWrapper();
        cmdsWrapper.setEntityDataCmds((List)Lists.newArrayList((Object[])new EntityDataCmd[]{cmd}));
        return this.getWsClient(jwtToken).submitCommand(nextCmdId, (Object)cmdsWrapper, jwtToken).map(raw -> raw.getData());
    }

    private int getNextCmdId() {
        this.cmdCounter.compareAndSet(10000, 1);
        return this.cmdCounter.incrementAndGet();
    }

    private ReactiveWsClient getWsClient(String jwtToken) {
        if (this.wsClient != null) {
            if (this.wsClient.isOpen()) {
                return this.wsClient;
            }
            this.wsClient.close();
        }
        TbWebsocketClient tbWebsocketClient = this;
        synchronized (tbWebsocketClient) {
            if (this.wsClient != null) {
                if (this.wsClient.isOpen()) {
                    return this.wsClient;
                }
                this.wsClient.close();
            }
            String wsUrl = this.buildWsUrl();
            try {
                this.wsClient = new ReactiveWsClient(wsUrl, new URI(wsUrl), jwtToken);
                return this.wsClient;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("WS URI not valid");
            }
        }
    }

    private String buildWsUrl() {
        String wsUrl = "";
        String port = StringUtils.substringAfter((String)this.tbApiUrl, (String)":");
        if (this.tbApiUrl.startsWith("https://")) {
            wsUrl = this.tbApiUrl.replace("https://", "wss://");
            if (StringUtils.isBlank((CharSequence)port)) {
                port = "443";
            }
        } else {
            wsUrl = this.tbApiUrl.replace("http://", "ws://");
            if (StringUtils.isBlank((CharSequence)port)) {
                port = "80";
            }
        }
        wsUrl = wsUrl + "/api/ws/plugins/telemetry";
        return wsUrl;
    }
}

