/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.thingsboard.trendz.service.provider.ws.InstallCert;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstallCert {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static SSLSocketFactory getUnsecuredSslFactory() {
        try {
            File file = new File("jssecacerts");
            if (!file.isFile()) {
                char SEP = File.separatorChar;
                File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
                file = new File(dir, "jssecacerts");
                if (!file.isFile()) {
                    file = new File(dir, "cacerts");
                }
            }
            System.out.println("Loading KeyStore " + file + "...");
            FileInputStream in = new FileInputStream(file);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, "changeit".toCharArray());
            ((InputStream)in).close();
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            return context.getSocketFactory();
        }
        catch (Throwable th) {
            throw new IllegalStateException(th);
        }
    }

    public static void main(String[] args) throws Exception {
        int k;
        X509Certificate cert;
        SSLSocket socket;
        File file;
        String host = null;
        int port = -1;
        char[] passphrase = null;
        boolean useProxy = false;
        String proxyHost = null;
        int proxyPort = -1;
        InetSocketAddress proxyAddr = null;
        Socket underlying = null;
        int numArg = 0;
        int nbArgs = args.length;
        boolean invalidArgs = false;
        boolean isQuiet = false;
        while (numArg < nbArgs) {
            String arg;
            if ((arg = args[numArg++]).startsWith("--proxy=")) {
                String proxy = arg.substring("--proxy=".length());
                useProxy = true;
                String[] c = proxy.split(":");
                proxyHost = c[0];
                proxyPort = Integer.parseInt(c[1]);
                continue;
            }
            if (arg.startsWith("--quiet")) {
                isQuiet = true;
                continue;
            }
            if (host == null) {
                String[] c = arg.split(":");
                host = c[0];
                port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
                continue;
            }
            if (passphrase == null) {
                passphrase = arg.toCharArray();
                continue;
            }
            invalidArgs = true;
        }
        if (host == null) {
            invalidArgs = true;
        }
        if (invalidArgs) {
            System.out.println("Usage: java InstallCert [--proxy=proxyHost:proxyPort] host[:port] [passphrase] [--quiet]");
            return;
        }
        if (port == -1) {
            port = 443;
        }
        if (passphrase == null) {
            passphrase = "changeit".toCharArray();
        }
        if (!(file = new File("jssecacerts")).isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        System.out.println("Loading KeyStore " + file + "...");
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        if (useProxy) {
            proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
            underlying = new Socket(new Proxy(Proxy.Type.HTTP, proxyAddr));
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + (useProxy ? " via proxy " + proxyHost + ":" + proxyPort : "") + " ...");
        if (useProxy) {
            underlying.connect(new InetSocketAddress(host, port));
            socket = (SSLSocket)factory.createSocket(underlying, host, port, true);
        } else {
            socket = (SSLSocket)factory.createSocket(host, port);
        }
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
        }
        catch (SSLException e) {
            System.out.println();
            e.printStackTrace(System.out);
        }
        X509Certificate[] chain = SavingTrustManager.access$000((SavingTrustManager)tm);
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < chain.length; ++i) {
            cert = chain[i];
            System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
            System.out.println("   Issuer  " + cert.getIssuerDN());
            sha1.update(cert.getEncoded());
            System.out.println("   sha1    " + InstallCert.toHexString((byte[])sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("   md5     " + InstallCert.toHexString((byte[])md5.digest()));
            System.out.println();
        }
        if (isQuiet) {
            System.out.println("Adding first certificate to trusted keystore");
            k = 0;
        } else {
            System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
            String line = reader.readLine().trim();
            try {
                k = line.length() == 0 ? 0 : Integer.parseInt(line) - 1;
            }
            catch (NumberFormatException e) {
                System.out.println("KeyStore not changed");
                return;
            }
        }
        cert = chain[k];
        String alias = host + "-" + (k + 1);
        ks.setCertificateEntry(alias, cert);
        FileOutputStream out = new FileOutputStream("jssecacerts");
        ks.store(out, passphrase);
        ((OutputStream)out).close();
        System.out.println();
        System.out.println(cert);
        System.out.println();
        System.out.println("Added certificate to keystore 'jssecacerts' using alias '" + alias + "'");
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }
}

