/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.EntityTypeFilter;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.AssetTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.BooleanFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.ComplexFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityNameFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.FilterPredicateValue;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.KeyFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.KeyFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.NumericFilterPredicate;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.RelationsQueryFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.SingleEntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.StringFilterPredicate;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Component
public class TbFilterQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(TbFilterQueryBuilder.class);

    public EntityDataQuery buildFilterQuery(EntityType entityType, String type, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, int pageSize) {
        EntityFilter entityFilter = this.getEntityFilter(entityType, type);
        List keyFilters = this.buildKeyFilters(businessEntity, request, ctx);
        List entityFields = this.getEntityKeys(businessEntity, request, ctx);
        List latestValues = this.getLatestKeys(businessEntity, request, ctx);
        EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
        EntityDataPageLink pageLink = new EntityDataPageLink(pageSize, 0, null, sortOrder);
        EntityDataQuery query = new EntityDataQuery(entityFilter, pageLink, entityFields, latestValues, keyFilters);
        return query;
    }

    public EntityDataQuery buildSingleEntityQuery(EntityType entityType, UUID entityId) {
        SingleEntityFilter entityFilter = new SingleEntityFilter();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
            case 1: {
                entityFilter.setSingleEntity((EntityId)new AssetId(entityId));
                break;
            }
            case 2: {
                entityFilter.setSingleEntity((EntityId)new DeviceId(entityId));
                break;
            }
            default: {
                throw new IllegalStateException("Entity type not supported for WS query filter: " + entityType);
            }
        }
        List keyFilters = Collections.emptyList();
        List<EntityKey> entityFields = Collections.singletonList(new EntityKey(EntityKeyType.ENTITY_FIELD, "name"));
        List latestValues = Collections.emptyList();
        EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
        EntityDataPageLink pageLink = new EntityDataPageLink(10, 0, null, sortOrder);
        return new EntityDataQuery((EntityFilter)entityFilter, pageLink, entityFields, latestValues, keyFilters);
    }

    public EntityDataQuery buildRelationQuery(EntityId entityId, EntitySearchDirection direction, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String relationType, int pageSize) {
        EntityTypeFilter relTypefitler = new EntityTypeFilter(relationType, Collections.emptyList());
        RelationsQueryFilter entityFilter = new RelationsQueryFilter();
        entityFilter.setDirection(direction);
        entityFilter.setFetchLastLevelOnly(false);
        entityFilter.setFilters((List)Lists.newArrayList((Object[])new EntityTypeFilter[]{relTypefitler}));
        entityFilter.setMaxLevel(1);
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                entityFilter.setRootEntity(entityId);
                break;
            }
            default: {
                throw new IllegalStateException("Entity type not supported for WS query filter: " + entityId);
            }
        }
        List keyFilters = this.buildKeyFilters(businessEntity, request, ctx);
        List entityFields = this.getEntityKeys(businessEntity, request, ctx);
        List latestValues = this.getLatestKeys(businessEntity, request, ctx);
        EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
        EntityDataPageLink pageLink = new EntityDataPageLink(pageSize, 0, null, sortOrder);
        return new EntityDataQuery((EntityFilter)entityFilter, pageLink, entityFields, latestValues, keyFilters);
    }

    private List<KeyFilter> buildKeyFilters(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList keyFilters = Lists.newArrayList();
        if (businessEntity == null || request == null || ctx == null) {
            return keyFilters;
        }
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).collect(Collectors.toList());
        block16: for (ViewField viewField : viewFields) {
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[businessEntityField.getQuery().getQueryType().ordinal()]) {
                case 1: {
                    Optional<RuntimeFilterField> nameFilter = request.getRuntimeFilters().stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst();
                    if (!nameFilter.isPresent()) continue block16;
                    keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.ENTITY_FIELD, "name", nameFilter.get(), request, ctx));
                    continue block16;
                }
                case 2: {
                    Optional<RuntimeFilterField> labelFilter = request.getRuntimeFilters().stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst();
                    if (!labelFilter.isPresent()) continue block16;
                    keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.ENTITY_FIELD, "label", labelFilter.get(), request, ctx));
                    continue block16;
                }
                case 3: {
                    Optional<RuntimeFilterField> attrFilter = request.getRuntimeFilters().stream().filter(rf -> rf.getViewFieldId().equals(viewField.getId())).findFirst();
                    if (!attrFilter.isPresent()) continue block16;
                    TbBusinessEntityFieldQuery query = (TbBusinessEntityFieldQuery)businessEntityField.getQuery();
                    switch (query.getScope()) {
                        case "CLIENT_SCOPE": {
                            keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.CLIENT_ATTRIBUTE, query.getKey(), attrFilter.get(), request, ctx));
                            break;
                        }
                        case "SHARED_SCOPE": {
                            keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.SHARED_ATTRIBUTE, query.getKey(), attrFilter.get(), request, ctx));
                            break;
                        }
                        case "SERVER_SCOPE": {
                            keyFilters.add(this.buildEntityKeyFilter(EntityKeyType.SERVER_ATTRIBUTE, query.getKey(), attrFilter.get(), request, ctx));
                        }
                    }
                    continue block16;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block16;
                }
            }
            throw new IllegalStateException("Unsupported entity Field type for query filter " + businessEntityField.getQuery().getQueryType());
        }
        return keyFilters;
    }

    private List<EntityKey> getEntityKeys(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList entityKeys = Lists.newArrayList();
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "name"));
        entityKeys.add(new EntityKey(EntityKeyType.ENTITY_FIELD, "label"));
        ArrayList latestKeys = Lists.newArrayList();
        if (businessEntity == null || request == null || ctx == null) {
            return entityKeys;
        }
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).collect(Collectors.toList());
        block15: for (ViewField viewField : viewFields) {
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[businessEntityField.getQuery().getQueryType().ordinal()]) {
                case 1: 
                case 2: {
                    continue block15;
                }
                case 3: {
                    TbBusinessEntityFieldQuery tbQuery = (TbBusinessEntityFieldQuery)businessEntityField.getQuery();
                    switch (tbQuery.getScope()) {
                        case "CLIENT_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.CLIENT_ATTRIBUTE, tbQuery.getKey()));
                            break;
                        }
                        case "SHARED_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SHARED_ATTRIBUTE, tbQuery.getKey()));
                            break;
                        }
                        case "SERVER_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, tbQuery.getKey()));
                        }
                    }
                    continue block15;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block15;
                }
            }
            throw new IllegalStateException("Unsupported entity Field type for query keys " + businessEntityField.getQuery().getQueryType());
        }
        return entityKeys;
    }

    private List<EntityKey> getLatestKeys(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx) {
        ArrayList latestKeys = Lists.newArrayList();
        if (businessEntity == null || request == null || ctx == null) {
            return latestKeys;
        }
        Set fieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        List viewFields = request.getFields().stream().filter(f -> fieldIds.contains(f.getEntityFieldId())).collect(Collectors.toList());
        for (ViewField viewField : viewFields) {
            BusinessEntityField businessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            block0 : switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldQueryType[businessEntityField.getQuery().getQueryType().ordinal()]) {
                case 3: {
                    TbBusinessEntityFieldQuery tbQuery = (TbBusinessEntityFieldQuery)businessEntityField.getQuery();
                    switch (tbQuery.getScope()) {
                        case "CLIENT_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.CLIENT_ATTRIBUTE, tbQuery.getKey()));
                            break block0;
                        }
                        case "SHARED_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SHARED_ATTRIBUTE, tbQuery.getKey()));
                            break block0;
                        }
                        case "SERVER_SCOPE": {
                            latestKeys.add(new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, tbQuery.getKey()));
                        }
                    }
                }
            }
        }
        return latestKeys;
    }

    private KeyFilter buildEntityKeyFilter(EntityKeyType keyType, String keyName, RuntimeFilterField filterField, ViewRequest request, ViewContext ctx) {
        StringFilterPredicate.StringOperation operation;
        KeyFilter filter = new KeyFilter();
        filter.setKey(new EntityKey(keyType, keyName));
        ArrayList nameOptions = Lists.newArrayList();
        FilterCondition condition = filterField.getCondition();
        if (condition == FilterCondition.START_WITH || condition == FilterCondition.END_WITH || condition == FilterCondition.CONTAINS) {
            operation = null;
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                case 1: {
                    operation = StringFilterPredicate.StringOperation.STARTS_WITH;
                    break;
                }
                case 2: {
                    operation = StringFilterPredicate.StringOperation.CONTAINS;
                    break;
                }
                case 3: {
                    operation = StringFilterPredicate.StringOperation.ENDS_WITH;
                }
            }
            StringFilterPredicate predicate = new StringFilterPredicate();
            predicate.setValue(FilterPredicateValue.fromString((String)filterField.getStrParam()));
            predicate.setOperation(operation);
            predicate.setIgnoreCase(true);
            nameOptions.add(predicate);
        } else if (condition == FilterCondition.GREATER || condition == FilterCondition.GREATER_EQUALS || condition == FilterCondition.LOWER || condition == FilterCondition.LOWER_EQUALS) {
            operation = null;
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                case 4: {
                    operation = NumericFilterPredicate.NumericOperation.GREATER;
                    break;
                }
                case 5: {
                    operation = NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL;
                    break;
                }
                case 6: {
                    operation = NumericFilterPredicate.NumericOperation.LESS;
                    break;
                }
                case 7: {
                    operation = NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL;
                }
            }
            NumericFilterPredicate predicate = new NumericFilterPredicate();
            predicate.setValue(FilterPredicateValue.fromDouble((double)filterField.getNumericParam()));
            predicate.setOperation((NumericFilterPredicate.NumericOperation)operation);
            nameOptions.add(predicate);
        } else if (condition == FilterCondition.BEFORE || condition == FilterCondition.BEFORE_EQUALS || condition == FilterCondition.AFTER || condition == FilterCondition.AFTER_EQUALS) {
            operation = null;
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
                case 8: {
                    operation = NumericFilterPredicate.NumericOperation.GREATER;
                    break;
                }
                case 9: {
                    operation = NumericFilterPredicate.NumericOperation.GREATER_OR_EQUAL;
                    break;
                }
                case 10: {
                    operation = NumericFilterPredicate.NumericOperation.LESS;
                    break;
                }
                case 11: {
                    operation = NumericFilterPredicate.NumericOperation.LESS_OR_EQUAL;
                }
            }
            NumericFilterPredicate predicate = new NumericFilterPredicate();
            predicate.setValue(FilterPredicateValue.fromDouble((double)filterField.getNumericParam()));
            predicate.setOperation((NumericFilterPredicate.NumericOperation)operation);
            nameOptions.add(predicate);
        } else if (condition == FilterCondition.ONE_OF) {
            Set selection = filterField.getSelection();
            ComplexFilterPredicate complexFilterPredicate = new ComplexFilterPredicate();
            complexFilterPredicate.setOperation(ComplexFilterPredicate.ComplexOperation.OR);
            ViewField filteredViewField = request.getFields().stream().filter(viewField -> filterField.getViewFieldId().equals(viewField.getId())).findAny().get();
            BusinessEntityField filteredBusinessEntityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(filteredViewField.getEntityFieldId());
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[filteredBusinessEntityField.getType().ordinal()]) {
                case 1: 
                case 2: {
                    for (String value : selection) {
                        NumericFilterPredicate predicate = new NumericFilterPredicate();
                        predicate.setValue(FilterPredicateValue.fromDouble((double)Double.parseDouble(value)));
                        predicate.setOperation(NumericFilterPredicate.NumericOperation.EQUAL);
                        nameOptions.add(predicate);
                    }
                    break;
                }
                case 3: {
                    for (String value : selection) {
                        BooleanFilterPredicate predicate = new BooleanFilterPredicate();
                        predicate.setValue(FilterPredicateValue.fromBoolean((boolean)Boolean.parseBoolean(value)));
                        predicate.setOperation(BooleanFilterPredicate.BooleanOperation.EQUAL);
                        nameOptions.add(predicate);
                    }
                    break;
                }
                case 4: {
                    for (String name : selection) {
                        StringFilterPredicate predicate = new StringFilterPredicate();
                        predicate.setValue(FilterPredicateValue.fromString((String)name));
                        predicate.setOperation(StringFilterPredicate.StringOperation.EQUAL);
                        predicate.setIgnoreCase(true);
                        nameOptions.add(predicate);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Field type cannot be Calculated or Blank in the query builder.");
                }
            }
            complexFilterPredicate.setPredicates((List)nameOptions);
            filter.setPredicate((KeyFilterPredicate)complexFilterPredicate);
        }
        ComplexFilterPredicate complexFilterPredicate = new ComplexFilterPredicate();
        complexFilterPredicate.setOperation(ComplexFilterPredicate.ComplexOperation.OR);
        complexFilterPredicate.setPredicates((List)nameOptions);
        filter.setPredicate((KeyFilterPredicate)complexFilterPredicate);
        return filter;
    }

    private EntityFilter getEntityFilter(EntityType entityType, String type) {
        if (EntityType.DEVICE.equals((Object)entityType)) {
            DeviceTypeFilter filter = new DeviceTypeFilter();
            filter.setDeviceType(type);
            filter.setDeviceNameFilter("");
            return filter;
        }
        if (EntityType.ASSET.equals((Object)entityType)) {
            AssetTypeFilter filter = new AssetTypeFilter();
            filter.setAssetType(type);
            filter.setAssetNameFilter("");
            return filter;
        }
        if (EntityType.CUSTOMER.equals((Object)entityType)) {
            EntityNameFilter filter = new EntityNameFilter();
            filter.setEntityType(EntityType.CUSTOMER);
            filter.setEntityNameFilter("");
            return filter;
        }
        throw new IllegalStateException("Entity type not supported: " + entityType);
    }
}

