/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3.tb31filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.EnhancedAsset;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.provider.tb3.PageData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.FilteredEntityDataTransformer;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Component
public class FilteredEntityDataTransformer {
    @Autowired
    private TbRestDataSource tbRestDataSource;

    public PageData<Device> entityToDevicePageData(PageData<EntityData> entityPageData) {
        List devices = entityPageData.getData().stream().filter(ent -> ent.getEntityId() instanceof DeviceId).map(ent -> {
            EnhancedDevice device = new EnhancedDevice();
            device.setId((UUIDBased)((DeviceId)ent.getEntityId()));
            ConcurrentHashMap attrMap = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            device.setName(((TsValue)entityFields.get("name")).getValue());
                        }
                        if (entityFields.containsKey("type")) {
                            device.setType(((TsValue)entityFields.get("type")).getValue());
                        }
                        if (!entityFields.containsKey("label")) break;
                        device.setLabel(((TsValue)entityFields.get("label")).getValue());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        for (Map.Entry valueEntry : attrFields.entrySet()) {
                            attrMap.put(valueEntry.getKey(), ((TsValue)valueEntry.getValue()).getValue());
                        }
                        break;
                    }
                }
            }
            if (MapUtils.isNotEmpty(attrMap)) {
                device.setAttributes(attrMap);
            }
            return device;
        }).collect(Collectors.toList());
        PageData devicePageData = new PageData(devices, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return devicePageData;
    }

    public PageData<Asset> entityToAssetPageData(PageData<EntityData> entityPageData) {
        List assets = entityPageData.getData().stream().filter(ent -> ent.getEntityId() instanceof AssetId).map(ent -> {
            EnhancedAsset asset = new EnhancedAsset();
            asset.setId((UUIDBased)((AssetId)ent.getEntityId()));
            ConcurrentHashMap attrMap = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            asset.setName(((TsValue)entityFields.get("name")).getValue());
                        }
                        if (entityFields.containsKey("type")) {
                            asset.setType(((TsValue)entityFields.get("type")).getValue());
                        }
                        if (!entityFields.containsKey("label")) break;
                        asset.setLabel(((TsValue)entityFields.get("label")).getValue());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        for (Map.Entry valueEntry : attrFields.entrySet()) {
                            attrMap.put(valueEntry.getKey(), ((TsValue)valueEntry.getValue()).getValue());
                        }
                        break;
                    }
                }
            }
            if (MapUtils.isNotEmpty(attrMap)) {
                asset.setAttributes(attrMap);
            }
            return asset;
        }).collect(Collectors.toList());
        PageData assetPageData = new PageData(assets, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return assetPageData;
    }

    public PageData<Customer> entityToCustomerPageData(PageData<EntityData> entityPageData) {
        List customers = entityPageData.getData().stream().map(ent -> {
            if (!(ent.getEntityId() instanceof CustomerId)) {
                return null;
            }
            EnhancedCustomer customer = new EnhancedCustomer();
            customer.setId((UUIDBased)((CustomerId)ent.getEntityId()));
            ConcurrentHashMap attrMap = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (!entityFields.containsKey("name")) break;
                        customer.setTitle(((TsValue)entityFields.get("name")).getValue());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        for (Map.Entry valueEntry : attrFields.entrySet()) {
                            attrMap.put(valueEntry.getKey(), ((TsValue)valueEntry.getValue()).getValue());
                        }
                        break;
                    }
                }
            }
            if (MapUtils.isNotEmpty(attrMap)) {
                customer.setAttributes(attrMap);
            }
            return customer;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PageData customersPageData = new PageData(customers, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return customersPageData;
    }

    public PageData<Item> entityToItemPageData(PageData<EntityData> entityPageData) {
        List items = entityPageData.getData().stream().map(ent -> {
            String name = null;
            String label = null;
            ConcurrentHashMap attrMap = new ConcurrentHashMap();
            for (Map.Entry entry : ent.getLatest().entrySet()) {
                switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[((EntityKeyType)entry.getKey()).ordinal()]) {
                    case 1: {
                        Map entityFields = (Map)entry.getValue();
                        if (entityFields.containsKey("name")) {
                            name = ((TsValue)entityFields.get("name")).getValue();
                        }
                        if (!entityFields.containsKey("label")) break;
                        label = ((TsValue)entityFields.get("label")).getValue();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Map attrFields = (Map)entry.getValue();
                        for (Map.Entry valueEntry : attrFields.entrySet()) {
                            attrMap.put(valueEntry.getKey(), ((TsValue)valueEntry.getValue()).getValue());
                        }
                        break;
                    }
                }
            }
            Item item = new Item(ent.getEntityId().getId(), null, null, name, label);
            if (MapUtils.isNotEmpty(attrMap)) {
                item.setAttributes(attrMap);
            }
            return item;
        }).collect(Collectors.toList());
        PageData itemPageData = new PageData(items, entityPageData.getTotalPages(), entityPageData.getTotalElements(), entityPageData.hasNext());
        return itemPageData;
    }

    public void fetchFilterValues(ViewContext ctx, ViewRequest request, BusinessEntity businessEntity, EntityDataQuery originalQuery) {
        if (request != null) {
            Set entityFieldIds = businessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
            Set viewFields = request.getFields().stream().filter(f -> entityFieldIds.contains(f.getEntityFieldId())).collect(Collectors.toSet());
            Set viewfieldIds = viewFields.stream().map(ViewField::getId).collect(Collectors.toSet());
            List refetchFields = request.getRuntimeFilters().stream().filter(f -> !f.isBlankFilter()).filter(f -> viewfieldIds.contains(f.getViewFieldId())).collect(Collectors.toList());
            Set requiredVieFieldIds = refetchFields.stream().map(rff -> rff.getViewFieldId()).collect(Collectors.toSet());
            Set requiredEntitiFieldIds = viewFields.stream().filter(vf -> requiredVieFieldIds.contains(vf.getId())).map(vf -> vf.getEntityFieldId()).collect(Collectors.toSet());
            Set requiredEntityFields = businessEntity.getFields().stream().filter(bef -> requiredEntitiFieldIds.contains(bef.getId())).collect(Collectors.toSet());
            if (!refetchFields.isEmpty()) {
                originalQuery.getKeyFilters().clear();
                Set filteredLatest = originalQuery.getLatestValues().stream().filter(ek -> this.isFitlered(ek, requiredEntityFields)).collect(Collectors.toSet());
                originalQuery.getLatestValues().clear();
                originalQuery.getLatestValues().addAll(filteredLatest);
                Set filteredEntityKeys = originalQuery.getEntityFields().stream().filter(ek -> this.isFitlered(ek, requiredEntityFields)).collect(Collectors.toSet());
                originalQuery.getEntityFields().clear();
                originalQuery.getEntityFields().addAll(filteredEntityKeys);
                ctx.getFieldFilterOptionTasks().add(new FilterOptionTask(originalQuery, businessEntity));
            }
        }
    }

    private boolean isFitlered(EntityKey entityKey, Set<BusinessEntityField> requiredEntityFields) {
        switch (1.$SwitchMap$org$thingsboard$trendz$service$provider$tb3$tb31filter$query$EntityKeyType[entityKey.getType().ordinal()]) {
            case 1: {
                if (entityKey.getKey().equals("name")) {
                    return requiredEntityFields.stream().anyMatch(ef -> FieldQueryType.ENTITY_NAME.equals((Object)ef.getQuery().getQueryType()));
                }
                if (!entityKey.getKey().equals("label")) break;
                return requiredEntityFields.stream().anyMatch(ef -> FieldQueryType.ENTITY_LABEL.equals((Object)ef.getQuery().getQueryType()));
            }
            case 2: {
                return requiredEntityFields.stream().anyMatch(ef -> {
                    TbBusinessEntityFieldQuery query = (TbBusinessEntityFieldQuery)ef.getQuery();
                    return "CLIENT_SCOPE".equals(query.getScope()) && entityKey.getKey().equals(query.getKey());
                });
            }
            case 3: {
                return requiredEntityFields.stream().anyMatch(ef -> {
                    TbBusinessEntityFieldQuery query = (TbBusinessEntityFieldQuery)ef.getQuery();
                    return "SERVER_SCOPE".equals(query.getScope()) && entityKey.getKey().equals(query.getKey());
                });
            }
            case 4: {
                return requiredEntityFields.stream().anyMatch(ef -> {
                    TbBusinessEntityFieldQuery query = (TbBusinessEntityFieldQuery)ef.getQuery();
                    return "SHARED_SCOPE".equals(query.getScope()) && entityKey.getKey().equals(query.getKey());
                });
            }
        }
        return false;
    }

    public Flux<Asset> enrichAssetsWithCustomerIdAsync(Set<Asset> assets, String jwtToken) {
        Flux listFlux = Flux.fromIterable((Iterable)Lists.partition((List)Lists.newArrayList(assets), (int)100));
        Flux assetFlux = listFlux.flatMap(list -> {
            Map<UUID, Asset> assetMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            return this.tbRestDataSource.loadAssetsByIdsAsync(assetMap.keySet(), jwtToken).flatMapIterable(l -> l).doOnNext(d -> {
                Asset dd = (Asset)assetMap.get(d.getUuidId());
                if (dd != null) {
                    dd.setTenantId(d.getTenantId());
                    dd.setCustomerId(d.getCustomerId());
                }
            });
        }).collectList().flatMapIterable(l -> assets);
        return assetFlux;
    }

    public void enrichAssetsWithCustomerId(Set<Asset> assets, String jwtToken) {
        for (List list : Lists.partition((List)Lists.newArrayList(assets), (int)100)) {
            Map<UUID, Asset> assetMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            List assetsWithCustomer = this.tbRestDataSource.loadAssetsByIds(assetMap.keySet(), jwtToken);
            for (Asset device : assetsWithCustomer) {
                Asset aa = assetMap.get(device.getUuidId());
                if (aa == null) continue;
                aa.setTenantId(device.getTenantId());
                aa.setCustomerId(device.getCustomerId());
            }
        }
    }

    public Flux<Device> enrichDevicesWithCustomerIdAsync(Set<Device> devices, String jwtToken) {
        Flux listFlux = Flux.fromIterable((Iterable)Lists.partition((List)Lists.newArrayList(devices), (int)100));
        Flux deviceFlux = listFlux.flatMap(list -> {
            Map<UUID, Device> deviceMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            return this.tbRestDataSource.loadDevicesByIdsAsync(deviceMap.keySet(), jwtToken).flatMapIterable(l -> l).doOnNext(d -> {
                Device dd = (Device)deviceMap.get(d.getUuidId());
                if (dd != null) {
                    dd.setTenantId(d.getTenantId());
                    dd.setCustomerId(d.getCustomerId());
                }
            });
        }).collectList().flatMapIterable(l -> devices);
        return deviceFlux;
    }

    public void enrichDevicesWithCustomerId(Set<Device> devices, String jwtToken) {
        for (List list : Lists.partition((List)Lists.newArrayList(devices), (int)100)) {
            Map<UUID, Device> deviceMap = list.stream().collect(Collectors.toMap(IdBased::getUuidId, d -> d));
            List devicesWithCustomer = this.tbRestDataSource.loadDevicesByIds(deviceMap.keySet(), jwtToken);
            for (Device device : devicesWithCustomer) {
                Device dd = deviceMap.get(device.getUuidId());
                if (dd == null) continue;
                dd.setTenantId(device.getTenantId());
                dd.setCustomerId(device.getCustomerId());
            }
        }
    }
}

