/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class PageLink {
    private int pageSize;
    private int page;

    public PageLink(int pageSize) {
        this(pageSize, 0);
    }

    public PageLink(int pageSize, int page) {
        this.pageSize = pageSize;
        this.page = page;
    }

    @JsonIgnore
    public PageLink nextPageLink() {
        return new PageLink(this.pageSize, this.page + 1);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageLink)) {
            return false;
        }
        PageLink other = (PageLink)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        return this.getPage() == other.getPage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPage();
        return result;
    }

    public String toString() {
        return "PageLink(pageSize=" + this.getPageSize() + ", page=" + this.getPage() + ")";
    }
}

