/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.tb3;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thingsboard.trendz.service.provider.tb3.PageData;
import org.thingsboard.trendz.service.provider.tb3.PageDataIterableV3;
import org.thingsboard.trendz.service.provider.tb3.PageLink;

public class PageDataIterableV3<T>
implements Iterable<T>,
Iterator<T> {
    private final FetchFunction<T> function;
    private final int fetchSize;
    private List<T> currentItems;
    private int currentIdx;
    private boolean hasNextPack;
    private PageLink nextPackLink;
    private boolean initialized;

    public PageDataIterableV3(FetchFunction<T> function, int fetchSize) {
        this.function = function;
        this.fetchSize = fetchSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.fetch(new PageLink(this.fetchSize));
            this.initialized = true;
        }
        if (this.currentIdx == this.currentItems.size() && this.hasNextPack) {
            this.fetch(this.nextPackLink);
        }
        return this.currentIdx < this.currentItems.size();
    }

    private void fetch(PageLink link) {
        PageData pageData = this.function.fetch(link);
        this.currentIdx = 0;
        this.currentItems = pageData.getData();
        this.hasNextPack = pageData.hasNext();
        this.nextPackLink = link.nextPageLink();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)this.currentItems.get(this.currentIdx++);
    }
}

