/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.cache;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Component
public class WebClientCachier {
    private static final Logger log = LoggerFactory.getLogger(WebClientCachier.class);
    private static final String apiCallCacheName = "apiCalls";
    private static final String telemetryCacheName = "telemetry";
    private boolean apiCallCacheEnabled = false;
    private boolean telemetryCacheEnabled = false;
    @Autowired
    private TokenExtractor tokenExtractor;
    @Autowired
    private StatsCollector statsCollector;
    @Autowired
    private CacheManager cacheManager;
    private final Scheduler scheduler = Schedulers.newParallel((String)"parallel-scheduler-cachier", (int)32);

    @PostConstruct
    public void init() {
        if (this.cacheManager.getCache(apiCallCacheName) != null) {
            this.apiCallCacheEnabled = true;
        }
        if (this.cacheManager.getCache(telemetryCacheName) != null) {
            this.telemetryCacheEnabled = true;
        }
    }

    public Mono<Map<String, List<TsData>>> getOrFetchTelemetry(String key, String jwt, Supplier<Mono<Map<String, List<TsData>>>> fetcher) {
        return fetcher.get();
    }

    public <T> Flux<T> getOrFetch(String reqType, String key, String jwt, Supplier<Flux<T>> fetcher) {
        if (!this.apiCallCacheEnabled) {
            return fetcher.get();
        }
        long startTs = System.currentTimeMillis();
        JwtSecUser jwtSecUser = this.tokenExtractor.getJwtSecUser(jwt);
        String cacheKey = reqType + "_" + key + "_" + jwtSecUser;
        List list = (List)this.cacheManager.getCache(apiCallCacheName).get((Object)cacheKey, List.class);
        if (list == null) {
            Flux result = fetcher.get().subscribeOn(this.scheduler);
            return result.collectList().map(l -> {
                this.cacheManager.getCache(apiCallCacheName).put((Object)cacheKey, l);
                return l;
            }).flatMapIterable(l -> l);
        }
        this.statsCollector.tick("restCacheHit", startTs, System.currentTimeMillis(), TickType.OTHER);
        return Flux.fromIterable((Iterable)list);
    }
}

