/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.trendz.service.provider.cache.CacheSpecs;

@Configuration
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="caffeine", matchIfMissing=true)
@ConfigurationProperties(prefix="caffeine")
@EnableCaching
public class CaffeineCacheConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CaffeineCacheConfiguration.class);
    private Map<String, CacheSpecs> specs;

    @Bean
    public CacheManager cacheManager() {
        log.trace("Initializing cache: {}", (Object)Arrays.toString(RemovalCause.values()));
        SimpleCacheManager manager = new SimpleCacheManager();
        if (this.specs != null) {
            List caches = this.specs.entrySet().stream().map(entry -> this.buildCache((String)entry.getKey(), (CacheSpecs)entry.getValue())).collect(Collectors.toList());
            manager.setCaches(caches);
        }
        return manager;
    }

    private CaffeineCache buildCache(String name, CacheSpecs cacheSpec) {
        Caffeine caffeineBuilder = Caffeine.newBuilder().weigher(this.collectionSafeWeigher()).maximumWeight((long)cacheSpec.getMaxSize().intValue()).expireAfterWrite((long)cacheSpec.getTimeToLiveInMinutes().intValue(), TimeUnit.MINUTES).ticker(this.ticker());
        return new CaffeineCache(name, caffeineBuilder.build());
    }

    @Bean
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    private Weigher<? super Object, ? super Object> collectionSafeWeigher() {
        return (key, value) -> {
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                int length = 0;
                for (Object k : map.keySet()) {
                    Object val = map.get(k);
                    if (!(val instanceof Collection)) continue;
                    length += ((Collection)val).size();
                }
                return length;
            }
            return 1;
        };
    }

    public Map<String, CacheSpecs> getSpecs() {
        return this.specs;
    }

    public void setSpecs(Map<String, CacheSpecs> specs) {
        this.specs = specs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineCacheConfiguration)) {
            return false;
        }
        CaffeineCacheConfiguration other = (CaffeineCacheConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$specs = this.getSpecs();
        Map other$specs = other.getSpecs();
        return !(this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CaffeineCacheConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $specs = this.getSpecs();
        result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
        return result;
    }

    public String toString() {
        return "CaffeineCacheConfiguration(specs=" + this.getSpecs() + ")";
    }
}

