/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.TextPageData;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.service.provider.TbVersion;
import org.thingsboard.trendz.service.provider.tb3.PageData;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.DeviceTypeFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataPageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataSortOrder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityFilter;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKey;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityKeyType;
import org.thingsboard.trendz.tools.SSLUtils;
import reactor.netty.http.client.HttpClient;

@Component
public class TbVersionChecker {
    private static final Logger log = LoggerFactory.getLogger(TbVersionChecker.class);
    private boolean useWebSockets = false;
    public static final String TB_2x_VERSION = "2.x";
    public static final String TB_3x_VERSION = "3.x";
    public static final String TB_31x_VERSION = "3.1x";
    @Autowired
    private TokenExtractor tokenExtractor;
    @Value(value="${tb.api.pe:true}")
    private boolean useTbPeApi;
    private final WebClient webClient;
    private final String baseURL;
    private TbVersion tbVersion;

    public TbVersionChecker(@Value(value="${tb.api.url}") String tbApiUrl) throws KeyManagementException, NoSuchAlgorithmException, SSLException {
        this.baseURL = tbApiUrl;
        SSLUtils.turnOffSslChecking();
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient secure = HttpClient.create().secure(t -> t.sslContext(sslContext));
        ReactorClientHttpConnector httpConnector = new ReactorClientHttpConnector(secure);
        this.webClient = WebClient.builder().baseUrl(tbApiUrl).clientConnector((ClientHttpConnector)httpConnector).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbVersion getVersion(String jwtToken) {
        if (this.tbVersion != null) {
            return this.tbVersion;
        }
        TbVersionChecker tbVersionChecker = this;
        synchronized (tbVersionChecker) {
            if (this.tbVersion != null) {
                return this.tbVersion;
            }
            JwtSecUser secUser = this.getSecUser(jwtToken);
            TbVersion localVersion = new TbVersion();
            localVersion.setPe(true);
            localVersion.setVersion(TB_2x_VERSION);
            if (this.isTb2Api(jwtToken, secUser)) {
                localVersion.setVersion(TB_2x_VERSION);
                localVersion.setPe(this.is2xPe(jwtToken));
            } else if (this.isTb3Api(jwtToken, secUser)) {
                if (this.isTb31FilterApi(jwtToken, secUser)) {
                    localVersion.setVersion(TB_31x_VERSION);
                } else {
                    localVersion.setVersion(TB_3x_VERSION);
                }
                localVersion.setPe(this.is3xPe(jwtToken));
            } else {
                throw new IllegalStateException("ThingsBoard service not available");
            }
            this.tbVersion = localVersion;
            log.info("Tb Version discovered {}", (Object)this.tbVersion);
            return this.tbVersion;
        }
    }

    public boolean isWebosketApiAllowed() {
        return this.useWebSockets;
    }

    private boolean isTb2Api(String jwtToken, JwtSecUser secUser) {
        try {
            TextPageData page;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("limit", 1);
            params.put("type", "stubType");
            params.put("idOffset", "fd48a070-aef4-11ea-b3fd-91f05b9b652c");
            params.put("textOffset", " ");
            params.put("textSearch", " ");
            String path = "/api/tenant/assets?";
            if (!secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                params.put("customerId", secUser.getCustomerId());
                path = "/api/customer/{customerId}/assets?";
            }
            return (page = (TextPageData)this.webClient.get().uri(this.baseURL + path + "limit={limit}&type={type}&textOffset={textOffset}&textSearch={textSearch}&idOffset={idOffset}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block()) != null;
        }
        catch (Exception ex) {
            log.warn("TB API v2 not supported - {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean isTb3Api(String jwtToken, JwtSecUser secUser) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 1);
        params.put("page", 1);
        params.put("type", "stubType");
        params.put("textSearch", " ");
        params.put("sortProperty", "name");
        params.put("sortOrder", "ASC");
        try {
            String path = "/api/entityGroups/DASHBOARD";
            List page = (List)this.webClient.get().uri(this.baseURL + path, params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return page != null;
        }
        catch (Exception ex) {
            log.warn("TB API v3 PE initial not supported - {}", (Object)ex.getMessage());
            try {
                PageData page;
                String path = "/api/tenant/devices?";
                if (!secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                    params.put("customerId", secUser.getCustomerId());
                    path = "/api/customer/{customerId}/devices?";
                }
                return (page = (PageData)this.webClient.get().uri(this.baseURL + path + "page={page}&pageSize={pageSize}&type={type}&textSearch={textSearch}&sortProperty={sortProperty}&sortOrder={sortOrder}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block()) != null;
            }
            catch (Exception ex2) {
                log.warn("TB API v3 CE not supported - {}", (Object)ex2.getMessage());
                return false;
            }
        }
    }

    private boolean isTb31FilterApi(String jwtToken, JwtSecUser secUser) {
        try {
            DeviceTypeFilter filter = new DeviceTypeFilter();
            filter.setDeviceType("default");
            filter.setDeviceNameFilter("");
            List keyFilters = Collections.emptyList();
            List entityFields = Collections.emptyList();
            List latestValues = Collections.emptyList();
            EntityDataSortOrder sortOrder = new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"), EntityDataSortOrder.Direction.ASC);
            EntityDataPageLink pageLink = new EntityDataPageLink(10, 0, null, sortOrder);
            EntityDataQuery query = new EntityDataQuery((EntityFilter)filter, pageLink, entityFields, latestValues, keyFilters);
            PageData page = (PageData)((WebClient.RequestBodySpec)this.webClient.post().uri(this.baseURL + "/api/entitiesQuery/find", new Object[0])).body(BodyInserters.fromObject((Object)query)).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return page != null;
        }
        catch (Exception ex) {
            log.warn("TB API v3.1_filter not supported - {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean is3xPe(String jwtToken) {
        try {
            String path = "/api/entityGroups/DASHBOARD";
            List page = (List)this.webClient.get().uri(this.baseURL + path, new HashMap()).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return page != null;
        }
        catch (Exception ex) {
            log.warn("TB API PEv3 not supported - {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean is2xPe(String jwtToken) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("limit", 1);
            params.put("type", "GENERIC");
            params.put("idOffset", EntityId.NULL_UUID);
            params.put("textOffset", " ");
            params.put("textSearch", " ");
            TextPageData page = (TextPageData)this.webClient.get().uri(this.baseURL + "/api/roles?limit={limit}&type={type}&idOffset={idOffset}&textSearch={textSearch}&textOffset={textOffset}", params).header("X-Authorization", new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return page != null;
        }
        catch (Exception ex) {
            log.warn("TB API PEv2 not supported - {}", (Object)ex.getMessage());
            return false;
        }
    }

    private JwtSecUser getSecUser(String jwtToken) {
        return this.tokenExtractor.getJwtSecUser(jwtToken);
    }
}

