/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Sets;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.device.DeviceSearchQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.TextPageData;
import org.thingsboard.server.common.data.page.TextPageLink;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.service.provider.AttributeData;
import org.thingsboard.trendz.service.provider.TbApiSpec;
import org.thingsboard.trendz.service.provider.TbDataSource;
import org.thingsboard.trendz.service.provider.TbVersion;
import org.thingsboard.trendz.service.provider.TbVersionChecker;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.cache.WebClientCachier;
import org.thingsboard.trendz.service.provider.tb3.PageData;
import org.thingsboard.trendz.service.provider.tb3.PageDataIterableV3;
import org.thingsboard.trendz.service.provider.tb3.PageLink;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.FilteredEntityDataTransformer;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.PageDataIterableV3Filterable;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.TbFilterQueryBuilder;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.EntityDataQuery;
import org.thingsboard.trendz.service.provider.ws.TbWebsocketClient;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.SSLUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;

@Component
public class TbRestDataSource
implements TbDataSource {
    private static final Logger log = LoggerFactory.getLogger(TbRestDataSource.class);
    public static final String JWT_TOKEN_HEADER_PARAM = "X-Authorization";
    @Autowired
    private TbApiSpec tbApiSpec;
    @Autowired
    private TbVersionChecker tbVersionChecker;
    @Autowired
    private TbFilterQueryBuilder tbFilterQueryBuilder;
    @Autowired
    private FilteredEntityDataTransformer entityDataTransformer;
    @Autowired
    private TbWebsocketClient wsClient;
    @Autowired
    private StatsCollector statsCollector;
    @Autowired
    private WebClientCachier webClientCachier;
    @Value(value="${tb.api.pe:true}")
    private boolean useTbPeApi;
    private final WebClient webClient;
    private final String baseURL;
    private final Bucket bucket;
    private final Scheduler scheduler = Schedulers.newParallel((String)"parallel-scheduler-datasource", (int)20);
    private final Scheduler otherScheduler = Schedulers.fromExecutor((Executor)Executors.newFixedThreadPool(20));
    private ScheduledExecutorService logExecutor;
    private final AtomicLong totalRequestCount = new AtomicLong(0L);
    private final AtomicLong concurentRequests = new AtomicLong(0L);
    private final int maxConcurentRequests;
    private final BlockingQueue inProgressQueue;

    public TbRestDataSource(@Value(value="${tb.api.url}") String tbApiUrl, @Value(value="${ratelimit.max_concurent_requests}") int maxConcurentRequests, @Value(value="${ratelimit.duration.sec}") int rateLimitDurationSec, @Value(value="${ratelimit.max_reqeusts_per_duration}") int maxRequests) throws SSLException, KeyManagementException, NoSuchAlgorithmException {
        this.baseURL = tbApiUrl;
        SSLUtils.turnOffSslChecking();
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient secure = HttpClient.create().secure(t -> t.sslContext(sslContext));
        ReactorClientHttpConnector httpConnector = new ReactorClientHttpConnector(secure);
        this.webClient = WebClient.builder().baseUrl(tbApiUrl).clientConnector((ClientHttpConnector)httpConnector).filter((request, next) -> {
            this.totalRequestCount.incrementAndGet();
            this.withRateLimiting();
            return next.exchange(request);
        }).exchangeFunction((ExchangeFunction)new /* Unavailable Anonymous Inner Class!! */).build();
        LocalBucketBuilder builder = Bucket4j.builder();
        if (this.baseURL.contains("cloud.thingsboard.io") || this.baseURL.contains("demo.thingsboard.io")) {
            builder.addLimit(Bandwidth.simple((long)4L, (Duration)Duration.ofSeconds(1L)));
            builder.addLimit(Bandwidth.simple((long)45L, (Duration)Duration.ofSeconds(10L)));
            builder.addLimit(Bandwidth.simple((long)95L, (Duration)Duration.ofSeconds(30L)));
            this.maxConcurentRequests = 4;
        } else if (this.baseURL.contains("thingsboard.cloud")) {
            builder.addLimit(Bandwidth.simple((long)17L, (Duration)Duration.ofSeconds(1L)));
            this.maxConcurentRequests = 4;
        } else {
            builder.addLimit(Bandwidth.simple((long)maxRequests, (Duration)Duration.ofSeconds(rateLimitDurationSec)));
            this.maxConcurentRequests = maxConcurentRequests;
        }
        this.bucket = builder.build();
        this.inProgressQueue = new LinkedBlockingDeque(this.maxConcurentRequests);
        this.logExecutor = Executors.newSingleThreadScheduledExecutor();
        this.logExecutor.scheduleAtFixedRate(() -> log.info("total requests {} in progress {} queue size {}", new Object[]{this.totalRequestCount.get(), this.concurentRequests.get(), this.inProgressQueue.size()}), 10L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void shutdown() {
        if (this.logExecutor != null) {
            this.logExecutor.shutdownNow();
        }
    }

    public AuthToken login(String login, String pass) {
        HashMap<String, String> loginRequest = new HashMap<String, String>();
        loginRequest.put("username", login);
        loginRequest.put("password", pass);
        AuthToken authToken = (AuthToken)((WebClient.RequestBodySpec)this.webClient.post().uri(this.baseURL + "/api/auth/login", new Object[0])).body(BodyInserters.fromObject(loginRequest)).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).onErrorMap(arg_0 -> this.mapError(arg_0)).doFinally(d -> this.releaseFromQueue(d)).block();
        return authToken;
    }

    private Throwable mapError(Throwable th) {
        if (th instanceof IOException) {
            return new IllegalStateException("ThingsBoard Service not available: " + th.getLocalizedMessage());
        }
        return th;
    }

    public AuthToken refreshToken(String refreshToken) {
        HashMap<String, String> refreshRequest = new HashMap<String, String>();
        refreshRequest.put("refreshToken", refreshToken);
        AuthToken authToken = (AuthToken)((WebClient.RequestBodySpec)this.webClient.post().uri(this.baseURL + "/api/auth/token", new Object[0])).body(BodyInserters.fromObject(refreshRequest)).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).block();
        return authToken;
    }

    public Flux<Device> findRelatedDevices(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, String relatedDeviceType, EntityId entityId, String jwtToken) {
        EntitySearchDirection direction;
        long executionStartTs = System.currentTimeMillis();
        Flux result = null;
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        EntitySearchDirection entitySearchDirection = direction = relationQuery.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        if (this.tbVersionChecker.isWebosketApiAllowed()) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            result = this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                this.totalRequestCount.incrementAndGet();
                this.withRateLimiting();
            }).map(page -> this.entityDataTransformer.entityToDevicePageData(page)).map(PageData::getData).doOnNext(l -> this.statsCollector.tick("findRelatedDevices", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(l -> l).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        } else if ("3.1x".equals(version.getVersion())) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            String key = "" + query;
            result = this.webClientCachier.getOrFetch("findRelatedDevices", key, jwtToken, () -> this.loadDevicesPageV31FilterAsync(request, query, null, jwtToken).map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(l -> this.statsCollector.tick("findRelatedDevices", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichDevicesWithCustomerIdAsync((Set)l, jwtToken);
                }
                return Flux.fromIterable((Iterable)l);
            })).doOnNext(l -> {
                EntityDataQuery optionsQuery = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, optionsQuery);
            });
        } else {
            DeviceSearchQuery query = new DeviceSearchQuery();
            query.setParameters(new RelationsSearchParameters(entityId, direction, relationQuery.getDistance(), false));
            query.setRelationType(relationQuery.getRelationType());
            query.setDeviceTypes(Collections.singletonList(relatedDeviceType));
            result = this.tbApiSpec.relatedDevices(this.webClient, this.baseURL, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnNext(l -> this.statsCollector.tick("findRelatedDevices", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).onErrorReturn(Collections.emptyList()).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler);
        }
        return result;
    }

    public Flux<Asset> findRelatedAssets(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, String relatedDeviceType, EntityId entityId, String jwtToken) {
        EntitySearchDirection direction;
        long executionStartTs = System.currentTimeMillis();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        EntitySearchDirection entitySearchDirection = direction = relationQuery.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        if (this.tbVersionChecker.isWebosketApiAllowed()) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            return this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                this.totalRequestCount.incrementAndGet();
                this.withRateLimiting();
            }).map(page -> this.entityDataTransformer.entityToAssetPageData(page)).map(PageData::getData).flatMapIterable(l -> l).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        if ("3.1x".equals(version.getVersion())) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            String key = "" + query;
            return this.webClientCachier.getOrFetch("findRelatedDevices", key, jwtToken, () -> this.loadAssetsPageV31FilterAsync(request, query, null, jwtToken).map(pd -> Sets.newHashSet((Iterable)pd.getData())).doOnNext(l -> this.statsCollector.tick("findRelatedAssets", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapMany(l -> {
                if (request != null && request.isOwnerRequired()) {
                    return this.entityDataTransformer.enrichAssetsWithCustomerIdAsync((Set)l, jwtToken);
                }
                return Flux.fromIterable((Iterable)l);
            })).doOnNext(l -> {
                EntityDataQuery optionsQuery = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, optionsQuery);
            });
        }
        AssetSearchQuery query = new AssetSearchQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, relationQuery.getDistance(), false));
        query.setRelationType(relationQuery.getRelationType());
        query.setAssetTypes(Collections.singletonList(relatedDeviceType));
        return this.tbApiSpec.relatedAssets(this.webClient, this.baseURL, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn(Collections.emptyList()).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler);
    }

    public Flux<Customer> findRelatedCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, String relatedCustomerType, EntityId entityId, String jwtToken) {
        EntitySearchDirection direction = relationQuery.getDirection() == Direction.FROM ? EntitySearchDirection.FROM : EntitySearchDirection.TO;
        long executionStartTs = System.currentTimeMillis();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        Object result = null;
        if (this.tbVersionChecker.isWebosketApiAllowed()) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            return this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                this.totalRequestCount.incrementAndGet();
                this.withRateLimiting();
            }).map(page -> this.entityDataTransformer.entityToCustomerPageData(page)).map(PageData::getData).doOnNext(l -> this.statsCollector.tick("findRelatedCustomers", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(l -> l).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        if ("3.1x".equals(version.getVersion())) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            EntityDataQuery otpionsQuery = this.tbFilterQueryBuilder.buildRelationQuery(entityId, direction, businessEntity, request, ctx, relationQuery.getRelationType(), 30000);
            this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, otpionsQuery);
            String key = "" + query;
            return this.webClientCachier.getOrFetch("findRelatedCustomers", key, jwtToken, () -> this.tbApiSpec.userEntitiesV31Filter(this.webClient, this.baseURL, jwtToken, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(page -> this.entityDataTransformer.entityToCustomerPageData(page)).map(page -> page.getData()).doOnNext(l -> this.statsCollector.tick("findRelatedCustomers", executionStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(l -> l).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler));
        }
        throw new IllegalStateException("Customer relation search not allowed in this version");
    }

    public List<EntitySubtype> loadAssetTypes(String jwtToken) {
        return (List)this.tbApiSpec.assetTypes(this.webClient, this.baseURL).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler).collectList().block();
    }

    public Flux<EntityRelation> findRelationsByFrom(UUID fromId, String entityType, String jwtToken) {
        return this.tbApiSpec.relationByFrom(this.webClient, this.baseURL, fromId, entityType).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler);
    }

    public List<EntitySubtype> loadDeviceTypes(String jwtToken) {
        return (List)this.tbApiSpec.deviceTypes(this.webClient, this.baseURL).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler).collectList().block();
    }

    public Flux<String> findAttributeKeys(String scope, String type, UUID id, String jwtToken) {
        return this.tbApiSpec.attrKeys(this.webClient, this.baseURL, scope, type, id).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler);
    }

    public Flux<String> findTelemetryKeys(String type, UUID id, String jwtToken) {
        return this.tbApiSpec.telemetryKeys(this.webClient, this.baseURL, type, id).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).flatMapIterable(set -> set).publishOn(this.scheduler);
    }

    public Set<Asset> loadAssetsByType(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String assetType, String jwtToken) {
        EntityDataQuery query;
        HashSet allAssets = Sets.newHashSet();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        PageDataIterable assetIterator = null;
        if ("2.x".equals(version.getVersion())) {
            assetIterator = new PageDataIterable(link -> this.loadAssetsPageV2(link, null, assetType, jwtToken), 10000);
        } else if ("3.x".equals(version.getVersion()) || request == null) {
            assetIterator = new PageDataIterableV3(link -> this.loadAssetsPageV3(link, null, assetType, jwtToken), 10000);
        } else if ("3.1x".equals(version.getVersion())) {
            query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.ASSET, assetType, businessEntity, request, ctx, 10000);
            assetIterator = new PageDataIterableV3Filterable(q -> this.loadAssetsPageV31Filter(request, q, null, jwtToken), query);
        } else {
            throw new IllegalStateException("Tb Version unknown " + version);
        }
        for (Asset asset : assetIterator) {
            allAssets.add(asset);
        }
        if ("3.1x".equals(version.getVersion()) && request != null) {
            query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.ASSET, assetType, businessEntity, request, ctx, 10000);
            this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, query);
        }
        if ("3.1x".equals(version.getVersion()) && request != null && request.isOwnerRequired()) {
            this.entityDataTransformer.enrichAssetsWithCustomerId((Set)allAssets, jwtToken);
        }
        return allAssets;
    }

    public Set<Item> loadItemsByQuery(EntityDataQuery query, String jwtToken) {
        HashSet allItems = Sets.newHashSet();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        PageDataIterableV3Filterable entityIterator = null;
        if (!"3.1x".equals(version.getVersion())) {
            throw new IllegalStateException("Tb Version unknown " + version);
        }
        entityIterator = new PageDataIterableV3Filterable(q -> this.loadRawEntityData(q, jwtToken), query);
        for (Item entityData : entityIterator) {
            allItems.add(entityData);
        }
        return allItems;
    }

    public Set<Asset> loadAssetsByTypeAndCustomer(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String assetType, JwtSecUser secUser, String jwtToken) {
        EntityDataQuery query;
        HashSet allAssets = Sets.newHashSet();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        PageDataIterable assetIterator = null;
        if ("2.x".equals(version.getVersion())) {
            assetIterator = new PageDataIterable(link -> this.loadAssetsPageV2(link, secUser, assetType, jwtToken), 10000);
        } else if ("3.x".equals(version.getVersion()) || request == null) {
            assetIterator = new PageDataIterableV3(link -> this.loadAssetsPageV3(link, secUser, assetType, jwtToken), 10000);
        } else if ("3.1x".equals(version.getVersion())) {
            query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.ASSET, assetType, businessEntity, request, ctx, 10000);
            assetIterator = new PageDataIterableV3Filterable(q -> this.loadAssetsPageV31Filter(request, q, null, jwtToken), query);
        } else {
            throw new IllegalStateException("Tb Version unknown " + version);
        }
        for (Asset asset : assetIterator) {
            allAssets.add(asset);
        }
        if ("3.1x".equals(version.getVersion()) && request != null) {
            query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.ASSET, assetType, businessEntity, request, ctx, 10000);
            this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, query);
        }
        if ("3.1x".equals(version.getVersion()) && request != null && request.isOwnerRequired()) {
            this.entityDataTransformer.enrichAssetsWithCustomerId((Set)allAssets, jwtToken);
        }
        return allAssets;
    }

    public Flux<Device> loadDevicesByType(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String deviceType, String jwtToken) {
        return Mono.fromCallable(() -> {
            EntityDataQuery query;
            long executionStartTs = System.currentTimeMillis();
            HashSet allDevices = Sets.newHashSet();
            TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
            PageDataIterable deviceIterator = null;
            if ("2.x".equals(version.getVersion())) {
                deviceIterator = new PageDataIterable(link -> this.loadDevicesPageV2(link, null, deviceType, jwtToken), 10000);
            } else if ("3.x".equals(version.getVersion()) || request == null) {
                deviceIterator = new PageDataIterableV3(link -> this.loadDevicesPageV3(link, null, deviceType, jwtToken), 10000);
            } else if ("3.1x".equals(version.getVersion())) {
                query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.DEVICE, deviceType, businessEntity, request, ctx, 10000);
                deviceIterator = new PageDataIterableV3Filterable(q -> this.loadDevicesPageV31Filter(request, q, null, jwtToken), query);
            } else {
                throw new IllegalStateException("Tb Version unknown " + version);
            }
            for (Device device : deviceIterator) {
                allDevices.add(device);
            }
            if ("3.1x".equals(version.getVersion()) && request != null) {
                query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.DEVICE, deviceType, businessEntity, request, ctx, 10000);
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, query);
            }
            if ("3.1x".equals(version.getVersion()) && request != null && request.isOwnerRequired()) {
                this.entityDataTransformer.enrichDevicesWithCustomerId((Set)allDevices, jwtToken);
            }
            this.statsCollector.tick("loadDevicesByType", executionStartTs, System.currentTimeMillis(), TickType.OTHER);
            return allDevices;
        }).subscribeOn(Schedulers.elastic()).flatMapIterable(l -> l);
    }

    public Flux<Device> loadDevicesByTypeAndCustomer(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String deviceType, JwtSecUser secUser, String jwtToken) {
        return Mono.fromCallable(() -> {
            EntityDataQuery query;
            HashSet allDevices = Sets.newHashSet();
            TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
            PageDataIterable deviceIterator = null;
            if ("2.x".equals(version.getVersion())) {
                deviceIterator = new PageDataIterable(link -> this.loadDevicesPageV2(link, secUser, deviceType, jwtToken), 10000);
            } else if ("3.x".equals(version.getVersion()) || request == null) {
                deviceIterator = new PageDataIterableV3(link -> this.loadDevicesPageV3(link, secUser, deviceType, jwtToken), 10000);
            } else if ("3.1x".equals(version.getVersion())) {
                query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.DEVICE, deviceType, businessEntity, request, ctx, 10000);
                deviceIterator = new PageDataIterableV3Filterable(q -> this.loadDevicesPageV31Filter(request, q, null, jwtToken), query);
            } else {
                throw new IllegalStateException("Tb Version unknown " + version);
            }
            for (Device device : deviceIterator) {
                allDevices.add(device);
            }
            if ("3.1x".equals(version.getVersion()) && request != null) {
                query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.DEVICE, deviceType, businessEntity, request, ctx, 10000);
                this.entityDataTransformer.fetchFilterValues(ctx, request, businessEntity, query);
            }
            if ("3.1x".equals(version.getVersion()) && request != null && request.isOwnerRequired()) {
                this.entityDataTransformer.enrichDevicesWithCustomerId((Set)allDevices, jwtToken);
            }
            return allDevices;
        }).subscribeOn(Schedulers.elastic()).flatMapIterable(l -> l);
    }

    public Set<Customer> loadCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecUser secUser, String jwtToken) {
        long executionStartTs = System.currentTimeMillis();
        HashSet allCustomers = Sets.newHashSet();
        TbVersion version = this.tbVersionChecker.getVersion(jwtToken);
        PageDataIterable customerIterator = null;
        if ("2.x".equals(version.getVersion())) {
            customerIterator = new PageDataIterable(link -> this.loadCustomersPageV2(link, secUser, jwtToken), 30000);
        } else if ("3.x".equals(version.getVersion())) {
            customerIterator = new PageDataIterableV3(link -> this.loadCustomersPageV3(link, secUser, jwtToken), 30000);
        } else if ("3.1x".equals(version.getVersion())) {
            EntityDataQuery query = this.tbFilterQueryBuilder.buildFilterQuery(EntityType.CUSTOMER, "", businessEntity, request, ctx, 30000);
            customerIterator = new PageDataIterableV3Filterable(q -> this.loadCustomersPageV31Filter(request, q, null, jwtToken), query);
        } else {
            throw new IllegalStateException("Tb Version unknown " + version);
        }
        for (Customer customer : customerIterator) {
            allCustomers.add(customer);
        }
        this.statsCollector.tick("loadCustomers", executionStartTs, System.currentTimeMillis(), TickType.OTHER);
        return allCustomers;
    }

    private TextPageData<Asset> loadAssetsPageV2(TextPageLink pageLink, JwtSecUser secUser, String assetType, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (TextPageData)this.tbApiSpec.userAssetsV2(this.webClient, this.baseURL, jwtToken, pageLink, assetType, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
            }
            return (TextPageData)this.tbApiSpec.tenantAssetsV2(this.webClient, this.baseURL, jwtToken, pageLink, assetType).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Asset> loadAssetsPageV31Filter(ViewRequest request, EntityDataQuery query, JwtSecUser secUser, String jwtToken) {
        return (PageData)this.loadAssetsPageV31FilterAsync(request, query, secUser, jwtToken).block();
    }

    private Mono<PageData<Asset>> loadAssetsPageV31FilterAsync(ViewRequest request, EntityDataQuery query, JwtSecUser secUser, String jwtToken) {
        try {
            if (this.tbVersionChecker.isWebosketApiAllowed()) {
                return this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                    this.totalRequestCount.incrementAndGet();
                    this.withRateLimiting();
                }).map(page -> this.entityDataTransformer.entityToAssetPageData(page)).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
            }
            return this.tbApiSpec.userEntitiesV31Filter(this.webClient, this.baseURL, jwtToken, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(page -> this.entityDataTransformer.entityToAssetPageData(page)).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Item> loadRawEntityData(EntityDataQuery query, String jwtToken) {
        try {
            long exchangeStartTs = System.currentTimeMillis();
            if (this.tbVersionChecker.isWebosketApiAllowed()) {
                return (PageData)this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                    this.totalRequestCount.incrementAndGet();
                    this.withRateLimiting();
                }).map(page -> this.entityDataTransformer.entityToItemPageData(page)).subscribeOn(this.otherScheduler).doOnNext(l -> this.statsCollector.tick("loadRawEntityData", exchangeStartTs, System.currentTimeMillis(), TickType.OTHER)).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
            }
            String key = "" + query;
            List data = (List)this.webClientCachier.getOrFetch("loadRawEntityData", key, jwtToken, () -> this.tbApiSpec.userEntitiesV31Filter(this.webClient, this.baseURL, jwtToken, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(page -> this.entityDataTransformer.entityToItemPageData(page)).doOnNext(l -> this.statsCollector.tick("loadRawEntityData", exchangeStartTs, System.currentTimeMillis(), TickType.OTHER)).flatMapIterable(Collections::singletonList).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler)).collectList().block();
            return (PageData)data.iterator().next();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public Mono<List<Device>> loadDevicesByIdsAsync(Set<UUID> deviceIds, String jwtToken) {
        try {
            long exchangeStartTs = System.currentTimeMillis();
            String[] strIds = deviceIds.stream().map(id -> id.toString()).collect(Collectors.toList()).toArray(new String[deviceIds.size()]);
            return this.tbApiSpec.deviceByIds(this.webClient, this.baseURL, strIds).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnNext(l -> this.statsCollector.tick("loadDevicesByIdsAsync", exchangeStartTs, System.currentTimeMillis(), TickType.OTHER)).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public List<Device> loadDevicesByIds(Set<UUID> deviceIds, String jwtToken) {
        try {
            return (List)this.loadDevicesByIdsAsync(deviceIds, jwtToken).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public Mono<List<Asset>> loadAssetsByIdsAsync(Set<UUID> assetIds, String jwtToken) {
        try {
            String[] strIds = assetIds.stream().map(id -> id.toString()).collect(Collectors.toList()).toArray(new String[assetIds.size()]);
            return this.tbApiSpec.assetByIds(this.webClient, this.baseURL, strIds).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public List<Asset> loadAssetsByIds(Set<UUID> assetIds, String jwtToken) {
        try {
            String[] strIds = assetIds.stream().map(id -> id.toString()).collect(Collectors.toList()).toArray(new String[assetIds.size()]);
            return (List)this.tbApiSpec.assetByIds(this.webClient, this.baseURL, strIds).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Asset> loadAssetsPageV3(PageLink pageLink, JwtSecUser secUser, String assetType, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (PageData)this.tbApiSpec.userAssetsV3(this.webClient, this.baseURL, jwtToken, pageLink, assetType, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
            }
            return (PageData)this.tbApiSpec.tenantAssetsV3(this.webClient, this.baseURL, jwtToken, pageLink, assetType).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private TextPageData<Device> loadDevicesPageV2(TextPageLink pageLink, JwtSecUser secUser, String deviceType, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (TextPageData)this.tbApiSpec.userDevicesV2(this.webClient, this.baseURL, jwtToken, pageLink, deviceType, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).publishOn(this.scheduler).block();
            }
            return (TextPageData)this.tbApiSpec.tenantDevicesV2(this.webClient, this.baseURL, jwtToken, pageLink, deviceType).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private Mono<PageData<Device>> loadDevicesPageV31FilterAsync(ViewRequest request, EntityDataQuery query, JwtSecUser secUser, String jwtToken) {
        try {
            if (this.tbVersionChecker.isWebosketApiAllowed()) {
                return this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                    this.totalRequestCount.incrementAndGet();
                    this.withRateLimiting();
                }).map(page -> this.entityDataTransformer.entityToDevicePageData(page)).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
            }
            return this.tbApiSpec.userEntitiesV31Filter(this.webClient, this.baseURL, jwtToken, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(page -> this.entityDataTransformer.entityToDevicePageData(page)).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler);
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Device> loadDevicesPageV31Filter(ViewRequest request, EntityDataQuery query, JwtSecUser secUser, String jwtToken) {
        return (PageData)this.loadDevicesPageV31FilterAsync(request, query, secUser, jwtToken).block();
    }

    private PageData<Device> loadDevicesPageV3(PageLink pageLink, JwtSecUser secUser, String deviceType, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (PageData)this.tbApiSpec.userDevicesV3(this.webClient, this.baseURL, jwtToken, pageLink, deviceType, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
            }
            return (PageData)this.tbApiSpec.tenantDevicesV3(this.webClient, this.baseURL, jwtToken, pageLink, deviceType).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private TextPageData<Customer> loadCustomersPageV2(TextPageLink pageLink, JwtSecUser secUser, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (TextPageData)this.tbApiSpec.userCustomersV2(this.webClient, this.baseURL, jwtToken, pageLink, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn((Object)new TextPageData(Collections.emptyList(), null, false)).doFinally(d -> this.releaseFromQueue(d)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
            }
            return (TextPageData)this.tbApiSpec.tenantCustomersV2(this.webClient, this.baseURL, jwtToken, pageLink).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Customer> loadCustomersPageV3(PageLink pageLink, JwtSecUser secUser, String jwtToken) {
        try {
            if (secUser != null && !secUser.getCustomerId().equals(EntityId.NULL_UUID)) {
                return (PageData)this.tbApiSpec.userCustomersV3(this.webClient, this.baseURL, jwtToken, pageLink, secUser.getCustomerId()).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn((Object)new PageData()).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
            }
            return (PageData)this.tbApiSpec.tenantCustomersV3(this.webClient, this.baseURL, jwtToken, pageLink).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).subscribeOn(Schedulers.elastic()).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    private PageData<Customer> loadCustomersPageV31Filter(ViewRequest request, EntityDataQuery query, JwtSecUser secUser, String jwtToken) {
        try {
            if (this.tbVersionChecker.isWebosketApiAllowed()) {
                return (PageData)this.wsClient.loadEntityDataByQuery(query, jwtToken).doOnRequest(v -> {
                    this.totalRequestCount.incrementAndGet();
                    this.withRateLimiting();
                }).map(page -> this.entityDataTransformer.entityToCustomerPageData(page)).subscribeOn(this.otherScheduler).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
            }
            return (PageData)this.tbApiSpec.userEntitiesV31Filter(this.webClient, this.baseURL, jwtToken, query).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(page -> this.entityDataTransformer.entityToCustomerPageData(page)).doFinally(arg_0 -> this.releaseFromQueue(arg_0)).publishOn(this.scheduler).block();
        }
        catch (HttpClientErrorException exception) {
            if (exception.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw exception;
        }
    }

    public Flux<AttributeData> loadAttribute(String entityType, UUID entityId, String scope, String key, String jwtToken) {
        return this.webClient.get().uri(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/attributes/{scope}?keys={keys}", new Object[]{entityType, entityId, scope, key}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToFlux(AttributeData.class).doFinally(d -> this.releaseFromQueue(d)).publishOn(this.scheduler);
    }

    public Mono<Map<String, List<TsData>>> loadTelemetry(String entityType, UUID entityId, String key, long startTs, long endTs, long interval, String agg, int pageSize, String jwtToken) {
        long executionStartTs = System.currentTimeMillis();
        String cacheKey = StringUtils.join((Object[])new Serializable[]{entityType, entityId, key, Long.valueOf(startTs), Long.valueOf(endTs), Long.valueOf(interval), agg});
        return this.webClientCachier.getOrFetchTelemetry(cacheKey, jwtToken, () -> this.webClient.get().uri(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/timeseries?keys={keys}&startTs={startTs}&endTs={endTs}&interval={interval}&agg={agg}&limit={pageSize}", new Object[]{entityType, entityId, key, startTs, endTs, interval, agg, pageSize}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doOnNext(l -> this.statsCollector.tick("loadTelemetry_" + key, executionStartTs, System.currentTimeMillis(), TickType.OTHER)).doFinally(d -> this.releaseFromQueue(d)).subscribeOn(this.otherScheduler).publishOn(this.scheduler));
    }

    public Mono<Map<String, List<TsData>>> loadLatestTelemetry(String entityType, UUID entityId, String key, String jwtToken) {
        return this.webClient.get().uri(this.baseURL + "/api/plugins/telemetry/{entityType}/{entityId}/values/timeseries?keys={keys}", new Object[]{entityType, entityId, key}).header(JWT_TOKEN_HEADER_PARAM, new String[]{"Bearer " + jwtToken}).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).doFinally(d -> this.releaseFromQueue(d)).subscribeOn(this.otherScheduler).publishOn(this.scheduler);
    }

    private void withRateLimiting() {
        long executionStartTs = System.currentTimeMillis();
        try {
            this.inProgressQueue.put(new Object());
            ConsumptionProbe probe = this.bucket.tryConsumeAndReturnRemaining(1L);
            while (!probe.isConsumed()) {
                try {
                    log.info("Rate limit reached. Wait {} ms", (Object)TimeUnit.NANOSECONDS.toMillis(probe.getNanosToWaitForRefill()));
                    TimeUnit.NANOSECONDS.sleep(probe.getNanosToWaitForRefill());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                probe = this.bucket.tryConsumeAndReturnRemaining(1L);
            }
        }
        catch (Throwable th) {
            this.inProgressQueue.poll();
            th.printStackTrace();
            throw new IllegalStateException("Error while wait for rate limiting TB API");
        }
        finally {
            this.statsCollector.tick("waitForQuota", executionStartTs, System.currentTimeMillis(), TickType.OTHER);
        }
    }

    private void releaseFromQueue(SignalType signalType) {
        this.inProgressQueue.poll();
        if (SignalType.CANCEL.equals((Object)signalType)) {
            Schedulers.parallel().schedule(this.inProgressQueue::clear, 5L, TimeUnit.SECONDS);
        }
    }

    static /* synthetic */ StatsCollector access$000(TbRestDataSource x0) {
        return x0.statsCollector;
    }
}

