/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.entity.relation.RelationNode;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.security.TokenExtractor;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbCustomerService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbItemService;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Service
public class TbItemService
implements ItemService {
    private static final Logger log = LoggerFactory.getLogger(TbItemService.class);
    @Autowired
    private BusinessEntityService businessEntityService;
    @Autowired
    private TbAssetService assetService;
    @Autowired
    private TbDeviceService deviceService;
    @Autowired
    private TbCustomerService customerService;
    @Autowired
    private TokenExtractor tokenExtractor;

    public Flux<Item> loadItems(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String jwtToken) {
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)businessEntity.getQuery();
        JwtSecUser secUSer = this.tokenExtractor.getJwtSecUser(jwtToken);
        if (!EntityId.NULL_UUID.equals(secUSer.getCustomerId())) {
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[query.getEntityType().ordinal()]) {
                case 1: {
                    return this.assetService.loadCustomerAssets(query, businessEntity, request, ctx, secUSer, jwtToken);
                }
                case 2: {
                    return this.deviceService.loadCustomerDevices(query, businessEntity, request, ctx, secUSer, jwtToken);
                }
                case 3: {
                    return this.customerService.loadCustomers(businessEntity, request, ctx, secUSer, jwtToken);
                }
            }
        } else {
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[query.getEntityType().ordinal()]) {
                case 1: {
                    return this.assetService.loadAssets(query, businessEntity, request, ctx, jwtToken);
                }
                case 2: {
                    return this.deviceService.loadDevices(query, businessEntity, request, ctx, jwtToken);
                }
                case 3: {
                    return this.customerService.loadCustomers(businessEntity, request, ctx, secUSer, jwtToken);
                }
            }
        }
        throw new IllegalStateException("Unexpected BusinessEntityType [" + businessEntity + "]");
    }

    public Flux<Item> loadRelated(ViewContext ctx, ViewRequest request, Flux<Item> parentItems, UUID parentBusinessEntityId, UUID businessEntityId, String jwtToken) {
        BusinessEntity parent = this.businessEntityService.findEntityById(ctx.getTenantId(), parentBusinessEntityId);
        BusinessEntity relatedBusinessEntity = this.businessEntityService.findEntityById(ctx.getTenantId(), businessEntityId);
        RelationNode parentNode = ctx.getRelationGraph().getNodeById(parentBusinessEntityId);
        RelationNode childNode = ctx.getRelationGraph().getNodeById(businessEntityId);
        Relation relation = (Relation)parentNode.getAdjacentNodes().get(childNode);
        if (relation == null) {
            throw new IllegalStateException("Expected relation between nodes was not found");
        }
        return this.loadItemsByRelationQuery(ctx, request, relation, relatedBusinessEntity, parentItems, parent, jwtToken);
    }

    private Flux<Item> loadItemsByRelationQuery(ViewContext ctx, ViewRequest request, Relation relation, BusinessEntity relatedBusinessEntity, Flux<Item> parentItems, BusinessEntity parent, String jwtToken) {
        TbRelationQuery relationQuery = (TbRelationQuery)relation.getQuery();
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)relatedBusinessEntity.getQuery();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[query.getEntityType().ordinal()]) {
            case 1: {
                return parentItems.flatMap(parentItem -> this.assetService.loadRelatedAssets(parentItem.getId(), parent, request, ctx, relationQuery, relatedBusinessEntity, jwtToken));
            }
            case 2: {
                return parentItems.flatMap(parentItem -> this.deviceService.loadRelatedDevices(parentItem.getId(), parent, request, ctx, relationQuery, relatedBusinessEntity, jwtToken));
            }
            case 3: {
                return parentItems.flatMap(parentItem -> this.customerService.loadRelatedCustomers(parentItem.getId(), parent, request, ctx, relationQuery, relatedBusinessEntity, jwtToken));
            }
        }
        throw new IllegalStateException("Unexpected BusinessEntityType [" + parent + "]");
    }
}

