/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.field.TbBusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.provider.PartitionBuilder;
import org.thingsboard.trendz.service.provider.TbFieldValueService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TelemetryPartitionQuery;
import org.thingsboard.trendz.service.state.State;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStore;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Service
public class TbFieldValueService {
    private static final Logger log = LoggerFactory.getLogger(TbFieldValueService.class);
    @Autowired
    private TbRestDataSource tbClient;
    @Autowired
    private FilterService filterService;
    @Autowired
    private PartitionBuilder partitionBuilder;

    public Flux<FieldValue> loadAttribute(Item item, ViewField viewField, BusinessEntityField entityField, BusinessEntity businessEntity, String jwtToken) {
        String attrValue;
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)businessEntity.getQuery();
        String entityType = query.getEntityType().name();
        TbBusinessEntityFieldQuery attrQuery = (TbBusinessEntityFieldQuery)entityField.getQuery();
        String scope = attrQuery.getScope();
        String key = attrQuery.getKey();
        if (MapUtils.isNotEmpty((Map)item.getAttributes()) && (attrValue = (String)item.getAttributes().get(key)) != null) {
            if (viewField.getAggregationType() == FieldAggregation.COUNT) {
                return Flux.just((Object)new FieldValue(item, FieldType.NUMERIC, (Object)1));
            }
            return Flux.just((Object)new FieldValue(item, FieldType.STRING, (Object)attrValue));
        }
        return this.tbClient.loadAttribute(entityType, item.getId(), scope, key, jwtToken).map(d -> this.mapAttr(item, entityField, viewField, d.getValue().toString())).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    public Flux<FieldValue> loadTelemetry(Item item, ViewField viewField, ViewRequest viewRequest, BusinessEntityField entityField, BusinessEntity businessEntity, WindowedStreamStore windowedStore, ViewContext ctx) {
        Set allowedTs;
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)businessEntity.getQuery();
        String entityType = query.getEntityType().name();
        TbBusinessEntityFieldQuery attrQuery = (TbBusinessEntityFieldQuery)entityField.getQuery();
        String key = attrQuery.getKey();
        long queryStartTs = viewRequest.getStartTs();
        long queryEndTs = viewRequest.getEndTs();
        if (viewField.getLocalTimeRange() != null) {
            Pair startEndPair = viewField.getLocalTimeRange().buildStartEndPair(viewRequest.getTzName());
            queryStartTs = (Long)startEndPair.getLeft();
            queryEndTs = (Long)startEndPair.getRight();
        }
        Set set = allowedTs = viewRequest.isStreamProcessingEnabled() ? this.getTimestampsForGroup(item, windowedStore, ctx) : null;
        if (viewRequest.isStreamProcessingEnabled() && entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY) {
            Optional lock = ctx.getStreamStore(entityField.getId()).getLoadLock(item, viewField.getAggregationType());
            if (lock.isPresent()) {
                try {
                    log.trace("Awaiting loading stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
                    ((CountDownLatch)lock.get()).await();
                    log.trace("Proceed with stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                log.trace("initial load stream data for {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
            }
            if (this.hasValuesInStore(ctx, entityField, item, viewField)) {
                ((CountDownLatch)ctx.getStreamStore(entityField.getId()).getLoadLock(item, viewField.getAggregationType()).get()).countDown();
                DateAggregationType usedDateAggregation = viewRequest.isUsePersistedCacheTelemetry() ? viewRequest.getCachingDateAggregationType() : viewRequest.getMinimalDateAggregation();
                return Flux.fromIterable((Iterable)this.partitionBuilder.buildPartitionQueries(queryStartTs, queryEndTs + 1L, viewField.getAggregationType(), usedDateAggregation, true)).flatMap(partition -> this.readFromStore(ctx, entityField, item, allowedTs, viewField, partition)).map(fv -> {
                    if (viewRequest.isCacheItemTelemetry() && viewField.getAggregationType() == FieldAggregation.COUNT) {
                        return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
                    }
                    return fv;
                }).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
            }
        }
        return this.readFromProvider(viewField, item, viewRequest, ctx, entityType, key, entityField, queryStartTs, queryEndTs).doOnNext(fv -> {
            if (viewRequest.isStreamProcessingEnabled() && entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY && viewField.getAggregationType() != FieldAggregation.NONE) {
                ctx.getStreamStore(entityField.getId()).add(businessEntity, item, viewField.getAggregationType(), fv);
            } else if (entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY && !viewField.isForStateCondition() && viewField.getAggregationType() == FieldAggregation.NONE && this.filterService.matchFieldValue(fv, viewField, viewRequest)) {
                ctx.addNoneAgrValue(viewField.getId(), fv);
            }
        }).map(fv -> {
            if (viewRequest.isCacheItemTelemetry() && viewField.getAggregationType() == FieldAggregation.COUNT) {
                return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
            }
            return fv;
        }).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs())).collectList().doOnNext(r -> {
            Optional lock = ctx.getStreamStore(entityField.getId()).getLoadLock(item, viewField.getAggregationType());
            if (lock.isPresent()) {
                log.trace("Release lock {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
                ((CountDownLatch)lock.get()).countDown();
            }
        }).map(l -> this.splitRangeBystates(l, viewRequest, ctx, viewField, windowedStore)).flatMapIterable(r -> r).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    private Flux<FieldValue> readFromProvider(ViewField viewField, Item item, ViewRequest viewRequest, ViewContext ctx, String entityType, String key, BusinessEntityField entityField, long queryStartTs, long queryEndTs) {
        List savedItemTelemetry;
        if (viewRequest.isCacheItemTelemetry() && viewField.getLocalTimeRange() == null && (savedItemTelemetry = item.getSavedItemTelemetry(queryStartTs, queryEndTs, key)) != null) {
            return Flux.fromIterable((Iterable)savedItemTelemetry);
        }
        DateAggregationType usedDateAggregation = viewRequest.isUsePersistedCacheTelemetry() ? viewRequest.getCachingDateAggregationType() : viewRequest.getMinimalDateAggregation();
        boolean loadRawData = viewRequest.isStreamProcessingEnabled() || viewRequest.isCacheItemTelemetry();
        return Flux.fromIterable((Iterable)this.partitionBuilder.buildPartitionQueries(queryStartTs, queryEndTs + 1L, viewField.getAggregationType(), usedDateAggregation, loadRawData)).parallel().runOn(Schedulers.parallel()).flatMap(partition -> {
            long start = System.currentTimeMillis();
            if (viewField.getAggregationType() == FieldAggregation.LATEST) {
                return this.tbClient.loadLatestTelemetry(entityType, item.getId(), key, ctx.getJwtToken()).doOnNext(i -> ctx.getStats().getFieldQueryTime().computeIfAbsent(viewField, k -> new AtomicLong()).addAndGet(System.currentTimeMillis() - start)).doOnNext(i -> ctx.getStats().getFieldQueryCount().computeIfAbsent(viewField, k -> new AtomicLong()).incrementAndGet());
            }
            return this.tbClient.loadTelemetry(entityType, item.getId(), key, partition.getStartTs(), partition.getEndTs(), partition.getInterval(), partition.getAgg(), 100000, ctx.getJwtToken()).doOnNext(i -> ctx.getStats().getFieldQueryTime().computeIfAbsent(viewField, k -> new AtomicLong()).addAndGet(System.currentTimeMillis() - start)).doOnNext(i -> ctx.getStats().getFieldQueryCount().computeIfAbsent(viewField, k -> new AtomicLong()).incrementAndGet());
        }).filter(map -> map.containsKey(key)).sequential().flatMapIterable(map -> (List)map.get(key)).map(kv -> this.mapWithTs(item, entityField, viewField, kv.getValue(), kv.getTs(), viewRequest)).collectList().doOnNext(list -> {
            if (viewRequest.isCacheItemTelemetry() && viewField.getLocalTimeRange() == null) {
                item.saveItemTelemetry(queryStartTs, queryEndTs, key, list);
            }
        }).flatMapIterable(l -> l);
    }

    private List<FieldValue> splitRangeBystates(List<FieldValue> values, ViewRequest request, ViewContext ctx, ViewField viewField, WindowedStreamStore streamStore) {
        if (!(!request.isSplitStates() || viewField.isStateField() || viewField.isForStateCondition() || values.isEmpty() || ctx.getComputedStates().isEmpty())) {
            List states = streamStore.getCurrentStates();
            if (CollectionUtils.isEmpty((Collection)states)) {
                Set items = values.stream().map(FieldValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
                states = items.stream().map(i -> (List)ctx.getStatesByItem().get(i.getId())).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            }
            long maxDuration = states.stream().mapToLong(s -> s.getEndTs() - s.getStartTs()).max().getAsLong();
            log.info("max duration = {} {}", (Object)TimeUnit.MILLISECONDS.toMinutes(maxDuration), (Object)TimeUnit.MILLISECONDS.toHours(maxDuration));
            values.sort(Comparator.comparingLong(FieldValue::getTs));
            boolean isInState = false;
            long tsDelta = Long.MIN_VALUE;
            ArrayList filtered = Lists.newArrayList();
            Iterator stateIterator = states.iterator();
            State state = new State(null, -1L, -1L);
            for (FieldValue value : values) {
                boolean skipField = false;
                while (!skipField && stateIterator.hasNext() && (value.getTs() < state.getStartTs() || value.getTs() > state.getEndTs())) {
                    if (value.getTs() < state.getStartTs()) {
                        skipField = true;
                        continue;
                    }
                    state = (State)stateIterator.next();
                    tsDelta = Long.MIN_VALUE;
                }
                if (skipField || value.getTs() < state.getStartTs() || value.getTs() > state.getEndTs()) continue;
                isInState = true;
                if (tsDelta == Long.MIN_VALUE) {
                    tsDelta = value.getTs() - 946684800000L;
                }
                value.setTs(value.getTs() - tsDelta);
                filtered.add(value);
            }
            return filtered;
        }
        return values;
    }

    private boolean hasValuesInStore(ViewContext ctx, BusinessEntityField entityField, Item item, ViewField viewField) {
        List values = (List)ctx.getStreamStore(entityField.getId()).getValuesByItem().get(item.getId() + "_" + viewField.getAggregationType());
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            return true;
        }
        List uniqValueFields = (List)ctx.getStreamStore(entityField.getId()).getValuesByItem().get(item.getId() + "_" + FieldAggregation.UNIQ);
        return CollectionUtils.isNotEmpty((Collection)uniqValueFields);
    }

    private Flux<FieldValue> readFromStore(ViewContext ctx, BusinessEntityField entityField, Item item, Set<Long> allowedTs, ViewField viewField, TelemetryPartitionQuery partition) {
        List itemValues = (List)ctx.getStreamStore(entityField.getId()).getValuesByItem().get(item.getId() + "_" + viewField.getAggregationType());
        if (CollectionUtils.isNotEmpty((Collection)itemValues)) {
            return Flux.fromIterable((Iterable)itemValues).filter(fv -> fv.getTs() >= partition.getStartTs() && fv.getTs() <= partition.getEndTs()).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs()));
        }
        List uniqValueFields = (List)ctx.getStreamStore(entityField.getId()).getValuesByItem().get(item.getId() + "_" + FieldAggregation.UNIQ);
        if (CollectionUtils.isNotEmpty((Collection)uniqValueFields)) {
            return Flux.fromIterable((Iterable)uniqValueFields).filter(fv -> fv.getTs() >= partition.getStartTs() && fv.getTs() <= partition.getEndTs()).filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs()));
        }
        return Flux.empty();
    }

    private Set<Long> getTimestampsForGroup(Item item, WindowedStreamStore windowedStore, ViewContext ctx) {
        Sets.SetView allowedTs = null;
        for (Map.Entry entry : windowedStore.getGroupKeys().entrySet()) {
            Set allowedValues;
            Object timestamps = new HashSet();
            StreamTelemetryStore streamStore = ctx.getStreamStore(((ViewField)entry.getKey()).getEntityFieldId());
            Set set = allowedValues = entry.getValue() instanceof Set ? (Set)entry.getValue() : Sets.newHashSet((Object[])new Object[]{entry.getValue()});
            if (streamStore.getValuesByItem().containsKey(item.getId())) {
                List itemValues = (List)streamStore.getValuesByItem().get(item.getId());
                if (CollectionUtils.isNotEmpty((Collection)itemValues)) {
                    timestamps = itemValues.stream().filter(fv -> allowedValues.contains(fv.getInnerValue())).map(FieldValue::getTs).collect(Collectors.toSet());
                }
            } else {
                timestamps = streamStore.getValuesByItem().values().stream().flatMap(Collection::stream).filter(fv -> allowedValues.contains(fv.getInnerValue())).map(FieldValue::getTs).collect(Collectors.toSet());
            }
            if (allowedTs == null) {
                allowedTs = timestamps;
                continue;
            }
            allowedTs = Sets.intersection(allowedTs, timestamps);
        }
        return allowedTs;
    }

    private FieldValue mapAttr(Item item, BusinessEntityField entityField, ViewField viewField, String strValue) {
        if (viewField.getAggregationType() == FieldAggregation.COUNT && StringUtils.isNotBlank((CharSequence)strValue)) {
            return new FieldValue(item, FieldType.NUMERIC, (Object)1);
        }
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
            case 1: {
                if (NumberUtils.isParsable((String)strValue)) {
                    return new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue));
                }
                return new FieldValue(item, FieldType.NUMERIC, null);
            }
            case 2: {
                if (NumberUtils.isParsable((String)strValue)) {
                    return new FieldValue(item, FieldType.DATE, (Object)Double.parseDouble(strValue));
                }
                return new FieldValue(item, FieldType.DATE, null);
            }
            case 3: {
                return new FieldValue(item, FieldType.STRING, (Object)strValue);
            }
            case 4: {
                return new FieldValue(item, FieldType.BOOLEAN, (Object)Boolean.parseBoolean(strValue));
            }
        }
        return null;
    }

    private FieldValue mapWithTs(Item item, BusinessEntityField entityField, ViewField viewField, String strValue, long ts, ViewRequest viewRequest) {
        if (viewRequest.isStreamProcessingEnabled() && entityField.getQuery().getQueryType() == FieldQueryType.TELEMETRY && viewField.getAggregationType() == FieldAggregation.COUNT) {
            return new FieldValue(item, FieldType.NUMERIC, (Object)1, ts);
        }
        if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            if (NumberUtils.isParsable((String)strValue)) {
                return new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
            }
            return new FieldValue(item, FieldType.NUMERIC, (Object)1, ts);
        }
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
            case 1: {
                if (StringUtils.isBlank((CharSequence)strValue)) {
                    return new FieldValue(item, FieldType.NUMERIC, null, ts);
                }
                if (NumberUtils.isParsable((String)strValue)) {
                    return new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
                }
                try {
                    return new FieldValue(item, FieldType.NUMERIC, (Object)Double.parseDouble(strValue), ts);
                }
                catch (NumberFormatException ex) {
                    return new FieldValue(item, FieldType.NUMERIC, null, ts);
                }
            }
            case 2: {
                if (NumberUtils.isParsable((String)strValue)) {
                    return new FieldValue(item, FieldType.DATE, (Object)Double.parseDouble(strValue), ts);
                }
                return new FieldValue(item, FieldType.DATE, null, ts);
            }
            case 3: {
                return new FieldValue(item, FieldType.STRING, (Object)strValue, ts);
            }
            case 4: {
                return new FieldValue(item, FieldType.BOOLEAN, (Object)Boolean.parseBoolean(strValue), ts);
            }
        }
        return null;
    }
}

