/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.TbBusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.relation.TbRelationQuery;
import org.thingsboard.trendz.domain.runtime.EnhancedDevice;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.JwtSecUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Component
public class TbDeviceService {
    @Autowired
    private TbRestDataSource tbClient;

    public Flux<Item> loadDevices(TbBusinessEntityQuery query, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, String jwtToken) {
        Flux devices = this.tbClient.loadDevicesByType(businessEntity, request, ctx, query.getType(), jwtToken);
        return this.map(devices, null);
    }

    public Flux<Item> loadCustomerDevices(TbBusinessEntityQuery query, BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecUser secUser, String jwtToken) {
        Flux devices = this.tbClient.loadDevicesByTypeAndCustomer(businessEntity, request, ctx, query.getType(), secUser, jwtToken);
        return this.map(devices, null);
    }

    public Flux<Item> loadRelatedDevices(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, TbRelationQuery relationQuery, BusinessEntity relatedBusinessEntity, String jwtToken) {
        TbBusinessEntityQuery entityQuery = (TbBusinessEntityQuery)relatedBusinessEntity.getQuery();
        TbBusinessEntityQuery query = (TbBusinessEntityQuery)parentEntity.getQuery();
        AssetId parent = new AssetId(parentId);
        if (query.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            parent = new DeviceId(parentId);
        } else if (query.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            parent = new CustomerId(parentId);
        }
        Flux relatedDevices = this.tbClient.findRelatedDevices(relatedBusinessEntity, request, ctx, relationQuery, entityQuery.getType(), (EntityId)parent, jwtToken);
        return this.map(relatedDevices, parentId);
    }

    public Set<String> loadDeviceTypes(String jwtToken) {
        return this.tbClient.loadDeviceTypes(jwtToken).stream().map(EntitySubtype::getType).collect(Collectors.toSet());
    }

    public Set<Device> loadDeviceByType(String type, String jwtToken) {
        return Sets.newHashSet((Iterable)((Iterable)this.tbClient.loadDevicesByType(null, null, null, type, jwtToken).collectList().block()));
    }

    private Flux<Item> map(Flux<Device> devices, UUID parent) {
        return devices.map(d -> {
            UUID ownerId = d.getOwnerId() != null ? d.getOwnerId().getId() : null;
            Item item = new Item(d.getUuidId(), parent, ownerId, d.getName(), d.getLabel());
            if (d instanceof EnhancedDevice) {
                item.setAttributes(((EnhancedDevice)d).getAttributes());
            }
            return item;
        });
    }
}

